/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GPASS_COMMAND_H__
#define __GPASS_COMMAND_H__

G_BEGIN_DECLS

#include "gpass/entry.h"

/***********************************************************
 *
 * GPassCommand
 *
 ***********************************************************/
typedef struct GPassCommand GPassCommand;
typedef struct GPassCommandClass GPassCommandClass;

#define GPASS_TYPE_COMMAND (gpass_command_get_type())
#define GPASS_COMMAND(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_COMMAND, GPassCommand))
#define GPASS_COMMAND_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_COMMAND, GPassCommandClass))
#define GPASS_IS_COMMAND(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_COMMAND))
#define GPASS_IS_COMMAND_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_COMMAND))
#define GPASS_COMMAND_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_COMMAND, GPassCommandClass))

struct GPassCommand {
    GObject parent;

    struct GPassApplication *application;
    gchar *description;
    GPassCommand *prev;
    GPassCommand *next;
};

struct GPassCommandClass {
    GObjectClass parent;
    
    GError *(*redo)(GPassCommand *self);
    GError *(*undo)(GPassCommand *self);
};

GType gpass_command_get_type(void);

GError *gpass_command_redo(GPassCommand *self);
GError *gpass_command_undo(GPassCommand *self);

/***********************************************************
 *
 * GPassNullCommand
 *
 ***********************************************************/
#define GPASS_TYPE_NULL_COMMAND (gpass_null_command_get_type())
#define GPASS_NULL_COMMAND(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_NULL_COMMAND, \
                                GPassNullCommand))
#define GPASS_NULL_COMMAND_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_NULL_COMMAND, \
                             GPassNullCommandClass))
#define GPASS_IS_NULL_COMMAND(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_NULL_COMMAND))
#define GPASS_IS_NULL_COMMAND_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_NULL_COMMAND))
#define GPASS_NULL_COMMAND_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_NULL_COMMAND, \
                               GPassNullCommandClass))

typedef struct {
    GPassCommand parent;
} GPassNullCommand;

typedef struct {
    GPassCommandClass parent;
} GPassNullCommandClass;

GType gpass_null_command_get_type(void);

/***********************************************************
 *
 * GPassTransactionCommand
 *
 ***********************************************************/
#define GPASS_TYPE_TRANSACTION_COMMAND (gpass_transaction_command_get_type())
#define GPASS_TRANSACTION_COMMAND(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_TRANSACTION_COMMAND, \
                                GPassTransactionCommand))
#define GPASS_TRANSACTION_COMMAND_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_TRANSACTION_COMMAND, \
                             GPassTransactionCommandClass))
#define GPASS_IS_TRANSACTION_COMMAND(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_TRANSACTION_COMMAND))
#define GPASS_IS_TRANSACTION_COMMAND_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_TRANSACTION_COMMAND))
#define GPASS_TRANSACTION_COMMAND_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_TRANSACTION_COMMAND, \
                               GPassTransactionCommandClass))

typedef struct {
    GPassCommand parent;
    
    GPassCommand *first;
    GPassCommand *last;
} GPassTransactionCommand;

typedef struct {
    GPassCommandClass parent;
} GPassTransactionCommandClass;

GType gpass_transaction_command_get_type(void);

void gpass_transaction_command_push(GPassTransactionCommand *self,
                                    GPassCommand *command);

/***********************************************************
 *
 * GPassCommandStack
 *
 ***********************************************************/
#define GPASS_COMMAND_STACK_MAX_DEPTH 15

#define GPASS_TYPE_COMMAND_STACK (gpass_command_stack_get_type())
#define GPASS_COMMAND_STACK(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_COMMAND_STACK, \
                                GPassCommandStack))
#define GPASS_COMMAND_STACK_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_COMMAND_STACK, \
                             GPassCommandStackClass))
#define GPASS_IS_COMMAND_STACK(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_COMMAND_STACK))
#define GPASS_IS_COMMAND_STACK_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_COMMAND_STACK))
#define GPASS_COMMAND_STACK_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_COMMAND_STACK, \
                               GPassCommandStackClass))

typedef struct {
    GObject parent;

    GPassCommand *top;
    GPassCommand *current;
    GPassCommand *base;
    gint max_depth;
    gint depth;
    gboolean removed_base;
} GPassCommandStack;

typedef struct {
    GObjectClass parent;
} GPassCommandStackClass;

GType gpass_command_stack_get_type(void);

void gpass_command_stack_push(GPassCommandStack *self, GPassCommand *command);
GError *gpass_command_stack_redo(GPassCommandStack *self);
GError *gpass_command_stack_undo(GPassCommandStack *self);
void gpass_command_stack_get_redo_description(GPassCommandStack *self,
                                              const gchar **description);
void gpass_command_stack_get_undo_description(GPassCommandStack *self,
                                              const gchar **description);
void gpass_command_stack_set_base(GPassCommandStack *self);
gboolean gpass_command_stack_at_base(GPassCommandStack *self);

/***********************************************************
 *
 * GPassEditCommand
 *
 ***********************************************************/
#define GPASS_TYPE_EDIT_COMMAND (gpass_edit_command_get_type())
#define GPASS_EDIT_COMMAND(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_EDIT_COMMAND, \
                                GPassEditCommand))
#define GPASS_EDIT_COMMAND_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_EDIT_COMMAND, \
                             GPassEditCommandClass))
#define GPASS_IS_EDIT_COMMAND(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_EDIT_COMMAND))
#define GPASS_IS_EDIT_COMMAND_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_EDIT_COMMAND))
#define GPASS_EDIT_COMMAND_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_EDIT_COMMAND, \
                               GPassEditCommandClass))

typedef struct {
    GPassCommand parent;

    GPassEntry *target;
    GPassEntry *edited;
} GPassEditCommand;

typedef struct {
    GPassCommandClass parent;
} GPassEditCommandClass;

GType gpass_edit_command_get_type(void);

/***********************************************************
 *
 * GPassLinkCommand
 *
 ***********************************************************/
#define GPASS_TYPE_LINK_COMMAND (gpass_link_command_get_type())
#define GPASS_LINK_COMMAND(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_LINK_COMMAND, \
                                GPassLinkCommand))
#define GPASS_LINK_COMMAND_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_LINK_COMMAND, \
                             GPassLinkCommandClass))
#define GPASS_IS_LINK_COMMAND(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_LINK_COMMAND))
#define GPASS_IS_LINK_COMMAND_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_LINK_COMMAND))
#define GPASS_LINK_COMMAND_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_LINK_COMMAND, \
                               GPassLinkCommandClass))

typedef struct {
    GPassCommand base;

    GPassEntry *target;
    GPassEntry *parent;
    GPassEntry *sibling;
    gboolean referenced;
} GPassLinkCommand;

typedef struct {
    GPassCommandClass parent;
} GPassLinkCommandClass;

GType gpass_link_command_get_type(void);
GPassCommand *gpass_edit_command_new(struct GPassApplication *application,
                                     GPassEntry *target, GPassEntry *edited);

/***********************************************************
 *
 * GPassInsertCommand
 *
 ***********************************************************/
#define GPASS_TYPE_INSERT_COMMAND (gpass_insert_command_get_type())
#define GPASS_INSERT_COMMAND(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_INSERT_COMMAND, \
                                GPassInsertCommand))
#define GPASS_INSERT_COMMAND_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_INSERT_COMMAND, \
                             GPassInsertCommandClass))
#define GPASS_IS_INSERT_COMMAND(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_INSERT_COMMAND))
#define GPASS_IS_INSERT_COMMAND_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_INSERT_COMMAND))
#define GPASS_INSERT_COMMAND_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_INSERT_COMMAND, \
                               GPassInsertCommandClass))

typedef struct {
    GPassLinkCommand parent;
} GPassInsertCommand;

typedef struct {
    GPassLinkCommandClass parent;
} GPassInsertCommandClass;

GType gpass_insert_command_get_type(void);
GPassCommand *gpass_insert_command_new(struct GPassApplication *application,
                                       GPassEntry *target, GPassEntry *parent,
                                       GPassEntry *sibling);

/***********************************************************
 *
 * GPassUnlinkCommand
 *
 ***********************************************************/
#define GPASS_TYPE_UNLINK_COMMAND (gpass_unlink_command_get_type())
#define GPASS_UNLINK_COMMAND(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_UNLINK_COMMAND, \
                                GPassUnlinkCommand))
#define GPASS_UNLINK_COMMAND_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_UNLINK_COMMAND, \
                             GPassUnlinkCommandClass))
#define GPASS_IS_UNLINK_COMMAND(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_UNLINK_COMMAND))
#define GPASS_IS_UNLINK_COMMAND_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_UNLINK_COMMAND))
#define GPASS_UNLINK_COMMAND_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_UNLINK_COMMAND, \
                               GPassUnlinkCommandClass))

typedef struct {
    GPassLinkCommand parent;
} GPassUnlinkCommand;

typedef struct {
    GPassLinkCommandClass parent;
} GPassUnlinkCommandClass;

GType gpass_unlink_command_get_type(void);
GPassCommand *gpass_unlink_command_new(struct GPassApplication *application,
                                       GPassEntry *target, GPassEntry *parent,
                                       GPassEntry *sibling);

/***********************************************************
 *
 * GPassMoveCommand
 *
 ***********************************************************/
#define GPASS_TYPE_MOVE_COMMAND (gpass_move_command_get_type())
#define GPASS_MOVE_COMMAND(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_MOVE_COMMAND, \
                                GPassMoveCommand))
#define GPASS_MOVE_COMMAND_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_MOVE_COMMAND, \
                             GPassMoveCommandClass))
#define GPASS_IS_MOVE_COMMAND(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_MOVE_COMMAND))
#define GPASS_IS_MOVE_COMMAND_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_MOVE_COMMAND))
#define GPASS_MOVE_COMMAND_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_MOVE_COMMAND, \
                               GPassMoveCommandClass))

typedef struct {
    GPassCommand base;
    
    GPassEntry *target;
    GPassEntry *parent;
    GPassEntry *previous;
} GPassMoveCommand;

typedef struct {
    GPassCommandClass parent;
} GPassMoveCommandClass;

GType gpass_move_command_get_type(void);
GPassCommand *gpass_move_command_new(struct GPassApplication *application,
                                     GPassEntry *target,
                                     GPassEntry *parent, GPassEntry *previous);
                                     
G_END_DECLS

#endif /* #ifndef __GPASS_COMMAND_H__ */
