/*
 * AllegroFont benchmark, for comparison with Glyph Keeper
 *
 * Copyright (c) 2003-2007 Kirill Kryukov
 *
 * This file is part of Glyph Keeper library, and may only be used,
 * modified, and distributed under the terms of the Glyph Keeper
 * license, located in the file 'license.txt' within this package.
 */

/* Standard includes. */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <limits.h>
#include <ctype.h>

/* Target library. */
#include <allegro.h>

/* Including AllegroFont source without header. */
/* Just to avoid messing with extra object files. */
#include "alfont.c"

/* Code shared by several benchmark programs. */
#include "bench_utils.c"



time_t start_time, now, now1;
int char_count = 0;

int info_color;

BITMAP* bmp = 0;



void update()
{
    int seconds = now1-start_time;
    int minutes = seconds/60;
    int hours;
    seconds -= minutes*60;
    hours = minutes/60;
    minutes -= hours*60;

    if (clip_on) set_clip_rect(bmp,0,0,screen_width-1,screen_height-1);
    rectfill(bmp,0,0,SCREEN_W-1,area_top-1,0);
    textprintf_ex(bmp,font,15,11,info_color,0,"%02d:%02d:%02d  %ld chars/sec",hours,minutes,seconds,char_count/(now1-start_time));
    if (clip_on) set_clip_rect(bmp,SCREEN_W/4,SCREEN_H/4,SCREEN_W*3/4,SCREEN_H*3/4);
    if (bmp!=screen) blit(bmp,screen,0,0,0,0,screen_width,screen_height);
}


int main(int argc,char *argv[])
{
    char buf[1000] = "";
    ALFONT_FONT *f1;

    init_benchmark("bench_alfont_alleg",argv[0],(argc>1)?argv[1]:0);
    if (!logfile) { return 1; }

    if (allegro_init()) { fprintf(logfile,"Can't init Allegro\n"); return 0; }
    if (install_keyboard())
        { fprintf(logfile,"Can't initialize keyboard\n"); return 0; }
    set_color_depth(color_depth);
    if (set_gfx_mode(GFX_AUTODETECT_WINDOWED,screen_width,screen_height,0,0) || !screen)
        if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN,screen_width,screen_height,0,0) || !screen)
            { fprintf(logfile,"Can't set graphics mode\n"); return 0; }
    info_color = makecol(128,192,128);

    if (draw_to_screen) bmp = screen;
    else
    {
        bmp = create_bitmap(screen_width,screen_height);
        if (!bmp) { fprintf(logfile,"Can't create buffer bitmap\n"); return 0; }
    }
    if (clip_on) set_clip_rect(bmp,SCREEN_W/4,SCREEN_H/4,SCREEN_W*3/4,SCREEN_H*3/4);

    alfont_init();

    /*
      Searching for a font file in path and loading it.
      GK can do this automatically when loading a font,
      but with AllegroFont we have to write code for it:
    */
    {
        FILE* file = fopen(font_file,"rb");
        if (!file && font_path && *font_path)
        {
            int fname_length = strlen(font_file);
            char* font_path_copy = strdup1(font_path);
            char* c = font_path_copy;
            while (!file && c && *c)
            {
                int dirname_length;
                char *c2 = strchr(c,';');
                if (!c2) c2 = strchr(c,0);
                dirname_length = c2-c;
                if (dirname_length + fname_length < 1000)
                {
                    strncpy(buf,c,dirname_length);
                    strncpy(buf+dirname_length,font_file,fname_length);
                    buf[dirname_length+fname_length] = 0;
                    fprintf(logfile,"Trying to open file %s\n",buf);
                    file = fopen(buf,"rb");
                }
                if (!*c2) break;
                c = c2+1;
            }
        }
        if (!file) { fprintf(logfile,"Error: can't find font file \"%s\"\n",font_file); return 0; }
        fclose(file);
    }
    fprintf(logfile,"Loading font from file \"%s\"\n",*buf?buf:font_file);

    f1 = alfont_load_font(*buf?buf:font_file);
    if (!f1) { fprintf(logfile,"AllegroFont can't load font from \"%s\"\n",*buf?buf:font_file); exit(1); }
    else { fprintf(logfile,"Font loaded successfully\n"); }

    alfont_set_font_size(f1,text_size);
    alfont_text_mode(-1);

    char_count = 0;
    { int zero = time(0); do time(&start_time); while (start_time==zero); }
    now = start_time;

    while (!key[KEY_SPACE] && !key[KEY_ESC])
    {
        int i=0;
        for (;i<100;i++)
        {
            int x,y,length,color;
            reset_x_y();
            reset_str8();

            color = rand_4();
            if (background_on) alfont_text_mode(rand_4()&0xFFFFFF);

            if (antialiasing_on) alfont_textout_aa(bmp,f1,(const char*)str8,x,y,color);
            else alfont_textout(bmp,f1,(const char*)str8,x,y,color);
            char_count += length;
        }
        now1 = time(0);
        if (now1!=now) { update(); now = now1; }
    }

    while (key[KEY_SPACE] || key[KEY_ESC]) { rest(1); }
    while (!key[KEY_SPACE] && !key[KEY_ESC]) { rest(1); }

    alfont_destroy_font(f1);
    alfont_exit();
    return 0;
}
END_OF_MAIN()
