/**
 * @file check-galagod.c Unit tests
 *
 * @Copyright (C) 2004-2006 Christian Hammond
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#include <glib.h>
#include <check.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>

#include "galagod.h"
#include "coco.h"
#include "filter.h"
#include "person-list.h"
#include "service-list.h"

/**************************************************************************
 * Coco stuff
 **************************************************************************/
START_TEST(test_coco_register)
{
	GalagodCoCo *coco;

	coco = galagod_coco_new("test-feed", TRUE, "123");
}
END_TEST


/**************************************************************************
 * 'Check' stuff
 **************************************************************************/
#define ADD_TCASE(name, func) \
	tc = tcase_create(name); \
	tcase_add_test(tc, (func)); \
	suite_add_tcase(s, tc)

static Suite *
make_galagod_suite(void)
{
	Suite *s;
	TCase *tc;

	s = suite_create("galagod");

	ADD_TCASE("coco_register", test_coco_register);

	return s;
}

#if 0 /* fix me */
static void
error_handler(GalagoLogLevel level, const char *fmt, va_list args,
			  void *user_data)
{
	char buf[BUFSIZ];

	vsnprintf(buf, sizeof(buf), fmt, args);
	fail(buf);
}
#endif

int
main(int argc, char **argv)
{
	Suite *s;
	SRunner *sr;
	int nf;

#if 0 /* fix me */
	galago_log_set_handler(GALAGO_LOG_WARNING, error_handler, NULL);
	galago_log_set_handler(GALAGO_LOG_ERROR,   error_handler, NULL);
	galago_log_set_handler(GALAGO_LOG_FATAL,   error_handler, NULL);
	galago_log_set_handler(GALAGO_LOG_ASSERT,  error_handler, NULL);
#endif
	galagod_init();

	s = make_galagod_suite();
	sr = srunner_create(s);

	srunner_set_log(sr, "check-galagod.log");
	srunner_run_all(sr, CK_NORMAL);

	nf = srunner_ntests_failed(sr);

	srunner_free(sr);

	return (nf == 0 ? EXIT_SUCCESS : EXIT_FAILURE);
}
