/**
 * @file coco.h Core Connection API
 *
 * Copyright (C) 2004-2006 Christian Hammond.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#ifndef _GALAGOD_COCO_H_
#define _GALAGOD_COCO_H_

#include <glib.h>
#include <libgalago/galago.h>

typedef struct _GalagodCoCo        GalagodCoCo;
typedef struct _GalagodCoCoClass   GalagodCoCoClass;
typedef struct _GalagodCoCoPrivate GalagodCoCoPrivate;

struct _GalagodCoCo
{
	GalagoObject parent_object;

	GalagodCoCoPrivate *priv;
};

struct _GalagodCoCoClass
{
	GalagoObjectClass parent_class;
};

#define GALAGOD_TYPE_COCO (galagod_coco_get_type())

GalagodCoCo *galagod_coco_new(const char *name, gboolean feed,
							  const char *dbus_id);

GalagoContext *galagod_coco_get_context(const GalagodCoCo *coco);
const char *galagod_coco_get_name(const GalagodCoCo *coco);
const char *galagod_coco_get_service_id(const GalagodCoCo *coco);
const char *galagod_coco_get_id(const GalagodCoCo *coco);
gboolean galagod_coco_is_feed(const GalagodCoCo *coco);

GalagodCoCo *galagod_cocos_get_with_id(const char *id);
GalagodCoCo *galagod_cocos_get_with_service_id(const char *service_id);
GalagodCoCo *galagod_cocos_get_with_obj_path(const char *obj_path);

void galagod_cocos_init();
void galagod_cocos_uninit();

#endif /* _GALAGOD_COCO_H_ */
