/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: InterfaceDialog.h 1891 2009-11-24 03:40:50Z vadim $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __INTERFACEDIALOG_H_
#define __INTERFACEDIALOG_H_

#include "../../config.h"
#include <ui_interfacedialog_q.h>
#include "BaseObjectDialog.h"
#include <QWidget>

#include "fwbuilder/FWObject.h"

#include <qmap.h>
#include <qstring.h>

class ProjectPanel;
class InterfaceDialog : public BaseObjectDialog
{
    Q_OBJECT;


    // netzoneObjectIDs : key - object id, value - number in the list
    QMap<int,int> netzoneObjectIDs;

    // netzoneObjectNos : key - number in the list, value - obj id
    QMap<int,int> netzoneObjectNos;

    Ui::InterfaceDialog_q *m_dialog;

 public:
    InterfaceDialog(QWidget *parent);
    ~InterfaceDialog();
    
    
public slots:
    virtual void applyChanges();
    virtual void loadFWObject(libfwbuilder::FWObject *obj);
    virtual void validate(bool*);
    virtual void openIfaceDialog();
    virtual void getHelpName(QString*);

};

#endif // INTERFACEDIALOG_H
