#ifndef MEMORY_HPP
#define MEMORY_HPP

#include "Compress.hpp"
#include "LinearMap.hpp"

#include <sys/types.h>

#define PARENT_MEMORY Compress
//#define PARENT_MEMORY File

/**
 * Class Memory represents memory backed file. It caches any writes to
 * the file and stores them in the memory. Memory blocks of some minimal
 * determined size are continually written to the disk.
 */
class Memory : public PARENT_MEMORY
{
	friend ostream &operator<<(ostream &os, const Memory &rMemory);

	typedef PARENT_MEMORY Parent;

	int write_block(bool force);
	int merge(const char *name);

	LinearMap	m_LinearMap;
	off_t		m_FileSize;
public:

	Memory(const struct stat *st);
	~Memory();

	int open(const char *name, int flags);

	int release(const char *name);

	int unlink(const char *name);

	int truncate(const char *name, off_t size);

	int getattr(const char *name, struct stat *st);

	ssize_t read(char *buf, size_t size, off_t offset);

	ssize_t write(const char *buf, size_t size, off_t offset);

};

ostream &operator<<(ostream &os, const Memory &rMemory);

#endif

