#include <cassert>
#include <cstring>
#include <iostream>

#include "CompressedTable.hpp"

#include "rlog/rlog.h"

CompressedTable::CompressedTable()
{
}

CompressedTable::~CompressedTable()
{
	m_table.clear();
}

void CompressedTable::Add(const char *ext)
{
	m_table.insert(ext);
}

void CompressedTable::Add(char *exts, const char *delim)
{
	char *ext;

	for (ext = strtok(exts, delim); ext; ext = strtok(NULL, delim))
	{
		Add(ext);
	}
}

bool CompressedTable::isForcedToCompress(const char *name) const
{
	assert (name);

	const char *p = strrchr(name, '.');

	if (p != NULL)
	{
		++p;

		if (m_table.find(p) != m_table.end())
		{
			return true;
		}
	}
	return false;
}

