#include <set>
#include <magic.h>

#include "Mutex.hpp"

using namespace std;

class CompressedMagic
{
	struct ltstr
	{
		bool operator()(const char *s1, const char *s2) const
		{
			// Ignore upper/lower case.
			//
			return strcasecmp(s1, s2) < 0;
		}
	};

	set<const char *, ltstr> m_table;

	magic_t m_magic;

	Mutex m_Mutex;

	void PopulateTable();
public:
	CompressedMagic();
	~CompressedMagic();

	bool isNativelyCompressed(const char *buf, int len);
	bool isNativelyCompressed(const char *name);
};

