#ifndef __DBUS_PROXY_DBUS_EXAMPLE_COMPUTER_H
#define __DBUS_PROXY_DBUS_EXAMPLE_COMPUTER_H

#include <dbus-cxx.h>

#include "computer.h"

#include "calculator_proxy.h"

namespace DBus {
  namespace Example {

    class ComputerProxy : public ::DBus::ObjectProxy
    {
      protected:
        ComputerProxy( ::DBus::Connection::pointer conn, const std::string& dest="dbuscxx.example.computer.server", const std::string& path="/dbuscxx/example/Computer"):
          ::DBus::ObjectProxy(conn, dest, path)
        {
          ::DBus::Path child_path;
          child_path = path; 
          child_path.append_element("Calculator");
          m_Calculator = CalculatorProxy::create(conn, dest, child_path);

          m_method_factorial_ty = this->create_method< uint64_t,uint8_t >( "Computer.Basic", "factorial" );
          m_method_fibonacci_ty = this->create_method< uint64_t,uint8_t >( "Computer.Basic", "fibonacci" );
          m_method_thue_morse_ty = this->create_method< uint64_t,uint8_t >( "Computer.Basic", "thue_morse" );
          m_signal_computation = this->create_signal<void,std::string,uint64_t,uint8_t>( "Computer.Basic", "computation" );
        }

      public:

        typedef DBusCxxPointer<ComputerProxy> pointer;

        static pointer create( ::DBus::Connection::pointer conn,
                               const std::string& dest="dbuscxx.example.computer.server",
                               const std::string& path="/dbuscxx/example/Computer"
                             )
        { return pointer( new ComputerProxy(conn, dest, path)); }

        CalculatorProxy::pointer calculator() { return m_Calculator; }

        uint64_t factorial( uint8_t n ) { return (*m_method_factorial_ty)( n); }

        uint64_t fibonacci( uint8_t n ) { return (*m_method_fibonacci_ty)( n); }

        uint64_t thue_morse( uint8_t n ) { return (*m_method_thue_morse_ty)( n); }

        ::DBus::signal_proxy<void,std::string,uint64_t,uint8_t >& signal_computation() { return *m_signal_computation; }


      protected:

        CalculatorProxy::pointer m_Calculator;

        ::DBus::MethodProxy<uint64_t,uint8_t>::pointer m_method_factorial_ty;
        ::DBus::MethodProxy<uint64_t,uint8_t>::pointer m_method_fibonacci_ty;
        ::DBus::MethodProxy<uint64_t,uint8_t>::pointer m_method_thue_morse_ty;
        ::DBus::signal_proxy<void,std::string,uint64_t,uint8_t>::pointer m_signal_computation;


    };

  }
}

#endif
