/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.readers.DefaultEntityHandler;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.StateMessageDatatype;
import org.apache.xerces.validators.datatype.StringDatatypeValidator;

public class ENTITYDatatypeValidator
extends StringDatatypeValidator {
    private static StringDatatypeValidator fgStrValidator = null;
    private DefaultEntityHandler fEntityHandler = null;
    private StringPool fStringPool = null;
    public static final int ENTITY_INITIALIZE = 0;

    public ENTITYDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public ENTITYDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
        Cloneable cloneable;
        if (bl) {
            return;
        }
        if (fgStrValidator == null) {
            cloneable = new Hashtable<String, String>();
            ((Hashtable)cloneable).put("whiteSpace", "collapse");
            ((Hashtable)cloneable).put("pattern", "[\\i-[:]][\\c-[:]]*");
            fgStrValidator = new StringDatatypeValidator(null, (Hashtable)cloneable, false);
        }
        if (datatypeValidator != null) {
            this.fEntityHandler = ((ENTITYDatatypeValidator)datatypeValidator).fEntityHandler;
            this.fStringPool = ((ENTITYDatatypeValidator)datatypeValidator).fStringPool;
        }
        cloneable = null;
        if (hashtable != null) {
            cloneable = (Vector)hashtable.get("enumeration");
        }
        if (cloneable != null) {
            int n = 0;
            try {
                while (n < ((Vector)cloneable).size()) {
                    fgStrValidator.validate((String)((Vector)cloneable).elementAt(n), null);
                    ++n;
                }
            }
            catch (Exception exception) {
                throw new InvalidDatatypeFacetException("Value of enumeration = '" + ((Vector)cloneable).elementAt(n) + "' must be from the value space of base.");
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    public int compare(String string, String string2) {
        return -1;
    }

    public short getWSFacet() {
        return fgStrValidator.getWSFacet();
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        StateMessageDatatype stateMessageDatatype = (StateMessageDatatype)object;
        if (stateMessageDatatype != null && stateMessageDatatype.getDatatypeState() == 0) {
            Object[] objectArray = (Object[])stateMessageDatatype.getDatatypeObject();
            this.fEntityHandler = (DefaultEntityHandler)objectArray[0];
            this.fStringPool = (StringPool)objectArray[1];
        } else {
            if (this.fEntityHandler == null) {
                throw new InvalidDatatypeValueException("ERROR: ENTITYDatatype Validator: Failed Initialization DefaultEntityHandler is null");
            }
            if (this.fStringPool == null) {
                throw new InvalidDatatypeValueException("ERROR: ENTITYDatatype Validator: Failed Initialization StrinPool is null");
            }
            super.validate(string, object);
            try {
                fgStrValidator.validate(string, null);
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                InvalidDatatypeValueException invalidDatatypeValueException2 = new InvalidDatatypeValueException("ID is not valid: " + string);
                invalidDatatypeValueException2.setMinorCode(79);
                invalidDatatypeValueException2.setMajorCode(77);
                throw invalidDatatypeValueException2;
            }
            int n = this.fStringPool.addSymbol(string);
            if (!this.fEntityHandler.isUnparsedEntity(n)) {
                InvalidDatatypeValueException invalidDatatypeValueException = new InvalidDatatypeValueException("ENTITY '" + string + "' is not valid");
                invalidDatatypeValueException.setMinorCode(79);
                invalidDatatypeValueException.setMajorCode(77);
                throw invalidDatatypeValueException;
            }
        }
        return null;
    }
}

