/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath;

import org.exolab.adaptx.xpath.XPathResult;

public final class NumberResult
extends XPathResult {
    public static final NumberResult NaN = new NumberResult(Double.NaN);
    private final double _value;

    public NumberResult(double d) {
        this._value = d;
    }

    public boolean booleanValue() {
        return this._value != 0.0;
    }

    public boolean equals(XPathResult xPathResult) {
        if (xPathResult == this) {
            return true;
        }
        if (xPathResult != null && xPathResult instanceof NumberResult) {
            return ((NumberResult)xPathResult)._value == this._value;
        }
        return false;
    }

    public int getResultType() {
        return 1;
    }

    public Object javaObject() {
        return new Double(this._value);
    }

    public double numberValue() {
        return this._value;
    }

    public String stringValue() {
        if (Double.isNaN(this._value)) {
            return "NaN";
        }
        if (this._value == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (this._value == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        int n = (int)this._value;
        if (this._value == (double)n) {
            return String.valueOf(n);
        }
        return String.valueOf(this._value);
    }

    public String toString() {
        return this.stringValue();
    }
}

