/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009  Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#include "Preferences.h"

PreferencesWindow::PreferencesWindow(QWidget *parent = 0)
    :QDialog(parent)
{
    if (objectName().isEmpty())
        setObjectName(QString::fromUtf8("PreferencesDialog"));
    resize(400, 175);
    gridLayout_6 = new QGridLayout(this);
    gridLayout_6->setObjectName(QString::fromUtf8("gridLayout_6"));
    tabWidget = new QTabWidget(this);
    tabWidget->setObjectName(QString::fromUtf8("tabWidget"));
    tab_General = new QWidget();
    tab_General->setObjectName(QString::fromUtf8("tab_General"));

    gridLayout_7 = new QGridLayout(tab_General);
    gridLayout_7->setObjectName(QString::fromUtf8("gridLayout"));
    accounts = new QListWidget(tab_General);
    accounts->setObjectName(QString::fromUtf8("accounts"));

    gridLayout_7->addWidget(accounts, 0, 0, 1, 3);

    btnAddAccount = new QToolButton(tab_General);
    btnAddAccount->setObjectName(QString::fromUtf8("btnAddAccount"));
    btnAddAccount->setPopupMode(QToolButton::InstantPopup);

    m_addItems = new QMenu(this);
    m_twitter = new QAction(QIcon(QString(":/Icons/Networks/twitter")), "Twitter", this);
    //m_identica = new QAction(QIcon(QString(":/Icons/Networks/identica")), "Identi.ca", this);

    m_addItems->addAction(m_twitter);
    //m_addItems->addAction(m_identica);

    btnAddAccount->setMenu(m_addItems);
    gridLayout_7->addWidget(btnAddAccount, 1, 0, 1, 1);

    btnRemoveAccount = new QToolButton(tab_General);
    btnRemoveAccount->setObjectName(QString::fromUtf8("btnRemoveAccount"));

    gridLayout_7->addWidget(btnRemoveAccount, 1, 1, 1, 1);
    
    tabWidget->addTab(tab_General, QString());

    tab_Style = new QWidget();
    tab_Style->setObjectName(QString::fromUtf8("tab_Style"));
    gridLayout_3 = new QGridLayout(tab_Style);
    gridLayout_3->setObjectName(QString::fromUtf8("gridLayout_3"));
    groupBox = new QGroupBox(tab_Style);
    groupBox->setObjectName(QString::fromUtf8("groupBox"));
    gridLayout_2 = new QGridLayout(groupBox);
    gridLayout_2->setObjectName(QString::fromUtf8("gridLayout_2"));
    label = new QLabel(groupBox);
    label->setObjectName(QString::fromUtf8("label"));

    gridLayout_2->addWidget(label, 0, 0, 1, 1);

    inactiveColor = new QLineEdit(groupBox);
    inactiveColor->setObjectName(QString::fromUtf8("inactiveColor"));
    QSizePolicy sizePolicy;
    sizePolicy.setHeightForWidth(inactiveColor->sizePolicy().hasHeightForWidth());
    inactiveColor->setSizePolicy(sizePolicy);

    gridLayout_2->addWidget(inactiveColor, 0, 1, 1, 1);

    selectInactive = new QPushButton(groupBox);
    selectInactive->setObjectName(QString::fromUtf8("selectInactive"));

    gridLayout_2->addWidget(selectInactive, 0, 2, 1, 1);

    label_2 = new QLabel(groupBox);
    label_2->setObjectName(QString::fromUtf8("label_2"));

    gridLayout_2->addWidget(label_2, 1, 0, 1, 1);

    activeColor = new QLineEdit(groupBox);
    activeColor->setObjectName(QString::fromUtf8("activeColor"));
    QSizePolicy sizePolicy2;
    sizePolicy2.setHeightForWidth(activeColor->sizePolicy().hasHeightForWidth());
    activeColor->setSizePolicy(sizePolicy2);

    gridLayout_2->addWidget(activeColor, 1, 1, 1, 1);

    selectActive = new QPushButton(groupBox);
    selectActive->setObjectName(QString::fromUtf8("selectActive"));

    gridLayout_2->addWidget(selectActive, 1, 2, 1, 1);
    gridLayout_3->addWidget(groupBox, 0, 0, 1, 2);

    label_3 = new QLabel(tab_Style);
    label_3->setObjectName(QString::fromUtf8("label_3"));

    gridLayout_3->addWidget(label_3, 1, 0, 1, 1);

    textSize = new QSpinBox(tab_Style);
    textSize->setObjectName(QString::fromUtf8("textSize"));
    sizePolicy.setHeightForWidth(textSize->sizePolicy().hasHeightForWidth());
    textSize->setSizePolicy(sizePolicy);
    textSize->setMinimum(0);
    textSize->setMaximum(40);
    textSize->setValue(5);

    gridLayout_3->addWidget(textSize, 1, 1, 1, 1);

    label_4 = new QLabel(tab_Style);
    label_4->setObjectName(QString::fromUtf8("label_4"));
    label_4->setIndent(15);

    gridLayout_3->addWidget(label_4, 2, 0, 1, 2);

    showDisplayPic = new QCheckBox(tab_Style);
    showDisplayPic->setObjectName(QString::fromUtf8("showDisplayPic"));

    hideToTray = new QCheckBox(tab_General);
    hideToTray->setObjectName(QString::fromUtf8("hideToTray"));
    hideToTray->setVisible(false);
    //gridLayout_3->addWidget(hideToTray, 3, 0, 1, 1);

    gridLayout_3->addWidget(showDisplayPic, 3, 0, 1, 1);

    verticalSpacer_2 = new QSpacerItem(99, 14, QSizePolicy::Minimum, QSizePolicy::Expanding);

    gridLayout_3->addItem(verticalSpacer_2, 4, 0, 1, 1);

    tabWidget->addTab(tab_Style, QString());
    gridLayout_6->addWidget(tabWidget, 0, 0, 1, 1);

    buttonBox = new QDialogButtonBox(this);
    buttonBox->setObjectName(QString::fromUtf8("buttonBox"));
    buttonBox->setOrientation(Qt::Horizontal);
    buttonBox->setStandardButtons(QDialogButtonBox::Cancel|QDialogButtonBox::Ok);

    gridLayout_6->addWidget(buttonBox, 1, 0, 1, 1);

    tabWidget->setCurrentIndex(0);

    setWindowTitle(tr("Cardinal Preferences"));
    hideToTray->setText(tr("Hide to System Tray on Minimize"));
    tabWidget->setTabText(tabWidget->indexOf(tab_General), tr("Accounts"));
    groupBox->setTitle(tr("Text Colors"));
    label->setText(tr("Normal:"));
    selectInactive->setText(tr("Select"));
    label_2->setText(tr("Selected:"));
    selectActive->setText(tr("Select"));
    label_3->setText(tr("Text Size:"));
    textSize->setSuffix(tr(" pixels"));
    label_4->setText(tr("<i>Use 0 pixels for system default</i>"));
    showDisplayPic->setText(tr("Hide Display Pictures"));
    btnAddAccount->setText(tr("Add Account"));
    btnRemoveAccount->setText(tr("Remove Account"));

    tabWidget->setTabText(tabWidget->indexOf(tab_Style), tr("Style"));

    connect(selectActive, SIGNAL(clicked()), this, SLOT(activeColorRequested()));
    connect(selectInactive, SIGNAL(clicked()), this, SLOT(inactiveColorRequested()));

    connect(m_twitter, SIGNAL(triggered()), this, SLOT(addTwitterAccount()));
    connect(btnRemoveAccount, SIGNAL(pressed()), this, SLOT(removeAccount()));
    connect(accounts, SIGNAL(doubleClicked(QModelIndex)), this, SLOT(changeAccount(QModelIndex)));

    connect(accounts, SIGNAL(currentRowChanged(int)), this, SLOT(currentRowChanged(int)));
    QSettings settings("Cardinal", "Cardinal");
    inactiveColor->setText(settings.value("inactiveColor").toString());
    activeColor->setText(settings.value("activeColor").toString());
    textSize->setValue(settings.value("textSize").toInt());

    hideToTray->setChecked(settings.value("hideToTray").toBool());
    showDisplayPic->setChecked(settings.value("showPic").toBool());
    btnRemoveAccount->setEnabled(false);
    connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
    connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));

    settings.beginGroup("Accounts");
    QStringList accts = settings.childGroups();
    for (int i = 0; i < accts.count(); ++i)
    {
        QListWidgetItem *item = new QListWidgetItem(QIcon(QString(":/Icons/Networks/twitter")), accts[i]);
        accounts->addItem(item);
    }
    settings.endGroup();
}

void PreferencesWindow::accept()
{
    QSettings settings("Cardinal", "Cardinal");
    settings.setValue("inactiveColor", inactiveColor->text());
    settings.setValue("activeColor", activeColor->text());
    settings.setValue("textSize", textSize->value());
    settings.setValue("hideToTray", hideToTray->checkState());
    settings.setValue("showPic", showDisplayPic->checkState());


    hide();

    emit accepted();
}

void PreferencesWindow::reject()
{
    hide();
}

void PreferencesWindow::activeColorRequested()
{
    active = new QColorDialog(this);
    connect(active, SIGNAL(colorSelected(const QColor)), this, SLOT(changeActiveColor(const QColor)));
    active->open();
}

void PreferencesWindow::inactiveColorRequested()
{
    inactive = new QColorDialog(this);
    connect(inactive, SIGNAL(colorSelected(const QColor)), this, SLOT(changeInactiveColor(const QColor)));
    inactive->open();
}

void PreferencesWindow::changeActiveColor(const QColor color)
{
    activeColor->setText(color.name());
    active->close();
    active->deleteLater();
}

void PreferencesWindow::changeInactiveColor(const QColor color)
{
    inactiveColor->setText(color.name());
    inactive->close();
    inactive->deleteLater();
}

void PreferencesWindow::addTwitterAccount()
{
    TwitterRegistrationWizard *reg = new TwitterRegistrationWizard(this);
    if(reg->exec()) {}
    QString account = reg->account();
     
    if(account == "")
        return;

    QSettings settings("Cardinal", "Cardinal");
    settings.beginGroup("Accounts");
    QStringList accts = settings.childGroups();
    if(!accts.contains(account))
        return;

    emit accountAdded(account);
    QListWidgetItem *item = new QListWidgetItem(QIcon(QString(":/Icons/Networks/twitter")), account);
    accounts->addItem(item);
    delete reg;
}

void PreferencesWindow::removeAccount()
{
    QString account = accounts->currentItem()->text();
    QSettings settings("Cardinal", "Cardinal");
    settings.beginGroup("Accounts");
    settings.remove(account);
    settings.endGroup();
    accounts->setItemHidden(accounts->item(accounts->currentRow()), true);
    emit accountRemoved(account);
}

void PreferencesWindow::changeAccount(QModelIndex idx)
{
    Q_UNUSED(idx);
    QString account = accounts->currentItem()->text();
    AccountEditor *acct = new AccountEditor(account, this);
    if(acct->exec()) {}
    delete acct;
}

void PreferencesWindow::currentRowChanged(int row)
{
    if(row == -1)
        btnRemoveAccount->setEnabled(false);
    else
        btnRemoveAccount->setEnabled(true);
}
