/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009  Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#include "CategoryEditor.h"

CategoryEditor::CategoryEditor(QWidget *parent, QString uname, QString category)
    :QDialog(parent),
    cat(category),
    m_user(uname)
{
	if (objectName().isEmpty())
	  setObjectName(QString::fromUtf8("cardinalPreferencesDialog"));
	
	resize(150, 200);
        setWindowTitle(tr("Editing Category: %1").arg(category));

	layout = new QGridLayout(this);
	m_items = new QListWidget(this);
	m_btnOK = new QPushButton(this);
	m_addUser = new QPushButton(this);
	m_addSearch = new QPushButton(this);

	m_btnOK->setText(tr("OK"));
	m_addUser->setText(tr("Add User"));
	m_addSearch->setText(tr("Add Search String"));

	layout->addWidget(m_items, 0, 0, 2, 3);
	layout->addWidget(m_addUser, 2, 0, 1, 1);
	layout->addWidget(m_addSearch, 2, 1, 1, 1);
	layout->addWidget(m_btnOK, 2, 2, 1, 1);

	connect(m_btnOK, SIGNAL(clicked()), this, SLOT(accept()));
	connect(m_addUser, SIGNAL(clicked()), this, SLOT(addUser()));
	connect(m_addSearch, SIGNAL(clicked()), this, SLOT(addSearch()));

	QSettings settings("Cardinal", "Cardinal");
        settings.beginGroup("Accounts");
        settings.beginGroup(m_user);
	settings.beginGroup("Categories");
	settings.beginGroup(category);
	QStringList cats = settings.childKeys();
	for (int i = 0; i < cats.count(); ++i)
	{
		if(cats[i] != "Name")
                        m_items->addItem(tr("%1 (%2)").arg(cats[i]).arg(settings.value(cats[i]).toString()));
	}
	settings.endGroup();
	settings.endGroup();
}

CategoryEditor::~CategoryEditor()
{

}

void CategoryEditor::addUser()
{
    QString uname = 
        QInputDialog::getText(this, tr("Add Username"), tr("Add a username to this category"), QLineEdit::Normal);

    if(uname == QString(""))
        return;

	QSettings settings("Cardinal", "Cardinal");
        settings.beginGroup("Accounts");
        settings.beginGroup(m_user);
        settings.beginGroup("Categories");
	settings.beginGroup(cat);
	settings.setValue(uname, "Username");
	settings.endGroup();
        settings.endGroup();
        settings.endGroup();
        settings.endGroup();
	
        m_items->addItem(tr("%1 (Username)").arg(uname));
}

void CategoryEditor::addSearch()
{    
    QString search = 
        QInputDialog::getText(this, tr("Add Search String"), tr("Add a search string to this category"), QLineEdit::Normal);

    if(search == QString(""))
        return;

    QSettings settings("Cardinal", "Cardinal");
    settings.beginGroup("Accounts");
    settings.beginGroup(m_user);
    settings.beginGroup("Categories");
    settings.beginGroup(cat);
    settings.setValue(search, "Search");
    settings.endGroup();
    settings.endGroup();
    settings.endGroup();
    settings.endGroup();
    m_items->addItem(tr("%1 (Search)").arg(search));
}
