
#include "QTwitLib.h"
#include "Core.h"

//=====================================================================
QTwitLib::QTwitLib()
{}
//=====================================================================
QTwitLib::~QTwitLib()
{}
//=====================================================================
void QTwitLib::setToken(token_t token)
{
    Core::setToken(token);
}
//=====================================================================
void QTwitLib::GetPublicTimeline()
{
    Core::GetPublicTimeline();
}
//=====================================================================
void QTwitLib::GetSingleStatus(unsigned long long int id)
{
    Core::GetSingleStatus(QString::number(id));
}
//=====================================================================
void QTwitLib::GetFeaturedUsers()
{
    Core::GetFeaturedUsers();
}
//=====================================================================
void QTwitLib::Logout()
{
    Core::Logout();
}
//=====================================================================
void QTwitLib::Abort()
{
    Core::Abort();
}
//=====================================================================
void QTwitLib::IsTwitterUp()
{
    Core::IsTwitterUp();
}
//=====================================================================
void QTwitLib::GetUsersTimeline(unsigned long long int id = 0)
{
    Core::GetUsersTimeline(id);
}
//=====================================================================
void QTwitLib::GetFavorites(QString user  /*=""*/, unsigned int page  /*=1*/)
{
    Core::GetFavorites(user, page);
}
//=====================================================================
void QTwitLib::GetFriendsTimeline(SERVER::Option1 *opt  /*=NULL*/)
{
    Core::GetFriendsTimeline(opt);
}
//=====================================================================
void QTwitLib::PostNewStatus(QString status, unsigned long long int in_reply_to_status_id, QString source)
{
    Core::PostNewStatus(status, QString::number(in_reply_to_status_id), source);
}
//=====================================================================
void QTwitLib::GetRecentMentions(SERVER::Option3 *opt  /*=NULL*/)
{
    Core::GetRecentMentions(opt);
}
//=====================================================================
void QTwitLib::RemoveStatus(unsigned long long int id)
{
    Core::RemoveStatus(QString::number(id));
}
//=====================================================================
void QTwitLib::GetFriends(unsigned long long int id)
{
    Core::GetFriends(id);
}
//=====================================================================
void QTwitLib::GetFollowers(unsigned long long int id)
{
    Core::GetFollowers(id);
}
//=====================================================================
void QTwitLib::GetUserDetails(unsigned long long int id)
{
    Core::GetUserDetails(id);
}
//=====================================================================
void QTwitLib::GetSentDirectMessages(SERVER::Option5 *opt  /*=NULL*/)
{
    Core::GetSentDirectMessages(opt);
}
//=====================================================================
void QTwitLib::GetReceivedDirectMessages(SERVER::Option5 *opt  /*=NULL*/)
{
    Core::GetReceivedDirectMessages(opt);
}
//=====================================================================
void QTwitLib::SendDirectMessage(unsigned long long int id, QString text)
{
    Core::SendDirectMessage(id, text);
}
//=====================================================================
void QTwitLib::RemoveDirectMessage(unsigned long long int id)
{
    Core::RemoveDirectMessage(QString::number(id));
}
//=====================================================================
void QTwitLib::AddFriendship(QString user, bool follow /*=true*/)
{
    Core::AddFriendship(user, follow);
}
//=====================================================================
void QTwitLib::RemoveFriendship(QString user)
{
    Core::RemoveFriendship(user);
}
//=====================================================================
void QTwitLib::FriendshipExist(QString user_a, QString user_b)
{
    Core::FriendshipExist(user_a, user_b);
}
//=====================================================================
void QTwitLib::VerifyCredentials()
{
    Core::VerifyCredentials();
}
//=====================================================================
void QTwitLib::UpdateDeliveryDevice(SERVER::DEVICES device)
{
    Core::UpdateDeliveryDevice(device);
}
//=====================================================================
void QTwitLib::RemainingApiRequests()
{
    Core::RemainingApiRequests();
}
//=====================================================================
void QTwitLib::AddFavorite(unsigned long long int id)
{
    Core::AddFavorite(QString::number(id));
}
//=====================================================================
void QTwitLib::RemoveFavorite(unsigned long long int id)
{
    Core::RemoveFavorite(QString::number(id));
}
//=====================================================================
void QTwitLib::UpdateProfileColors(QString background_color, QString text_color, QString link_color, QString sidebar_fill_color , QString sidebar_border_color)
{
    Core::UpdateProfileColors(background_color, text_color,link_color,sidebar_fill_color, sidebar_border_color);
}
//=====================================================================
void QTwitLib::UpdateProfile(QString name, QString email, QString url, QString location, QString description)
{
    Core::UpdateProfile(name, email, url, location, description);
}
//=====================================================================
void QTwitLib::EnableNotifications(QString id)
{
    Core::EnableNotifications(id);
}
//=====================================================================
void QTwitLib::DisableNotifications(QString id)
{
    Core::DisableNotifications(id);
}
//=====================================================================
void QTwitLib::BlockUser(QString id)
{
    Core::BlockUser(id);
}
//=====================================================================
void QTwitLib::UnBlockUser(QString id)
{
    Core::UnBlockUser(id);
}
//=====================================================================
void QTwitLib::GetFriendsIDs(QString id, QString user_id, QString screen_name)
{
    Core::GetFriendsIDs(id, user_id, screen_name);
}
//=====================================================================

void QTwitLib::GetFollowersIDs(QString id,QString user_id, QString screen_name)
{
    Core::GetFollowersIDs(id, user_id, screen_name);
}
//=====================================================================

void QTwitLib::SearchByString(QString searchString)
{
    Core::SearchByString(searchString);
}

void QTwitLib::Retweet(QString id)
{
    Core::Retweet(id);
}

void QTwitLib::RetrieveRetweets(QString id)
{
    Core::RetrieveRetweets(id);
}
