/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009  Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/


#ifndef TWEETMODEL_H
#define TWEETMODEL_H

#include <QAbstractListModel>
#include <QtGui>
#include <QtCore>

#include "tweet.h"

class TweetModel : public QAbstractListModel
{
    friend class Cardinal;
    Q_OBJECT;
public:
    TweetModel(QTableView *m_view, QObject *parent, QList<tweet*> m_list);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
private:
    QTableView *view;
    QList<tweet*> list;
};

#endif
