/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009-2010 Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/


#ifndef TWEDIT_H
#define TWEDIT_H

#include "cardinal.h"

class Editor : public QDialog
{
    Q_OBJECT
public:
    Editor(QWidget *parent);
    void setDirectMsgInformation(QString account, unsigned long long int target);
    void setReplyInformation(QString account, QString text, unsigned long long int rid);
    void clear();
protected slots:
    void editorKeyPressed();
    void wantToSubmit();
signals:
    void submitTweet(QString account, QString text, unsigned long long int id = 0);
    void submitDirectMsg(QString account, QString text, unsigned long long int id);
private:
    void buildAccountList();
    QGridLayout *gridLayout;
    QLabel *m_action;
    QSpacerItem *horizontalSpacer;
    QPushButton *m_send;
    QPlainTextEdit *tweetEditor;
    QLabel *label;
    QComboBox *comboBox;
    unsigned long long int id;
    unsigned long long int did;
    bool isDirectMsg;
};

#endif
