/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009  Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#ifndef IDENTITYMANAGER_H
#define IDENTITYMANAGER_H

#include "cardinal.h"

/* IdentityManager is an interface to a Twitter/Identi.ca Identity.
   This handles a single account and handles the connections and interactions.

*/

class IdentityManager : public QObject
{
    Q_OBJECT
public:
    IdentityManager(bool search = false);
    ~IdentityManager();
    void initConnection(QString);
    bool hasIdentities();
    void Logout();
    bool isFirstRun();
    void reload();
    void GetUserDetails(unsigned long long int);
    void submitTweet(QString, unsigned long long int);
    void submitDM(QString, unsigned long long int);
    user_t identSelf();
    void getTweetById(unsigned long long int);
    void AddFriendship(unsigned long long int);
    void RemoveFriendship(unsigned long long int);
    void BlockUser(QString);
    void Retweet(unsigned long long int);
    void GetRetweets(unsigned long long int);
    void DeleteStatus(unsigned long long int);
    void MarkAsFavorite(unsigned long long int id, bool favorite);
    void search(QString search);
protected:
    QTwitLib *m_bird;
protected slots:
    void hpTimeout();
    void birdResponseReceived(Returnables::Response*);
    void badLogin();
private:
    void showFriendTimeline(QLinkedList<Returnables::StatusElement*>);
    void newDirectMessages(QLinkedList<Returnables::DirectMessageElement*>);
    void showMentions(QLinkedList<Returnables::StatusElement*>);
    void showSearchResults(QLinkedList<Returnables::StatusElement*> list, QString searchStr);
    void showSingleStatus(Returnables::SingleStatus *status);
    void showRetweetsForId(Returnables::RetweetsForStatus *retweets);
    void runSearch();
    QStringList addCategoryBySearch(QString search);

    QString uname;
    bool firstRun;
    bool tweetMe;
    user_t self;
    bool m_online;
    apilimit_t apiData;
    QTimer *hpTimer;
    bool m_search;
    QList<unsigned long long int> m_rtCheck;
signals: 
    void addNewTweet(tweet_t, int);
    void hideEditor();
    void isOnline();
    void showInfoDialog(user_t);
    void updateAPIData(apilimit_t);
    void showNotification();
    void working(bool);
    void retweetedByMe(unsigned long long int);
    void idsForRetweet(unsigned long long int, QList<user_t>);
    void statusRemoved(unsigned long long int);
    void markedAsFavorite(unsigned long long int, bool);
};

#endif // IDENTITYMANAGER_H
