/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009  Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#ifndef CARDINAL_H
#define CARDINAL_H

#include <QtGui>
#include <QtCore>
#include <QPalette>
#include <qlist.h>
#include <QHttp>

#include <time.h>
#include <math.h>
#include <stdlib.h>

#ifdef _WIN32
#include <windows.h>
#endif

#include "QTwitLib.h"

#include "twedit.h"
#include "Preferences.h"
#include "aboutdialog.h"
#include "supertweet.h"

#define VERSION "0.4.5"

#ifdef _MACOS
#define USE_GROWL	true
#endif

#define TIMELINE_TWEET  0
#define DIRECT_MESSAGE  1
#define NEW_STATUS      2
#define MENTION         3
#define THREAD	    	5
#define SEARCH          6

#define TWITTER         0
#define IDENTICA        1

#define SUPERCOW        1

struct apilimit_ {
    unsigned int remainingHits;
    unsigned int limit;
    QString reset;
    unsigned int ts;
};

struct user_
{
    unsigned long long int id;
    QString name;
    QString screenName;
    QString imageURL;
    QString location;
    QString url;
    unsigned int followers;
    unsigned int friends;
    bool following;
    unsigned int tweets;
    QString profile;
};

struct tweet_
{
    QString userName;
    QString screenName;
    time_t time;
    unsigned long long int id;
    unsigned long long int uid;
    unsigned long long int reply;
    QString tweet;
    QString picUri;
    QStringList categories;
    QString useragent;
    bool favorite;
};

typedef struct apilimit_ apilimit_t;
typedef struct user_ user_t;
typedef struct tweet_ tweet_t;

/* these includes come last as they are dependant on the previous structs */

/* #include "tweet.h"
#include "NotificationAgent.h"

#include "twedit.h"
#include "CategoryEditor.h"
#include "preferenceswindow.h"
#include "aboutdialog.h"
#include "supertweet.h"
#include "infownd.h"
#include "StatusTableView.h"

#include "guimain.h"
*/

#endif
