/************************************

cardinal - a proper cross platthis twitter client
Copyright (C) 2009  Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/
#ifndef PROFILEMGR
#define PROFILEMGR

#include "cardinal.h"
#include <QNetworkDiskCache>

class ProfilePictureManager : public QObject
{
    Q_OBJECT
public:
    ProfilePictureManager(QObject *parent = 0, bool useId = true);
    void retrievePicture(unsigned long long int id, QString url);
    void retrievePictureByName(QString name, QString url);
signals:
    void pictureRecieved(unsigned long long int id, QByteArray pictureData);
    void pictureRecievedAlt(QString name, QByteArray pictureData);
protected slots:
    void finished(QNetworkReply *);
private:
    QNetworkAccessManager *m_http;
    QNetworkDiskCache *m_cache;
    QHash<unsigned long long int, QString> m_waiting;
    bool m_useId;
    QHash<QString, QString> m_waitingAlt;
};

#endif /* PROFILEMGR */
