/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009-2010  Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#ifndef PREFERENCES_H
#define PREFERENCES_H

#include "cardinal.h"
#include "AccountManager.h"
#include "TwitterRegistration.h"

class PreferencesWindow : public QDialog
{
    Q_OBJECT
public:
    PreferencesWindow(QWidget *parent);
protected slots:
    void accept();
    void reject();
    void activeColorRequested();
    void inactiveColorRequested();
    void changeActiveColor(const QColor);
    void changeInactiveColor(const QColor);
    void addTwitterAccount();
    void removeAccount();
    void changeAccount(QModelIndex);
    void currentRowChanged(int row);
signals:
    void settingsChanged();
    void accountAdded(QString);
    void accountRemoved(QString);
private:
    QGridLayout *gridLayout_7;
    QListWidget *accounts;
    QToolButton *btnAddAccount;
    QToolButton *btnRemoveAccount;
    QSpacerItem *horizontalSpacer;
    QGridLayout *gridLayout_6;
    QTabWidget *tabWidget;
    QWidget *tab_General;
    QGridLayout *gridLayout;
    QCheckBox *hideToTray;
    QSpacerItem *verticalSpacer;
    QWidget *tab_Style;
    QGridLayout *gridLayout_3;
    QGroupBox *groupBox;
    QGridLayout *gridLayout_2;
    QLabel *label;
    QLineEdit *inactiveColor;
    QPushButton *selectInactive;
    QLabel *label_2;
    QLineEdit *activeColor;
    QPushButton *selectActive;
    QLabel *label_3;
    QSpinBox *textSize;
    QLabel *label_4;
    QCheckBox *showDisplayPic;
    QSpacerItem *verticalSpacer_2;
    QDialogButtonBox *buttonBox;

    QMenu *m_addItems;
    QAction *m_twitter;
    QAction *m_identica;
    QColorDialog *active;
    QColorDialog *inactive;
};
#endif // PREFERENCES_H
