/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009  Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#ifndef NOTIFICATIONAGENT_H
#define NOTIFICATIONAGENT_H

#include "cardinal.h"
#include "tweet.h"

#ifdef USE_SNARL
#include "SnarlInterface.h"
using namespace std;
using namespace Snarl;
#endif

class NotificationAgent : public QObject
{
    Q_OBJECT

public:
#ifdef USE_SNARL
	NotificationAgent(QSystemTrayIcon *ico, HWND handle);
	~NotificationAgent();
#else
	NotificationAgent(QSystemTrayIcon *ico);
	~NotificationAgent();
#endif
	void addNotification(tweet_t);
	void show();
protected slots:
	void closing(tweet *);
private:
	void clear();
private:
	QSystemTrayIcon *icon;
	QList<tweet_t> m_notifyList;
#ifdef USE_SNARL
	SnarlInterface *snarl;
	HWND hwnd;
#endif
};

#endif
