/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009  Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/


#ifndef PREFERENCESWINDOW_H
#define PREFERENCESWINDOW_H

#include "cardinal.h"

#ifndef CATEGORYEDITOR
#include "CategoryEditor.h"
#endif

class AccountEditor : public QDialog
{
    Q_OBJECT
public:
    AccountEditor(QString account, QWidget *parent);
    QString accountName() { return m_account; }
protected slots:
    void accept();
    void reject();
    void addNewCategory();
    void removeCategoryA();
    void categoryItemClicked(QListWidgetItem *);
    void catListItemSelectionChanged();
    void addNewIgnoreFilter();
    void removeIgnoreFilter();
    void ignoreListItemSelectionChanged();
private:
    void loadIgnoreFilters();
    CategoryEditor *editor;
    QGridLayout *gridLayout_6;
    QTabWidget *tabWidget;
    QWidget *tab_General;
    QGridLayout *gridLayout;
    QLabel *label_Username;
    QLineEdit *leUserName;
    QLabel *label_Reload;
    QSpinBox *updateTime;
    QCheckBox *hideToTray;
    QSpacerItem *verticalSpacer;
    QWidget *tab_Style;
    QGridLayout *gridLayout_3;
    QGroupBox *groupBox;
    QGridLayout *gridLayout_2;
    QLabel *label;
    QLineEdit *inactiveColor;
    QPushButton *selectInactive;
    QLabel *label_2;
    QLineEdit *activeColor;
    QPushButton *selectActive;
    QLabel *label_3;
    QSpinBox *textSize;
    QLabel *label_4;
    QSpacerItem *verticalSpacer_2;
    QWidget *tab_Categories;
    QGridLayout *gridLayout_4;
    QListWidget *categoryList;
    QPushButton *addCategory;
    QPushButton *removeCategory;
    QWidget *tab_Ignores;
    QGridLayout *gridLayout_5;
    QListWidget *ignoreList;
    QPushButton *addIgnore;
    QPushButton *removeIgnore;
    QDialogButtonBox *buttonBox;

    QString m_account;
};

#endif
