# Cardinal Basic Configuration
include(libcardinal/libcardinal.pri)

TEMPLATE = app
CONFIG += debug_and_release
TARGET = cardinal
target.path = /usr/bin

# QT Modules to Use
QT = core \
    gui \
    network \
    xml \
    sql

# Directories
DESTDIR = ./build
INCLUDEPATH += ./include
INCLUDEPATH += ./oauth/include
INCLUDEPATH += ./libcardinal/include
MOC_DIR = generated
OBJECTS_DIR += release
UI_DIR += ./ui
RCC_DIR += ./res

# Libraries - Include libcardinal
win32:LIBS += ./build/libcardinal.a

# Windows resource file
win32:RC_FILE = res/Cardinal.rc

# The Stuff
HEADERS += include/guimain.h \
    include/tweet.h \
    include/twedit.h \
    include/aboutdialog.h \
    include/infownd.h \
    include/cardinal.h \
    include/NotificationAgent.h \
    include/identitymanager.h \
    include/CategoryEditor.h \
    include/StatusTableView.h \
    include/Preferences.h \
    include/AccountManager.h \
    include/TabWidget.h \
    include/TwitterRegistration.h \
    include/UserView.h \
    include/SqlArchive.h \
    include/ProfilePictureManager.h
win32:HEADERS += include/supertweet.h
SOURCES += src/guimain.cc \
    src/tweet.cc \
    src/mainbird.cc \
    src/twedit.cc \
    src/aboutdialog.cc \
    src/infownd.cc \
    src/NotificationAgent.cc \
    src/identitymanager.cc \
    src/CategoryEditor.cc \
    src/StatusTableView.cc \
    src/Preferences.cc \
    src/AccountManager.cc \
    src/TabWidget.cc \
    src/TwitterRegistration.cc \
    src/UserView.cc \
    src/SqlArchive.cc \
    src/ProfilePictureManager.cc
win32:SOURCES += src/SuperTweet.cc

# Resource File
RESOURCES += res/cardinal.qrc

# Install it!
theme_files.files += res/cardinal.png
theme_files.path = /usr/share/pixmaps
install_desktop.files = cardinal.desktop
install_desktop.path = /usr/share/applications
INSTALLS += target \
    theme_files \
    install_desktop
install_desktop { 
    desktop.files = cardinal.desktop
    desktop.path = $$SHARED/applications
    INSTALLS += desktop
}
