/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* Generated By:JavaCC: Do not edit this line. StandardTokenizer.java */
using System;

namespace Lucene.Net.Analysis.Standard
{
	
    /// <summary>A grammar-based tokenizer constructed with JavaCC.
    /// 
    /// <p> This should be a good tokenizer for most European-language documents:
    /// 
    /// <ul>
    /// <li>Splits words at punctuation characters, removing punctuation. However, a 
    /// dot that's not followed by whitespace is considered part of a token.
    /// <li>Splits words at hyphens, unless there's a number in the token, in which case
    /// the whole token is interpreted as a product number and is not split.
    /// <li>Recognizes email addresses and internet hostnames as one token.
    /// </ul>
    /// 
    /// <p>Many applications have specific tokenizer needs.  If this tokenizer does
    /// not suit your application, please consider copying this source code
    /// directory to your project and maintaining your own grammar-based tokenizer.
    /// </summary>
    public class StandardTokenizer : Lucene.Net.Analysis.Tokenizer
    {
		
        private StandardTokenizerImpl scanner;

	public const int ALPHANUM          = 0;
	public const int APOSTROPHE        = 1;
	public const int ACRONYM           = 2;
	public const int COMPANY           = 3;
	public const int EMAIL             = 4;
	public const int HOST              = 5;
	public const int NUM               = 6;
	public const int CJ                = 7;
	public const int ACRONYM_DEP       = 8; /* deprecated */

        /// <summary>Constructs a tokenizer for this Reader. </summary>
        public StandardTokenizer(System.IO.TextReader reader) : base(reader)
        {
	    this.scanner = StandardTokenizerImpl.GetStandardTokenizerImpl(reader);
        }
		
        /// <summary>Returns the next token in the stream, or null at EOS.
        /// <p>The returned token's type is set to an element of {@link
        /// StandardTokenizerConstants#tokenImage}.
        /// </summary>
        public override Lucene.Net.Analysis.Token Next()
        {
	    int tokenType = scanner.GetNextToken();

	    if (tokenType == StandardTokenizerImpl.YYEOF) {
	        return null;
	    }

	    int startPosition = scanner.yychar();

	    string tokenImage = scanner.yytext();
	    return new Token(tokenImage, startPosition, startPosition
	    	+ tokenImage.Length,
	    	StandardTokenizerImpl.TOKEN_TYPES[tokenType]);
        }

        /// <summary>By default, closes the input Reader. </summary>
        public override void Close() 
        { 
            scanner.yyclose(); 
            base.Close(); 
        }
    }
}
