/**
 *
 * $Id: jstring.c,v 1.1 1999/03/17 13:46:09 isizaka Exp $
 *
 * Copyright (C) 1997, Satoshi ISHIZAKA.
 *
 * This file is part of Ngraph.
 *
 * This is free software; you can redistribute it and/or modify it.
 * However, it is prohibited to compile this on the "Windows" environment.
 *
 * Original author: Satoshi ISHIZAKA
 *                  isizaka@msa.biglobe.ne.jp
 **/

/**
 *
 * $Log: jstring.c,v $
 * Revision 1.1  1999/03/17 13:46:09  isizaka
 * Initial revision
 *
 *
 **/

#include <string.h>
#include "jstring.h"

#define TRUE  1
#define FALSE 0

unsigned int njms2jis(unsigned int code)
{
  unsigned char dh,dl;

  dh=code >> 8;
  dl=code & 0xff;
  if (dh<=0x9f) dh-=0x70;
  else dh-=0xb0;
  dh=dh<<1;
  if (dl>=0x9f) dl-=0x7e;
  else {
    dh--;
    if (dl>=0x80) dl-=0x20;
    else dl-=0x1f;
  }
  return ((unsigned int)(dh << 8))+dl;
}

unsigned int njis2jms(unsigned int code)
{
  unsigned char dh,dl;

  dh=code >> 8;
  dl=code & 0xff;
  if (dh & 0x1) dl+=0x1f;
  else dl+=0x7d;
  if (dl>=0x7f) dl++;
  if (dh>=0x5f) {
    dh-=0x5f;
    dh=dh>>1;
    dh+=0xe0;
  } else {
    dh-=0x21;
    dh=dh>>1;
    dh+=0x81;
  }
  return ((unsigned int)(dh << 8))+dl;
}

int niskanji(unsigned char code)
{
  if (((0x81<=code) && (code<=0x9f))
   || ((0xe0<=code) && (code<=0xff))) return TRUE;
  return FALSE;
}

int niskanji2(char *s,int pos)
{
  int k;

  if (pos>=strlen(s)) return FALSE;
  else {
    k=pos;
    do {
      k--;
    } while ((k>=0) && niskanji((unsigned char)s[k]));
    if ((pos-k)%2==1) return FALSE;
    else return TRUE;
  }
}

