/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#define PACKAGE_NAME  "Xfbib"
#endif

#include <stdlib.h>
#include <gtk/gtk.h>
#include <string.h>

#include "debug.h"
#include "window.h"
#include "xfbib.h"
#include "menubar.h"
#include "toolbar.h"
#include "node.h"
#include "scrolled_window.h"
#include "statusbar.h"
#include "treeview.h"

static gboolean delete_event_handler (GtkWidget *widget, GdkEvent *event, struct xfbib *xfbib)
{
	_DEBUG(("delete_event_handler"));
	free_list(xfbib->list);
	gtk_main_quit();
	return FALSE;
}

GtkWidget *create_window(struct xfbib *xfbib)
{
	_DEBUG(("create_window"));
	
	xfbib->window.window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	gtk_window_set_title(GTK_WINDOW(xfbib->window.window), PACKAGE_NAME);

	gtk_widget_set_size_request(GTK_WIDGET(xfbib->window.window), 600, 400);

	g_signal_connect(xfbib->window.window, "delete_event",
			G_CALLBACK(delete_event_handler), xfbib);

	xfbib->window.menubar = create_menubar(xfbib);
	xfbib->window.toolbar = create_toolbar(xfbib);
	xfbib->window.variable_treeview = create_variable_treeview(xfbib);
	xfbib->window.scrolled_variable_window = create_scrolled_window(xfbib->window.variable_treeview, 150,300);
	xfbib->window.main_treeview = create_main_treeview(xfbib);
	xfbib->window.scrolled_main_window = create_scrolled_window(xfbib->window.main_treeview, 400, 300);
	xfbib->window.statusbar = create_statusbar();
	

	/* Create containers */
	xfbib->window.hpaned = gtk_hpaned_new();

	gtk_paned_pack1(GTK_PANED(xfbib->window.hpaned), xfbib->window.scrolled_variable_window, TRUE, FALSE);
	gtk_paned_pack2(GTK_PANED(xfbib->window.hpaned), xfbib->window.scrolled_main_window, TRUE, TRUE);
	xfbib->window.vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(xfbib->window.window), xfbib->window.vbox);
	gtk_box_pack_start(GTK_BOX(xfbib->window.vbox), xfbib->window.menubar, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(xfbib->window.vbox), xfbib->window.toolbar, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(xfbib->window.vbox), xfbib->window.hpaned, TRUE , TRUE, 0);
	gtk_box_pack_end(GTK_BOX(xfbib->window.vbox), xfbib->window.statusbar, FALSE, FALSE, 0);

	return xfbib->window.window;
}

char *create_title(struct xfbib *xfbib)
{
	_DEBUG(("create_title"));
/*	int i, j, length = 0;
	char *package_name = PACKAGE_NAME;
	length += strlen(package_name);
	length += strlen(" - ");
	length += strlen(xfbib->filename);
	length ++; //For the NULL sign
	
	char *title = malloc(sizeof(char)*length);
	
	for(i = 0; i < strlen(package_name); i++) 
		title[i] = package_name[i];

	title[i] = ' ';
	title[i+1] = '-';
	title[i+2] = ' ';
	
	for(i = i+3,j = 0; i < length; i++, j++)
		title[i] = xfbib->filename[j];
	title[length] = '\0';

	return title;*/
	if (xfbib->filename == NULL)
		return PACKAGE_NAME;
	else
		return xfbib->filename;
}
