/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "tag.h"
#include "debug.h"


void new_tag(struct tag **tags, char *name, char *value, int sense)
{
	_DEBUG(("new_tag"));
	if (*tags == NULL) {
		struct tag *new = malloc(sizeof(struct tag));
		if ((new->name = strdup(name)) == NULL)
			fprintf(stderr, "Insufficient amount of memory available\n");
		if ((new->value = strdup(value)) == NULL)
			fprintf(stderr, "Insufficient amount of memory available\n");
		new->next = NULL;
		new->sense = sense;
		*tags = new;
	} else {
		new_tag(&((*tags)->next), name, value, sense);
	}
}

void print_tags(struct tag *tags)
{
	_DEBUG(("print_tags"));
	write_tags(tags, stdout);
}

void write_tags(struct tag *tags, FILE *file)
{
	_DEBUG(("write_tags"));
	struct tag *t;
	for (t = tags; t != NULL; t = t->next) {
		if (t->sense)
			fprintf(file, "\t%s = {%s},\n", t->name, t->value);
		else
			fprintf(file, "\t%s = \"%s\",\n", t->name, t->value);
	}
}

void free_tags(struct tag* t)
{
	_DEBUG(("free_tags"));
	if (t != NULL) {
		free_tags(t->next);
		free(t->name);
		free(t->value);
		free(t);		
	}
}

char *get_value(struct tag *tags, char *name)
{
	_DEBUG(("get_value"));
	struct tag *t;
	for (t = tags; t != NULL; t = t->next) {
		if (strcasecmp(t->name, name) == 0) {
			return t->value;
		}
	}
	return NULL;
}
