/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "strings.h"
#include "debug.h"

struct string *new_string(char *variable, char *value)
{
	_DEBUG(("new_string"));
	struct string *new = malloc(sizeof(struct string));
	if ((new->variable = strdup(variable)) == NULL)
		fprintf(stderr, "Insufficient amount of memory available\n");
	if ((new->value = strdup(value)) == NULL)
		fprintf(stderr, "Insufficient amount of memory available\n");
	return new;
}

void print_string(struct string *s)
{
	_DEBUG(("print_string"));
	write_string(s, stdout);
}

void write_string(struct string *s, FILE *file)
{
	_DEBUG(("write_string"));
	fprintf(file, "@String {%s = \"%s\"}\n\n", s->variable, s->value);
}

void change_variable(struct string *s,char *variable) 
{
	_DEBUG(("change_variable"));
	free(s->variable);
	if ((s->variable = strdup(variable)) == NULL) {
		
		fprintf(stderr, "Insufficient amount of memory available\n");
	}
}

void change_value(struct string *s, char *value)
{
	_DEBUG(("change_value"));
	free(s->value);
	if ((s->value = strdup(value)) == NULL) {
		
		fprintf(stderr, "Insufficient amount of memory available\n");
	}
}

void free_string(struct string *s)
{
	_DEBUG(("free_string"));
	free(s->variable);
	free(s->value);
	free(s);
}
