class ViewWidget < Qt::Widget

  def initialize(parent = nil)
    super(parent)

    set_size_policy(Qt::SizePolicy::Expanding, Qt::SizePolicy::Expanding)

    @video_window = (Qt::Widget.new do
      self.maximum_size = self.minimum_size = Qt::Size.new(1,1)

      def sizeHint
        maximum_size
      end
    end)

    layout = Qt::HBoxLayout.new {no_margins}
    layout.add_stretch
    layout.add_widget @video_window
    layout.add_stretch
    set_layout layout
  end

  def update_size
    stream_res = WebcamVideoStream.instance.resolution

    parent_ratio = self.width.to_f / self.height
    stream_ratio = stream_res[0].to_f / stream_res[1]

    if parent_ratio <= stream_ratio
      @video_window.set_maximum_size Qt::Size.new(self.width, self.width / stream_ratio)
    else
      @video_window.set_maximum_size Qt::Size.new(self.height * stream_ratio, self.height)
    end
  end

  def mouseDoubleClickEvent(event)
    $fs_view.exec if $dev_pool.webcam?
  end

  def paintEvent(event)
    update_size if $dev_pool.webcam?
  end

  def window_id
    @video_window.win_id
  end

end




class ViewWidgetFactory

  @@widgets = []

  def self.create
    view_w = ViewWidget.new
    @@widgets << view_w
    return view_w
  end

  def self.widgets
    @@widgets
  end

end





class FSView < Qt::Dialog

  def initialize(parent = nil)
    super(parent)
    set_parent($webkam_app.desktop, Qt::FramelessWindowHint | Qt::Popup)
    move(0, 0)
    resize($webkam_app.desktop.size)
    set_focus_policy Qt::StrongFocus

    set_layout( Qt::HBoxLayout.new do |l|
      l.set_contents_margins(0, 0, 0, 0)
      l.add_widget ViewWidgetFactory.create
  end ) end

  def keyPressEvent(event)
    close
  end

  def mousePressEvent(event)
    close
  end

  def paintEvent(event)
    painter = Qt::Painter.new(self)
    painter.fill_rect(event.rect, Qt::Brush.new(Qt::Color.new('black')))
    painter.dispose
  end

end
