/* $Id: grabber.h,v 1.1.1.1 2006/05/26 04:43:29 mgdepalma Exp $
 *
 * Copyright (C) 2006 Mauro DePalma <mauro@softcraft.org>
 *
modified by Peter Semiletov

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; You may only use version 2 of the License,
 * you have no option to use any other version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GRABBER_H
#define GRABBER_H

#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <X11/cursorfont.h>

#define GRAB_SCREEN  0
#define GRAB_WINDOW  1
#define GRAB_REGION  2
#define GRAB_CLIPBOARD 3

typedef unsigned char byte;
typedef unsigned int word;

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus *

/* Methods implemented by grabber.c */
extern XImage *grab(Window drawable, XRectangle *xrect);
extern Window grab_window(Display *display, Window root);
extern int grab_rectangle(Display *display, Window root, XRectangle *xrect);
extern GdkPixbuf *capture(GtkWidget *window, gint mode, gboolean decorations);

extern GdkPixbuf *grab_pixbuf(Window xid, XRectangle *xrect);

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif	/* GRABBER_H */
