# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "test/unit"

require "bz2"
require "rast_test"
require "rast/filter"
require "rast/database-generatable"

module Rast
  class ApplicationBz2Test < Test::Unit::TestCase
    include DatabaseGeneratable

    def test_invoke
      invoke_test_simple
    end

    def invoke_test_simple
      create_options = {
        "encoding" => "utf8",
        "preserve_text" => true,
        "properties" => [],
      }
      db_name = generate_db_name
      LocalDB.create(db_name, create_options)

      LocalDB.open(db_name, Rast::DB::RDWR) do |db|
        doc = db.create_document
        chain = FilterChain.new(doc)
        brigade = Brigade.new
        filename = File.join(MakeVariable::TOP_SRCDIR, "tests", "data",
                             "filter", "ja", "utf-8.txt.bz2")
        File.open(filename) do |f|
          brigade.insert_tail(FileBucket.new(f))
          brigade.insert_tail(EOSBucket.new)
          chain.invoke(brigade, "application/x-bzip2")
          doc.commit
        end
      end
      LocalDB.open(db_name) do |db|
        assert_equal("bzip2 テスト これは bzip2 ファイルです ", db.get_text(1))
      end

      LocalDB.open(db_name, Rast::DB::RDWR) do |db|
        doc = db.create_document
        chain = FilterChain.new(doc)
        brigade = Brigade.new
        s = BZ2.bzip2("本日は晴天なり" * 1000)
        (0 ... s.length).each do |i|
          sub_s = s[i, 1]
          brigade.insert_tail(TransientBucket.new(sub_s))
        end
        brigade.insert_tail(EOSBucket.new)
        chain.invoke(brigade, "application/x-bzip2")
        doc.commit
      end
      LocalDB.open(db_name) do |db|
        assert_equal("本日は晴天なり" * 1000, db.get_text(2))
      end
    end
  end
end
