/*
 * Decompiled with CFR 0.152.
 */
package org.openbabel;

import org.openbabel.OBGenericData;
import org.openbabel.SWIGTYPE_p_double;
import org.openbabel.SWIGTYPE_p_int;
import org.openbabel.openbabel_javaJNI;
import org.openbabel.vector3;
import org.openbabel.vectorDouble;

public class OBGridData
extends OBGenericData {
    private long swigCPtr;

    protected OBGridData(long l, boolean bl) {
        super(openbabel_javaJNI.SWIGOBGridDataUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(OBGridData oBGridData) {
        return oBGridData == null ? 0L : oBGridData.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            openbabel_javaJNI.delete_OBGridData(this.swigCPtr);
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    public OBGridData() {
        this(openbabel_javaJNI.new_OBGridData(), true);
    }

    public void GetAxes(SWIGTYPE_p_double sWIGTYPE_p_double, SWIGTYPE_p_double sWIGTYPE_p_double2, SWIGTYPE_p_double sWIGTYPE_p_double3) {
        openbabel_javaJNI.OBGridData_GetAxes__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_double.getCPtr(sWIGTYPE_p_double), SWIGTYPE_p_double.getCPtr(sWIGTYPE_p_double2), SWIGTYPE_p_double.getCPtr(sWIGTYPE_p_double3));
    }

    public vector3 GetXAxis() {
        return new vector3(openbabel_javaJNI.OBGridData_GetXAxis(this.swigCPtr, this), true);
    }

    public vector3 GetYAxis() {
        return new vector3(openbabel_javaJNI.OBGridData_GetYAxis(this.swigCPtr, this), true);
    }

    public vector3 GetZAxis() {
        return new vector3(openbabel_javaJNI.OBGridData_GetZAxis(this.swigCPtr, this), true);
    }

    public void GetAxes(vector3 vector32, vector3 vector33, vector3 vector34) {
        openbabel_javaJNI.OBGridData_GetAxes__SWIG_1(this.swigCPtr, this, vector3.getCPtr(vector32), vector32, vector3.getCPtr(vector33), vector33, vector3.getCPtr(vector34), vector34);
    }

    public void GetNumberOfPoints(SWIGTYPE_p_int sWIGTYPE_p_int, SWIGTYPE_p_int sWIGTYPE_p_int2, SWIGTYPE_p_int sWIGTYPE_p_int3) {
        openbabel_javaJNI.OBGridData_GetNumberOfPoints__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_int.getCPtr(sWIGTYPE_p_int), SWIGTYPE_p_int.getCPtr(sWIGTYPE_p_int2), SWIGTYPE_p_int.getCPtr(sWIGTYPE_p_int3));
    }

    public int GetNumberOfPoints() {
        return openbabel_javaJNI.OBGridData_GetNumberOfPoints__SWIG_1(this.swigCPtr, this);
    }

    public void GetNumberOfSteps(SWIGTYPE_p_int sWIGTYPE_p_int) {
        openbabel_javaJNI.OBGridData_GetNumberOfSteps(this.swigCPtr, this, SWIGTYPE_p_int.getCPtr(sWIGTYPE_p_int));
    }

    public vectorDouble GetValues() {
        return new vectorDouble(openbabel_javaJNI.OBGridData_GetValues(this.swigCPtr, this), true);
    }

    public double GetValue(int n, int n2, int n3) {
        return openbabel_javaJNI.OBGridData_GetValue__SWIG_0(this.swigCPtr, this, n, n2, n3);
    }

    public double GetValue(vector3 vector32) {
        return openbabel_javaJNI.OBGridData_GetValue__SWIG_1(this.swigCPtr, this, vector3.getCPtr(vector32), vector32);
    }

    public Unit GetUnit() {
        return Unit.swigToEnum(openbabel_javaJNI.OBGridData_GetUnit(this.swigCPtr, this));
    }

    public double GetMinValue() {
        return openbabel_javaJNI.OBGridData_GetMinValue(this.swigCPtr, this);
    }

    public double GetMaxValue() {
        return openbabel_javaJNI.OBGridData_GetMaxValue(this.swigCPtr, this);
    }

    public vector3 GetOriginVector() {
        return new vector3(openbabel_javaJNI.OBGridData_GetOriginVector__SWIG_0(this.swigCPtr, this), true);
    }

    public void GetOriginVector(SWIGTYPE_p_double sWIGTYPE_p_double) {
        openbabel_javaJNI.OBGridData_GetOriginVector__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_double.getCPtr(sWIGTYPE_p_double));
    }

    public vector3 GetMaxVector() {
        return new vector3(openbabel_javaJNI.OBGridData_GetMaxVector(this.swigCPtr, this), true);
    }

    public boolean GetUnrestricted() {
        return openbabel_javaJNI.OBGridData_GetUnrestricted(this.swigCPtr, this);
    }

    public int GetNumSymmetries() {
        return openbabel_javaJNI.OBGridData_GetNumSymmetries(this.swigCPtr, this);
    }

    public void SetNumberOfPoints(int n, int n2, int n3) {
        openbabel_javaJNI.OBGridData_SetNumberOfPoints(this.swigCPtr, this, n, n2, n3);
    }

    public void SetLimits(vector3 vector32, vector3 vector33, vector3 vector34, vector3 vector35) {
        openbabel_javaJNI.OBGridData_SetLimits__SWIG_0(this.swigCPtr, this, vector3.getCPtr(vector32), vector32, vector3.getCPtr(vector33), vector33, vector3.getCPtr(vector34), vector34, vector3.getCPtr(vector35), vector35);
    }

    public void SetLimits(SWIGTYPE_p_double sWIGTYPE_p_double, SWIGTYPE_p_double sWIGTYPE_p_double2, SWIGTYPE_p_double sWIGTYPE_p_double3, SWIGTYPE_p_double sWIGTYPE_p_double4) {
        openbabel_javaJNI.OBGridData_SetLimits__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_double.getCPtr(sWIGTYPE_p_double), SWIGTYPE_p_double.getCPtr(sWIGTYPE_p_double2), SWIGTYPE_p_double.getCPtr(sWIGTYPE_p_double3), SWIGTYPE_p_double.getCPtr(sWIGTYPE_p_double4));
    }

    public boolean SetValue(int n, int n2, int n3, double d) {
        return openbabel_javaJNI.OBGridData_SetValue(this.swigCPtr, this, n, n2, n3, d);
    }

    public void SetValues(vectorDouble vectorDouble2) {
        openbabel_javaJNI.OBGridData_SetValues(this.swigCPtr, this, vectorDouble.getCPtr(vectorDouble2), vectorDouble2);
    }

    public void SetUnit(Unit unit) {
        openbabel_javaJNI.OBGridData_SetUnit(this.swigCPtr, this, unit.swigValue());
    }

    public void SetUnrestricted(boolean bl) {
        openbabel_javaJNI.OBGridData_SetUnrestricted(this.swigCPtr, this, bl);
    }

    public void SetNumSymmetries(int n) {
        openbabel_javaJNI.OBGridData_SetNumSymmetries(this.swigCPtr, this, n);
    }

    public static final class Unit {
        public static final Unit BOHR = new Unit("BOHR");
        public static final Unit ANGSTROM = new Unit("ANGSTROM");
        public static final Unit OTHER = new Unit("OTHER");
        private static Unit[] swigValues = new Unit[]{BOHR, ANGSTROM, OTHER};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static Unit swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && Unit.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (Unit.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + Unit.class + " with value " + n);
        }

        private Unit(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private Unit(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private Unit(String string, Unit unit) {
            this.swigName = string;
            this.swigValue = unit.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

