/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Drawable;
import java.util.Stack;
import javax.swing.JTree;

public class NestingStacks {
    private static float Nesting_Height_Reduction = 0.8f;
    private static float Initial_Nesting_Height = 0.8f;
    private static float Half_Initial_Nesting_Height = 0.4f;
    private static float Shadow_Nesting_Height = 0.4f;
    private JTree tree_view;
    private Stack[] nesting_stacks;
    private boolean hasNestingStacksBeenUsed;
    private boolean isTimeBoxScrolling;
    private int num_rows;

    public NestingStacks(JTree jTree) {
        this.tree_view = jTree;
        this.nesting_stacks = null;
    }

    public static void setNestingHeightReduction(float f) {
        if (f > 0.0f && f < 1.0f) {
            Nesting_Height_Reduction = f;
        }
    }

    public static void setInitialNestingHeight(float f) {
        if (f > 0.0f && f < 1.0f) {
            Initial_Nesting_Height = f;
            Half_Initial_Nesting_Height = Initial_Nesting_Height / 2.0f;
            Shadow_Nesting_Height = Initial_Nesting_Height;
        }
    }

    public static float getHalfInitialNestingHeight() {
        return Half_Initial_Nesting_Height;
    }

    public void initialize(boolean bl) {
        this.isTimeBoxScrolling = bl;
        this.num_rows = this.tree_view.getRowCount();
        this.nesting_stacks = new Stack[this.num_rows];
        for (int i = 0; i < this.num_rows; ++i) {
            this.nesting_stacks[i] = !this.tree_view.isExpanded(i) ? new Stack() : null;
        }
        this.hasNestingStacksBeenUsed = false;
    }

    public void reset() {
        if (this.hasNestingStacksBeenUsed) {
            for (int i = 0; i < this.num_rows; ++i) {
                if (this.nesting_stacks[i] == null) continue;
                this.nesting_stacks[i].clear();
            }
        } else {
            this.hasNestingStacksBeenUsed = true;
        }
    }

    public void finish() {
        for (int i = 0; i < this.num_rows; ++i) {
            if (this.nesting_stacks[i] == null) continue;
            this.nesting_stacks[i] = null;
        }
    }

    public boolean isReadyToGetNestingFactorFor(Drawable drawable) {
        if (this.isTimeBoxScrolling) {
            return drawable.isNestingFactorUninitialized();
        }
        return true;
    }

    public float getNestingFactorFor(Drawable drawable) {
        int n = drawable.getRowID();
        Stack stack = this.nesting_stacks[n];
        float f = 1.0f;
        while (!stack.empty()) {
            Drawable drawable2 = (Drawable)stack.peek();
            if (drawable2.covers(drawable)) {
                f = drawable2.getNestingFactor() * Nesting_Height_Reduction;
                stack.push(drawable);
                return f;
            }
            stack.pop();
        }
        f = Initial_Nesting_Height;
        stack.push(drawable);
        return f;
    }
}

