/*
 * Decompiled with CFR 0.152.
 */
package viewer.convertor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import logformat.slog2.input.InputLog;
import viewer.common.ActableTextField;
import viewer.common.CustomCursor;
import viewer.common.Dialogs;
import viewer.common.LogFileChooser;
import viewer.common.Routines;
import viewer.common.RuntimeExecCommand;
import viewer.convertor.AdvancingTextArea;
import viewer.convertor.ConvertorConst;
import viewer.convertor.InputStreamThread;
import viewer.convertor.ProgressAction;
import viewer.convertor.SwingProcessWorker;
import viewer.convertor.WaitingContainer;

public class ConvertorPanel
extends JPanel
implements WaitingContainer {
    private JComboBox cmd_pulldown;
    private ActableTextField cmd_infile;
    private JButton infile_btn;
    private JTextField cmd_outfile;
    private JButton outfile_btn;
    private AdvancingTextArea cmd_textarea;
    private JTextField cmd_outfile_size;
    private JProgressBar cmd_progress;
    private JTextField cmd_option4jvm;
    private JTextField cmd_option4jar;
    private JTextField cmd_path2jvm;
    private ActableTextField cmd_path2jardir;
    private JTextField cmd_path2tracelib;
    private JSplitPane cmd_splitter;
    private JButton cmd_start_btn;
    private JButton cmd_stop_btn;
    private JButton cmd_help_btn;
    private JButton cmd_close4ok_btn;
    private JButton cmd_close4cancel_btn;
    private Window top_window;
    private LogFileChooser file_chooser;
    private String file_sep;
    private String path_sep;
    private String err_msg;
    private SwingProcessWorker logconv_worker;

    public ConvertorPanel(LogFileChooser logFileChooser) {
        this.initComponents(logFileChooser != null);
        this.initAllTextFields();
        this.file_chooser = logFileChooser != null ? logFileChooser : new LogFileChooser(false);
        this.cmd_pulldown.addActionListener(new PulldownListener());
        this.cmd_infile.addActionListener(new LogNameListener());
        this.infile_btn.addActionListener(new InputFileSelectorListener());
        this.outfile_btn.addActionListener(new OutputFileSelectorListener());
        this.cmd_path2jardir.addActionListener(new JarDirectoryListener());
        this.cmd_start_btn.addActionListener(new StartConvertorListener());
        this.cmd_stop_btn.addActionListener(new StopConvertorListener());
        this.cmd_help_btn.addActionListener(new HelpConvertorListener());
        this.finalizeWaiting();
        this.logconv_worker = null;
    }

    public void init(String string) {
        this.top_window = SwingUtilities.windowForComponent(this);
        this.cmd_splitter.setDividerLocation(1.0);
        if (string != null && string.length() > 0) {
            this.cmd_infile.setText(string);
            this.cmd_infile.fireActionPerformed();
            this.cmd_pulldown.setSelectedItem(ConvertorConst.getDefaultConvertor(string));
            if (this.cmd_close4ok_btn != null) {
                this.cmd_close4ok_btn.setEnabled(false);
            }
            if (this.cmd_close4cancel_btn != null) {
                this.cmd_close4cancel_btn.setEnabled(true);
            }
        }
        if (this.err_msg != null) {
            Dialogs.error(this.top_window, this.err_msg);
        }
    }

    private URL getURL(String string) {
        URL uRL = null;
        uRL = this.getClass().getResource(string);
        return uRL;
    }

    private void initComponents(boolean bl) {
        Border border = BorderFactory.createRaisedBevelBorder();
        Border border2 = BorderFactory.createEtchedBorder();
        Dimension dimension = new Dimension(410, 30);
        Dimension dimension2 = new Dimension(130, 26);
        Dimension dimension3 = new Dimension(dimension.width - dimension2.width, dimension2.height);
        Dimension dimension4 = new Dimension(dimension2.width, 2 * dimension2.height);
        Dimension dimension5 = new Dimension(dimension.width, dimension4.height);
        super.setLayout(new BoxLayout(this, 1));
        Color color = UIManager.getColor("ScrollBar.thumb");
        Color color2 = Routines.getSlightBrighterColor(color);
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.5f);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(4));
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.5f);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalStrut(5));
        this.cmd_pulldown = new JComboBox();
        this.cmd_pulldown.setForeground(Color.yellow);
        this.cmd_pulldown.setBackground(color2);
        this.cmd_pulldown.setToolTipText(" Logfile Convertor's Name ");
        this.cmd_pulldown.addItem("  CLOG-2  -->  SLOG-2  ");
        this.cmd_pulldown.addItem("  CLOG    -->  SLOG-2  ");
        this.cmd_pulldown.addItem("  RLOG    -->  SLOG-2  ");
        this.cmd_pulldown.addItem("  UTE     -->  SLOG-2  ");
        this.cmd_pulldown.addItem("  TXT     -->  SLOG-2  ");
        this.cmd_pulldown.setBorder(border);
        this.cmd_pulldown.setEditable(false);
        this.cmd_pulldown.setAlignmentX(0.5f);
        jPanel2.add(this.cmd_pulldown);
        jPanel2.add(Box.createHorizontalStrut(5));
        Routines.setShortJComponentSizes(jPanel2, dimension);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(4));
        Insets insets = new Insets(1, 1, 1, 1);
        JPanel jPanel3 = new JPanel();
        jPanel3.setAlignmentX(0.5f);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        JLabel jLabel = new JLabel(" Input File Spec. : ");
        jLabel.setToolTipText("File Specification of the Input Trace File.");
        Routines.setShortJComponentSizes(jLabel, dimension2);
        jPanel3.add(jLabel);
        this.cmd_infile = new ActableTextField();
        jPanel3.add(this.cmd_infile);
        URL uRL = this.getURL("/images/Open24.gif");
        this.infile_btn = null;
        this.infile_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("Browse");
        this.infile_btn.setToolTipText("Select a new Input Logfile");
        this.infile_btn.setMargin(insets);
        jPanel3.add(this.infile_btn);
        Routines.setShortJComponentSizes(jPanel3, dimension);
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalStrut(4));
        JPanel jPanel4 = new JPanel();
        jPanel4.setAlignmentX(0.5f);
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jLabel = new JLabel(" Output File Name : ");
        jLabel.setToolTipText("File Name of the SLOG-2 File");
        Routines.setShortJComponentSizes(jLabel, dimension2);
        jPanel4.add(jLabel);
        this.cmd_outfile = new JTextField();
        jPanel4.add(this.cmd_outfile);
        uRL = this.getURL("/images/Open24.gif");
        this.outfile_btn = null;
        this.outfile_btn = uRL != null ? new JButton(new ImageIcon(uRL)) : new JButton("Browse");
        this.outfile_btn.setToolTipText("Select a new Output Logfile");
        this.outfile_btn.setMargin(insets);
        jPanel4.add(this.outfile_btn);
        Routines.setShortJComponentSizes(jPanel4, dimension);
        jPanel.add(jPanel4);
        jPanel.add(Box.createVerticalStrut(4));
        this.cmd_textarea = new AdvancingTextArea();
        this.cmd_textarea.setColumns(50);
        this.cmd_textarea.setRows(5);
        this.cmd_textarea.setEditable(false);
        this.cmd_textarea.setLineWrap(false);
        JScrollPane jScrollPane = new JScrollPane(this.cmd_textarea);
        jScrollPane.setAlignmentX(0.5f);
        jPanel.add(jScrollPane);
        jPanel.add(Box.createVerticalStrut(4));
        JPanel jPanel5 = new JPanel();
        jPanel5.setAlignmentX(0.5f);
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        JPanel jPanel6 = new JPanel();
        jPanel6.setAlignmentY(0.5f);
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.setBorder(new TitledBorder(border2, " Output File Size "));
        this.cmd_outfile_size = new JTextField();
        this.cmd_outfile_size.setEditable(false);
        jPanel6.add(this.cmd_outfile_size);
        Routines.setShortJComponentSizes(jPanel6, dimension4);
        jPanel5.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setAlignmentY(0.5f);
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        jPanel7.setBorder(new TitledBorder(border2, " Output to Input Logfile Size Ratio "));
        this.cmd_progress = new JProgressBar();
        this.cmd_progress.setStringPainted(true);
        jPanel7.add(this.cmd_progress);
        Routines.setShortJComponentSizes(jPanel7, dimension5);
        jPanel5.add(jPanel7);
        jPanel.add(jPanel5);
        dimension = new Dimension(410, 27);
        dimension2 = new Dimension(130, 25);
        dimension3 = new Dimension(dimension.width - dimension2.width, dimension2.height);
        JPanel jPanel8 = new JPanel();
        jPanel8.setAlignmentX(0.5f);
        jPanel8.setLayout(new BoxLayout(jPanel8, 1));
        jPanel8.add(Box.createVerticalStrut(4));
        JPanel jPanel9 = new JPanel();
        jPanel9.setAlignmentX(0.5f);
        jPanel9.setLayout(new BoxLayout(jPanel9, 0));
        jLabel = new JLabel(" JVM Path : ");
        jLabel.setToolTipText("Full Pathname of the Java Virtual Machine.");
        Routines.setShortJComponentSizes(jLabel, dimension2);
        jPanel9.add(jLabel);
        this.cmd_path2jvm = new JTextField();
        jPanel9.add(this.cmd_path2jvm);
        Routines.setShortJComponentSizes(jPanel9, dimension);
        jPanel8.add(jPanel9);
        jPanel8.add(Box.createVerticalGlue());
        jPanel8.add(Box.createVerticalStrut(4));
        JPanel jPanel10 = new JPanel();
        jPanel10.setAlignmentX(0.5f);
        jPanel10.setLayout(new BoxLayout(jPanel10, 0));
        jLabel = new JLabel(" JVM Option : ");
        jLabel.setToolTipText("Option to the Java Virtual Machine.");
        Routines.setShortJComponentSizes(jLabel, dimension2);
        jPanel10.add(jLabel);
        this.cmd_option4jvm = new JTextField();
        jPanel10.add(this.cmd_option4jvm);
        Routines.setShortJComponentSizes(jPanel10, dimension);
        jPanel8.add(jPanel10);
        jPanel8.add(Box.createVerticalGlue());
        jPanel8.add(Box.createVerticalStrut(4));
        JPanel jPanel11 = new JPanel();
        jPanel11.setAlignmentX(0.5f);
        jPanel11.setLayout(new BoxLayout(jPanel11, 0));
        jLabel = new JLabel(" JAR Directory : ");
        jLabel.setToolTipText("Directory of the .jar files.");
        Routines.setShortJComponentSizes(jLabel, dimension2);
        jPanel11.add(jLabel);
        this.cmd_path2jardir = new ActableTextField();
        jPanel11.add(this.cmd_path2jardir);
        Routines.setShortJComponentSizes(jPanel11, dimension);
        jPanel8.add(jPanel11);
        jPanel8.add(Box.createVerticalGlue());
        jPanel8.add(Box.createVerticalStrut(4));
        JPanel jPanel12 = new JPanel();
        jPanel12.setAlignmentX(0.5f);
        jPanel12.setLayout(new BoxLayout(jPanel12, 0));
        jLabel = new JLabel(" JAR Option : ");
        jLabel.setToolTipText("Option to the selected Convertor.");
        Routines.setShortJComponentSizes(jLabel, dimension2);
        jPanel12.add(jLabel);
        this.cmd_option4jar = new JTextField();
        jPanel12.add(this.cmd_option4jar);
        Routines.setShortJComponentSizes(jPanel12, dimension);
        jPanel8.add(jPanel12);
        jPanel8.add(Box.createVerticalGlue());
        jPanel8.add(Box.createVerticalStrut(4));
        JPanel jPanel13 = new JPanel();
        jPanel13.setAlignmentX(0.5f);
        jPanel13.setLayout(new BoxLayout(jPanel13, 0));
        jLabel = new JLabel(" TraceLibrary Path : ");
        jLabel.setToolTipText("Trace Input Library path of the selected Convertor");
        Routines.setShortJComponentSizes(jLabel, dimension2);
        jPanel13.add(jLabel);
        this.cmd_path2tracelib = new JTextField();
        jPanel13.add(this.cmd_path2tracelib);
        Routines.setShortJComponentSizes(jPanel13, dimension);
        jPanel8.add(jPanel13);
        jPanel8.add(Box.createVerticalStrut(4));
        this.cmd_splitter = new JSplitPane(0, true, jPanel, jPanel8);
        this.cmd_splitter.setAlignmentX(0.5f);
        this.cmd_splitter.setOneTouchExpandable(true);
        this.err_msg = null;
        try {
            this.cmd_splitter.setResizeWeight(1.0);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.err_msg = "Method JSplitPane.setResizeWeight() cannot be found.\nThis indicates you are running an older Java2 RunTime,\nlike the one in J2SDK 1.2.2 or older. If this is the case,\nsome features in Convertor window may not work correctly,\nFor instance, resize of the window may not resize upper \nTextArea.  Manuel movement of splitter is needed.\n";
        }
        super.add(this.cmd_splitter);
        super.add(Box.createVerticalStrut(4));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new BoxLayout(jPanel14, 0));
        jPanel14.setAlignmentX(0.5f);
        jPanel14.add(Box.createHorizontalGlue());
        insets = new Insets(2, 4, 2, 4);
        this.cmd_start_btn = new JButton("Convert");
        uRL = this.getURL("/images/Convert24.gif");
        if (uRL != null) {
            this.cmd_start_btn.setIcon(new ImageIcon(uRL));
            this.cmd_start_btn.setVerticalTextPosition(0);
            this.cmd_start_btn.setHorizontalTextPosition(4);
            this.cmd_start_btn.setMargin(insets);
        }
        this.cmd_start_btn.setToolTipText("Proceed with the selected logfile conversion.");
        jPanel14.add(this.cmd_start_btn);
        jPanel14.add(Box.createHorizontalGlue());
        this.cmd_stop_btn = new JButton(" Stop ");
        uRL = this.getURL("/images/Stop24.gif");
        if (uRL != null) {
            this.cmd_stop_btn.setIcon(new ImageIcon(uRL));
            this.cmd_stop_btn.setVerticalTextPosition(0);
            this.cmd_stop_btn.setHorizontalTextPosition(4);
        }
        this.cmd_stop_btn.setToolTipText("Stop the ongoing logfile conversion.");
        jPanel14.add(this.cmd_stop_btn);
        jPanel14.add(Box.createHorizontalGlue());
        this.cmd_help_btn = new JButton(" Usage ");
        uRL = this.getURL("/images/About24.gif");
        if (uRL != null) {
            this.cmd_help_btn.setIcon(new ImageIcon(uRL));
            this.cmd_help_btn.setVerticalTextPosition(0);
            this.cmd_help_btn.setHorizontalTextPosition(4);
        }
        this.cmd_help_btn.setToolTipText("Usage information of the selected logfile convertor.");
        jPanel14.add(this.cmd_help_btn);
        jPanel14.add(Box.createHorizontalGlue());
        this.cmd_close4cancel_btn = new JButton("Cancel");
        uRL = this.getURL("/images/ConvertCancel24.gif");
        if (uRL != null) {
            this.cmd_close4cancel_btn.setIcon(new ImageIcon(uRL));
            this.cmd_close4cancel_btn.setVerticalTextPosition(0);
            this.cmd_close4cancel_btn.setHorizontalTextPosition(4);
        }
        this.cmd_close4cancel_btn.setToolTipText("Close this panel.");
        jPanel14.add(this.cmd_close4cancel_btn);
        jPanel14.add(Box.createHorizontalGlue());
        this.cmd_close4ok_btn = null;
        if (bl) {
            this.cmd_close4ok_btn = new JButton("OK");
            uRL = this.getURL("/images/ConvertOk24.gif");
            if (uRL != null) {
                this.cmd_close4ok_btn.setIcon(new ImageIcon(uRL));
                this.cmd_close4ok_btn.setVerticalTextPosition(0);
                this.cmd_close4ok_btn.setHorizontalTextPosition(4);
            }
            this.cmd_close4ok_btn.setToolTipText("Display the last converted SLOG2 logfile and Exit this dialog box.");
            jPanel14.add(this.cmd_close4ok_btn);
            jPanel14.add(Box.createHorizontalGlue());
        }
        super.add(jPanel14);
    }

    private void initAllTextFields() {
        ConvertorConst.initializeSystemProperties();
        this.cmd_path2jvm.setText(ConvertorConst.getDefaultPathToJVM());
        String string = ConvertorConst.getDefaultPathToJarDir();
        this.cmd_path2jardir.setText(string);
        String string2 = null;
        try {
            string2 = this.cmd_option4jvm.getText();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string2 == null || string2.length() <= 0) {
            // empty if block
        }
        this.cmd_option4jvm.setText("-Xms32m -Xmx64m");
    }

    public String selectLogFile() {
        int n = this.file_chooser.showOpenDialog(this.top_window);
        if (n == 0) {
            File file = this.file_chooser.getSelectedFile();
            if (file != null) {
                File file2 = file.getParentFile();
                if (file2 != null) {
                    this.file_chooser.setCurrentDirectory(file2);
                }
                return file.getPath();
            }
        } else {
            Dialogs.info(this.top_window, "No file chosen", null);
        }
        return null;
    }

    private void printSelectedConvertorHelp() {
        String string = (String)this.cmd_pulldown.getSelectedItem();
        String string2 = this.cmd_path2jardir.getText();
        String string3 = ConvertorConst.getDefaultJarPath(string2, string);
        File file = new File(string3);
        if (!file.exists()) {
            Dialogs.error(this.top_window, string3 + " does not exist!");
            return;
        }
        if (!file.canRead()) {
            Dialogs.error(this.top_window, string3 + " is NOT readable!\n");
            return;
        }
        RuntimeExecCommand runtimeExecCommand = new RuntimeExecCommand();
        runtimeExecCommand.addWholeString(this.cmd_path2jvm.getText());
        runtimeExecCommand.addTokenizedString(this.cmd_option4jvm.getText());
        String string4 = this.cmd_path2tracelib.getText();
        if (string4 != null && string4.length() > 0) {
            runtimeExecCommand.addWholeString("-Djava.library.path=" + string4);
        }
        runtimeExecCommand.addWholeString("-jar");
        runtimeExecCommand.addWholeString(string3);
        runtimeExecCommand.addWholeString("-h");
        this.cmd_textarea.append("Executing " + runtimeExecCommand.toString() + "....");
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(runtimeExecCommand.toStringArray());
            InputStreamThread inputStreamThread = new InputStreamThread(process.getErrorStream(), "Error", this.cmd_textarea);
            InputStreamThread inputStreamThread2 = new InputStreamThread(process.getInputStream(), "Output", this.cmd_textarea);
            inputStreamThread.start();
            inputStreamThread2.start();
            int n = process.waitFor();
            inputStreamThread.stopRunning();
            inputStreamThread = null;
            inputStreamThread2.stopRunning();
            inputStreamThread2 = null;
            this.cmd_textarea.append("\n> Ending with exit status " + n + "\n");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private SwingProcessWorker convertSelectedLogFile() {
        String string = this.cmd_infile.getText();
        File file = new File(string);
        if (!file.exists()) {
            Dialogs.error(this.top_window, string + " does not exist!\n" + "No conversion will take place.");
            return null;
        }
        if (file.isDirectory()) {
            Dialogs.error(this.top_window, string + " is a directory!\n" + "No conversion will take place.");
            return null;
        }
        if (!file.canRead()) {
            Dialogs.error(this.top_window, "File " + string + " is NOT readable!\n" + "No conversion will take place.");
            return null;
        }
        InputLog inputLog = null;
        try {
            inputLog = new InputLog(string);
        }
        catch (NullPointerException nullPointerException) {
            inputLog = null;
        }
        catch (Exception exception) {
            inputLog = null;
        }
        if (inputLog != null && inputLog.isSLOG2()) {
            Dialogs.error(this.top_window, string + " is already a SLOG-2 file!\n" + "No conversion will take place.");
            this.cmd_outfile.setText(string);
            return null;
        }
        String string2 = this.cmd_outfile.getText();
        File file2 = new File(string2);
        if (file2.exists()) {
            if (file2.isDirectory()) {
                Dialogs.error(this.top_window, string2 + " is a directory!\n" + "No conversion will take place.");
                return null;
            }
            if (!file2.canWrite()) {
                Dialogs.error(this.top_window, "File " + string2 + " cannot be written!\n" + "No conversion will take place.");
                return null;
            }
            if (!Dialogs.confirm(this.top_window, string2 + " already exists! " + "Do you want to overwrite it ?")) {
                Dialogs.info(this.top_window, "Please change the output filename and restart the conversion again.", null);
                return null;
            }
            file2.delete();
        }
        String string3 = (String)this.cmd_pulldown.getSelectedItem();
        String string4 = this.cmd_path2jardir.getText();
        String string5 = ConvertorConst.getDefaultJarPath(string4, string3);
        File file3 = new File(string5);
        if (!file3.exists()) {
            Dialogs.error(this.top_window, string5 + " does not exist!");
            return null;
        }
        RuntimeExecCommand runtimeExecCommand = new RuntimeExecCommand();
        runtimeExecCommand.addWholeString(this.cmd_path2jvm.getText());
        runtimeExecCommand.addTokenizedString(this.cmd_option4jvm.getText());
        String string6 = this.cmd_path2tracelib.getText();
        if (string6 != null && string6.length() > 0) {
            runtimeExecCommand.addWholeString("-Djava.library.path=" + string6);
        }
        runtimeExecCommand.addWholeString("-jar");
        runtimeExecCommand.addWholeString(string5);
        String string7 = this.cmd_option4jar.getText();
        if (string7 != null && string7.length() > 0) {
            runtimeExecCommand.addTokenizedString(string7);
        }
        runtimeExecCommand.addWholeString("-o");
        runtimeExecCommand.addWholeString(string2);
        runtimeExecCommand.addWholeString(string);
        ProgressAction progressAction = new ProgressAction(this.cmd_outfile_size, this.cmd_progress);
        progressAction.initialize(file, file2);
        SwingProcessWorker swingProcessWorker = new SwingProcessWorker(this, this.cmd_textarea);
        swingProcessWorker.initialize(runtimeExecCommand.toStringArray(), progressAction);
        swingProcessWorker.start();
        return swingProcessWorker;
    }

    private void resetAllButtons(boolean bl) {
        this.cmd_start_btn.setEnabled(!bl);
        this.cmd_stop_btn.setEnabled(bl);
        this.cmd_help_btn.setEnabled(!bl);
        if (this.cmd_close4cancel_btn != null) {
            this.cmd_close4cancel_btn.setEnabled(!bl);
        }
        if (this.cmd_close4ok_btn != null) {
            if (this.logconv_worker != null && this.logconv_worker.isEndedNormally()) {
                this.cmd_close4ok_btn.setEnabled(!bl);
            } else {
                this.cmd_close4ok_btn.setEnabled(false);
            }
        }
    }

    public void initializeWaiting() {
        Routines.setComponentAndChildrenCursors(this.cmd_splitter, CustomCursor.Wait);
        this.resetAllButtons(true);
    }

    public void finalizeWaiting() {
        this.resetAllButtons(false);
        Routines.setComponentAndChildrenCursors(this.cmd_splitter, CustomCursor.Normal);
    }

    public void addActionListenerForOkayButton(ActionListener actionListener) {
        if (actionListener != null && this.cmd_close4ok_btn != null) {
            this.cmd_close4ok_btn.addActionListener(actionListener);
        }
    }

    public void addActionListenerForCancelButton(ActionListener actionListener) {
        if (actionListener != null && this.cmd_close4cancel_btn != null) {
            this.cmd_close4cancel_btn.addActionListener(actionListener);
        }
    }

    public String getOutputSLOG2Name() {
        return this.cmd_outfile.getText();
    }

    private class HelpConvertorListener
    implements ActionListener {
        private HelpConvertorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConvertorPanel.this.cmd_path2jardir.fireActionPerformed();
            ConvertorPanel.this.printSelectedConvertorHelp();
        }
    }

    private class StopConvertorListener
    implements ActionListener {
        private StopConvertorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ConvertorPanel.this.logconv_worker != null) {
                ConvertorPanel.this.logconv_worker.finished();
                ConvertorPanel.this.logconv_worker = null;
            }
        }
    }

    private class StartConvertorListener
    implements ActionListener {
        private StartConvertorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConvertorPanel.this.logconv_worker = ConvertorPanel.this.convertSelectedLogFile();
        }
    }

    private class JarDirectoryListener
    implements ActionListener {
        private JarDirectoryListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            String string2;
            String string3 = (String)ConvertorPanel.this.cmd_pulldown.getSelectedItem();
            String string4 = ConvertorPanel.this.cmd_path2tracelib.getText();
            if (string4 == null) {
                string4 = "";
            }
            if ((string2 = ConvertorConst.getDefaultTraceLibPath(string3, string = ConvertorPanel.this.cmd_path2jardir.getText())) == null) {
                string2 = "";
            }
            if (string4.equals(string2)) {
                return;
            }
            string = ConvertorConst.getDefaultPathToJarDir();
            String string5 = ConvertorConst.getDefaultTraceLibPath(string3, string);
            if (string5 == null) {
                string5 = "";
            }
            if (!string4.equals(string5) && !Dialogs.confirm(ConvertorPanel.this.top_window, "TraceLibrary Path has been modified from the original default value.\nShould it be updated by the new default value based on your modified JAR Directory ?")) {
                return;
            }
            ConvertorPanel.this.cmd_path2tracelib.setText(string2);
        }
    }

    private class PulldownListener
    implements ActionListener {
        private PulldownListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)ConvertorPanel.this.cmd_pulldown.getSelectedItem();
            String string2 = ConvertorConst.getDefaultPathToJarDir();
            ConvertorPanel.this.cmd_path2tracelib.setText(ConvertorConst.getDefaultTraceLibPath(string, string2));
            ConvertorPanel.this.printSelectedConvertorHelp();
        }
    }

    private class OutputFileSelectorListener
    implements ActionListener {
        private OutputFileSelectorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ConvertorPanel.this.selectLogFile();
            if (string != null && string.length() > 0) {
                ConvertorPanel.this.cmd_outfile.setText(string);
            }
        }
    }

    private class InputFileSelectorListener
    implements ActionListener {
        private InputFileSelectorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ConvertorPanel.this.selectLogFile();
            if (string != null && string.length() > 0) {
                ConvertorPanel.this.cmd_infile.setText(string);
                ConvertorPanel.this.printSelectedConvertorHelp();
            }
        }
    }

    private class LogNameListener
    implements ActionListener {
        private LogNameListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ConvertorPanel.this.cmd_infile.getText();
            String string2 = ConvertorConst.getDefaultSLOG2Name(string);
            ConvertorPanel.this.cmd_outfile.setText(string2);
        }
    }
}

