/*
 * Decompiled with CFR 0.152.
 */
package old_base.drawable;

import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class ColorAlpha
extends Color
implements Comparable {
    public static final int BYTESIZE = 5;
    public static final int OPAQUE = 255;
    public static final int NEAR_OPAQUE = 191;
    public static final int HALF_OPAQUE = 127;
    public static final int NEAR_TRANSPARENT = 63;
    public static final int TRANSPARENT = 0;
    public static final ColorAlpha WHITE_NEAR_OPAQUE = new ColorAlpha(white, 191);
    public static final ColorAlpha WHITE_OPAQUE = new ColorAlpha(white, 255);
    public static final ColorAlpha YELLOW_OPAQUE = new ColorAlpha(yellow, 255);
    private boolean isModifiable;
    private static ColorAlpha[] colors;
    private static int next_color_index;

    public ColorAlpha() {
        super(255, 192, 203, 255);
        this.isModifiable = true;
    }

    public ColorAlpha(int n, int n2, int n3) {
        super(n, n2, n3, 255);
        this.isModifiable = true;
    }

    public ColorAlpha(Color color, int n) {
        super(color.getRed(), color.getGreen(), color.getBlue(), n);
        this.isModifiable = true;
    }

    public ColorAlpha(int n, int n2, int n3, int n4, boolean bl) {
        super(n, n2, n3, n4);
        this.isModifiable = bl;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(super.getRGB());
        dataOutput.writeBoolean(this.isModifiable);
    }

    public ColorAlpha(DataInput dataInput) throws IOException {
        super(dataInput.readInt(), true);
        this.isModifiable = dataInput.readBoolean();
    }

    public void readObject(DataInput dataInput) throws IOException {
        System.err.println("ColorAlpha.readObject() should NOT called");
    }

    public String toString() {
        return "(" + this.getRed() + "," + this.getGreen() + "," + this.getBlue() + "," + this.getAlpha() + "," + this.isModifiable + ")";
    }

    public int getLengthSq() {
        return super.getRed() * super.getRed() + super.getGreen() * super.getGreen() + super.getBlue() * super.getBlue();
    }

    public boolean equals(ColorAlpha colorAlpha) {
        return super.getRed() == colorAlpha.getRed() && super.getGreen() == colorAlpha.getGreen() && super.getBlue() == colorAlpha.getBlue();
    }

    public int compareTo(Object object) {
        ColorAlpha colorAlpha = (ColorAlpha)object;
        if (!this.equals(colorAlpha)) {
            return colorAlpha.getLengthSq() - this.getLengthSq();
        }
        return 0;
    }

    private static void initDefaultColors() {
        int[] nArray = new int[]{0, 51, 102, 153, 204, 255};
        int n = nArray.length;
        int n2 = n * n * n;
        colors = new ColorAlpha[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n; ++k) {
                    ColorAlpha.colors[n3] = new ColorAlpha(nArray[i], nArray[j], nArray[k]);
                    ++n3;
                }
            }
        }
        Arrays.sort(colors);
        next_color_index = 1;
    }

    public static ColorAlpha getNextDefaultColor() {
        if (colors == null) {
            ColorAlpha.initDefaultColors();
        }
        int n = next_color_index % (colors.length - 1);
        ++next_color_index;
        return colors[n];
    }

    public static final void main(String[] stringArray) {
        for (int i = 0; i < 500; ++i) {
            System.out.println(ColorAlpha.getNextDefaultColor());
        }
    }
}

