#!/usr/bin/perl

use strict;

use File::Basename;
use Getopt::Long;
use Term::ReadPassword;
use WWW::SourceforgeJP;

use constant PROJECT    => 'mod-uploader';
use constant USER       => 'kimata';

my %args = ();
my $sf;

GetOptions(\%args, "package=s", "mode=s", "version=s", "file=s");

$sf = WWW::SourceforgeJP->new(PROJECT);
$sf->login(USER, read_password('sourceforge pass: ', 0, 1));

if ($args{'mode'} eq 'release') {
    die '--file ꤵƤޤ' unless (defined $args{'file'});
    die 'ե (' . $args{'file'} . ') ¸ߤޤ' unless (-e $args{'file'});

    $sf->create_release($args{'package'}, $args{'version'}, $args{'file'});
} else {
    my @links = $sf->get_release_links();
    my $src_link = (grep($_->text() =~ /^mod_uploader-.*\.tgz$/, @links))[0];
    my $win32_bin_link = (grep($_->text() =~ /^mod_uploader\.so-.*\.zip$/, @links))[0];

    while (<>) {
        if (/\Q<!-- MARK:mod_uploader -->\E/) {
            print << "__HTML__";
<!-- MARK:mod_uploader -->
    <a href="@{[$src_link->url()]}[0]">
     @{[$src_link->text()]}[0]
    </a>
<!-- MARK:mod_uploader -->
__HTML__
            while (<>) {
                last if (/\Q<!-- MARK:mod_uploader -->\E/);
            }
        } elsif (/\Q<!-- MARK:mod_uploader-win32-bin -->\E/) {
            print << "__HTML__";
<!-- MARK:mod_uploader-win32-bin -->
    <a href="@{[$win32_bin_link->url()]}[0]">
     @{[$win32_bin_link->text()]}[0]
    </a>
<!-- MARK:mod_uploader-win32-bin -->
__HTML__
            while (<>) {
                last if (/\Q<!-- MARK:mod_uploader-win32-bin -->\E/);
            }
        } else {
            print;
        }
    }
}

# Local Variables:
# mode: cperl
# buffer-file-coding-system: euc-japan-unix
# End:
