/******************************************************************************
 * mod_uploader / CGIPostReader.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: CGIPostReader.cpp 563 2005-09-02 03:22:28Z svn $
 *****************************************************************************/

#include "CGIPostReader.h"
#include "PostReader.h"
#include "Misc.h"

#include <stdio.h>

#ifdef DEBUG
#include <iostream>
#endif


/******************************************************************************
 * public ᥽å
 *****************************************************************************/
CGIPostReader::CGIPostReader(apr_size_t block_size, progress *progress)
    : PostReader(block_size, progress),
      is_eof_(false)
{

}

void CGIPostReader::read(char *buffer, apr_size_t size, apr_size_t *read_size)
{
    if (UNLIKELY(is_eof_)) {
        return;
    }

    *read_size = fread(buffer, 1, size, stdin);

    is_eof_ = feof(stdin);
}


// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
