/*
 *	$Id: ml_str_parser.c,v 1.2 2002/10/01 13:30:55 arakiken Exp $
 */

#include  "ml_str_parser.h"

#include  <string.h>			/* memcpy */
#include  <kiklib/kik_mem.h>
#include  <kiklib/kik_debug.h>

#include  "ml_char_encoding.h"		/* ml_is_msb_set */


typedef struct ml_str_parser
{
	mkf_parser_t  parser ;

	/*
	 * !! Notice !!
	 * mkf_parser_reset() and mkf_parser_mark() don't recognize these members.
	 */
	ml_char_t *  str ;
	u_int  left ;
	u_int  comb_left ;

} ml_str_parser_t ;


/* --- static functions --- */

static int
next_char(
	mkf_parser_t *  parser ,
	mkf_char_t *  ch
	)
{
	ml_str_parser_t *  ml_str_parser ;
	ml_char_t *  ml_ch ;
	u_int  comb_size ;

	ml_str_parser = (ml_str_parser_t*) parser ;

	/* hack for mkf_parser_reset */
	ml_str_parser->str -= (parser->left - ml_str_parser->left) ;
	ml_str_parser->left = parser->left ;

	while( 1)
	{
		if( ml_str_parser->parser.is_eos)
		{
			goto  err ;
		}

		mkf_parser_mark( parser) ;

		/*
		 * skipping NULL
		 */
		if( ! ml_char_is_null( ml_str_parser->str))
		{
			break ;
		}

		ml_str_parser->left -- ;
		ml_str_parser->str ++ ;

		if( ml_str_parser->left == 0)
		{
			ml_str_parser->parser.is_eos = 1 ;
		}
	}

	ml_ch = ml_str_parser->str ;
	
	if( ml_str_parser->comb_left > 0)
	{
		ml_char_t *  combs ;
		
		if( ( combs = ml_get_combining_chars( ml_ch , &comb_size)) == NULL ||
			comb_size < ml_str_parser->comb_left)
		{
			/* strange ! */
			
			ml_str_parser->comb_left = 0 ;

			goto  err ;
		}
		
		ml_ch = &combs[ comb_size - ml_str_parser->comb_left] ;
		
		if( -- ml_str_parser->comb_left == 0)
		{
			ml_str_parser->left -- ;
			ml_str_parser->str ++ ;
		}
	}
	else
	{
		if( ml_get_combining_chars( ml_ch , &comb_size))
		{
			ml_str_parser->comb_left = comb_size ;
		}
		else
		{
			ml_str_parser->left -- ;
			ml_str_parser->str ++ ;
		}
	}
	
	ch->size = ml_char_size( ml_ch) ;
	memcpy( ch->ch , ml_char_bytes( ml_ch) , ch->size) ;
	ch->cs = ml_char_cs( ml_ch) ;

	if( ml_is_msb_set( ch->cs))
	{
		UNSET_MSB(ch->ch[0]) ;
	}

	/* XXX */
	ch->property = 0 ;

	if( ml_str_parser->left == 0)
	{
		ml_str_parser->parser.is_eos = 1 ;
	}

	/* hack for mkf_parser_reset */
	parser->left = ml_str_parser->left ;

	return  1 ;

err:
	/* hack for mkf_parser_reset */
	parser->left = ml_str_parser->left ;

	return  0 ;
}

static void
init(
	mkf_parser_t *  mkf_parser
	)
{
	ml_str_parser_t *  ml_str_parser ;

	ml_str_parser = (ml_str_parser_t*) mkf_parser ;

	ml_str_parser->parser.str = NULL ;
	ml_str_parser->parser.marked_left = 0 ;
	ml_str_parser->parser.left = 0 ;
	ml_str_parser->parser.is_eos = 0 ;

	ml_str_parser->str = NULL ;
	ml_str_parser->left = 0 ;
}

static void
set_str(
	mkf_parser_t *  mkf_parser ,
	u_char *  str ,
	size_t  size
	)
{
	/* do nothing */
}

static void
delete(
	mkf_parser_t *  s
	)
{
	free( s) ;
}


/* --- global functions --- */

mkf_parser_t *
ml_str_parser_new(void)
{
	ml_str_parser_t *  ml_str_parser ;
	
	if( ( ml_str_parser = malloc( sizeof( ml_str_parser_t))) == NULL)
	{
		return  NULL ;
	}

	init( (mkf_parser_t*) ml_str_parser) ;

	ml_str_parser->parser.init = init ;
	ml_str_parser->parser.set_str = set_str ;
	ml_str_parser->parser.delete = delete ;
	ml_str_parser->parser.next_char = next_char ;

	return  (mkf_parser_t*)ml_str_parser ;
}

void
ml_str_parser_set_str(
	mkf_parser_t *  mkf_parser ,
	ml_char_t *  str ,
	u_int  size
	)
{
	ml_str_parser_t *  ml_str_parser ;

	ml_str_parser = (ml_str_parser_t*) mkf_parser ;

	ml_str_parser->parser.is_eos = 0 ;
	ml_str_parser->parser.left = size ;
	
	ml_str_parser->str = str ;
	ml_str_parser->left = size ;
}
