/***************************************************************************
 *   Copyright (C) 2004 by Stefan Kombrink <katakombi@web.de>              *
 *   Copyright (C) 2004 by Nadeem Hasan <nhasan@kde.org>                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#ifndef _TOUCHPAD_H_
#define _TOUCHPAD_H_

#include <qrect.h>
#include <qstring.h>

#include <synaptics.h>

using namespace Synaptics;

class TouchPad
{
  public:
    static TouchPad *self();
    ~TouchPad();

    static bool isValid();

    // 0:enabled
    // 1:disabled
    // 2:notaps
    static QString driverVersion();
    static int isEnabled();
    static QRect edges();
    static bool isTappingEnabled();
    static int tapTime();
    static int tapAction( TapType type );
    static int sensitivity();
    static bool isHorizontalScrollEnabled();
    static int horizontalScrollDelta();
    static bool isVerticalScrollEnabled();
    static int verticalScrollDelta();
    static bool isEdgeMotionEnabled();
    static bool isCoastingEnabled();
    static bool isCircularScrollEnabled();
    static bool isTFHorizScrollEnabled();
    static bool isTFVertScrollEnabled();
    static int circularScrollDelta();
    static ScrollTrigger circularScrollTrigger();
    static Button buttonForTap( TapType tap );
    static bool areFastTapsEnabled();
    static int absCoordX();
    static int absCoordY();

    // 0:enabled
    // 1:disabled
    // 2:notaps
    static void setEnabled( int enable );
    static void setEdges( const QRect &edge );
    static void setTapTime( int time );
    static void setTapAction( TapType type, int action );
    static void setSensitivity( int value );
    static void setHorizontalScrollDelta( int delta );
    static void setVerticalScrollDelta( int delta );
    static void setCircularScrollEnabled( bool enable );
    static void setTFHorizScrollEnabled( bool enable );
    static void setTFVertScrollEnabled( bool enable );
    static void setEdgeMotionEnabled( bool enable );
    static void setCoastingEnabled( bool enable );
    static void setCircularScrollDelta( int delta );
    static void setCircularScrollTrigger( ScrollTrigger t );
    static void setButtonForTap( TapType tap, Button button );
    static void setFastTaps( bool enable );

    static void applyConfig();

protected:
    TouchPad();
    static TouchPad *m_self;
};

#endif
