/***************************************************************************
 *   Copyright (C) 2005 Nadeem Hasan <nhasan@kde.org>                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef EDGEWIDGET_H
#define EDGEWIDGET_H

#include <qwidget.h>

class EdgeWidget : public QWidget
{
  Q_OBJECT

  public:
    EdgeWidget( QWidget *parent, const char *name );
    ~EdgeWidget() {}

    void setEdges( const QRect &edges );

    enum State { None, TopMoving, BottomMoving, LeftMoving, RightMoving };

  protected:
    void paintEvent( QPaintEvent * );
    void drawPad( QPainter *p );
    QRect topLine() const;
    //QRect bottomLine() const;
    //QRect leftLine() const;
    //QRect rightLine() const;
    void resizeEvent( QResizeEvent * );

  signals:
    void edgesChanged( const QRect &edges );

  protected:
    const QRect m_bezel;
    QRect m_edges;
    State m_state;
    double m_scaleFactor;
};

#endif // EDGEWIDGET_H
