/***************************************************************************
 *   Copyright (C) 2004 by  ͤ                                            *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "dlgtypeinfo.h"

#include <qcursor.h>
#include <kmessagebox.h>
#include <kapplication.h>
#include <kconfig.h>
#include <kdebug.h>
#include <klocale.h>
#include <kiconloader.h>
#include <qvbox.h>
#include <qlabel.h>
#include <kurllabel.h>
#include <kio/netaccess.h>
#include <qheader.h>

dlgTypeInfo::dlgTypeInfo( QWidget *parent, const char *name )
	: KDialogBase( KDialogBase::Swallow, i18n("TypeInfo"), Ok|Cancel, Ok, parent, name, true )
	, m_pxmOk( SmallIcon( "button_ok" ) )
	, m_pxmCancel( SmallIcon( "button_cancel" ) )
{
	m_parent = parent;
	setIcon( SmallIcon( "fileopen" ) );
	QVBox *vbox = new QVBox( this );
	new QLabel( i18n("Please send mail with your suggestion!"), vbox );
	KURLLabel* label = new KURLLabel( "mailto:tasuku@linux-life.net", "tasuku@linux-life.net", vbox );
	connect( label, SIGNAL( leftClickedURL( const QString& ) ), this, SLOT( slotMailto( const QString& ) ) );

	lvwType = new KListView( vbox );
	lvwType->addColumn( i18n( "Display" ) );
	lvwType->addColumn( i18n( "Code" ) );
	lvwType->addColumn( i18n( "Category" ) );
	lvwType->addColumn( i18n( "Name" ) );
	lvwType->addColumn( i18n( "Example" ) );
	lvwType->setAllColumnsShowFocus( true );
	for( int i = 0; i != lvwType->header()->count(); i++ ){
		lvwType->setColumnWidthMode( i, QListView::Manual );
	}
	readData();
	btnDownload = new KPushButton( i18n("Download"), vbox );

	connect( btnDownload, SIGNAL( clicked() ), this, SLOT( slotDownload() ) );
	connect( lvwType, SIGNAL( executed( QListViewItem* ) ) , this, SLOT( slotCheck( QListViewItem* ) ) );
	connect( lvwType, SIGNAL( returnPressed( QListViewItem* ) ), this, SLOT( slotCheck( QListViewItem* ) ) );
	enableButtonOK( false );

	setMainWidget( vbox );

	resize( configDialogSize( "dlgTypeInfo" ) );
	KConfig *conf = KGlobal::config();
	lvwType->restoreLayout( conf, "lvwType" );
}

dlgTypeInfo::~dlgTypeInfo()
{
	KConfig *conf = KGlobal::config();
	lvwType->saveLayout( conf, "lvwType" );
	saveDialogSize( "dlgTypeInfo" );
}

void dlgTypeInfo::slotCheck( QListViewItem* item )
{
	CannaDic& cannadic = CannaDic::instance();
	cannadic[m_typeindex[item]].major = !cannadic[m_typeindex[item]].major;
	item->setPixmap( 0, cannadic[m_typeindex[item]].major ? m_pxmOk : m_pxmCancel );
	enableButtonOK( true );
}

void dlgTypeInfo::slotDownload()
{
	KURL url( "http://linux-life.net/program/cc/kde/app/kannadic/cannadic.txt" );
	QString fileName;
	if( !KIO::NetAccess::download( url, fileName, m_parent ) ){
		KMessageBox::sorry( m_parent, KIO::NetAccess::lastErrorString() );
		return;
	}

	if( !fileName.isEmpty() ){
		QFile file( fileName );
		if ( !file.open( IO_ReadOnly ) ){
			KMessageBox::sorry( m_parent, i18n("KannaDic can not open the file.") );
			return;
		}
		CannaDic& cannadic = CannaDic::instance();
		QTextStream ts( &file );
		QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
		while( !ts.atEnd() ){
			QString str( ts.readLine() );
			if( str.isEmpty() ){
				continue;
			}
			QStringList temp = QStringList::split( "\t", str, true );
			cannadic[m_code2index[temp[0]]].category = temp[1];
			cannadic[m_code2index[temp[0]]].name = temp[2];
			cannadic[m_code2index[temp[0]]].example = temp[3];
			m_code2item[temp[0]]->setText( 2, temp[1] );
			m_code2item[temp[0]]->setText( 3, temp[2] );
			m_code2item[temp[0]]->setText( 4, temp[3] );
		}
		file.close();
		QApplication::restoreOverrideCursor();
	}
	KIO::NetAccess::removeTempFile( fileName );
	enableButtonOK( true );
}

void dlgTypeInfo::slotMailto( const QString& address )
{
	KApplication::kApplication()->invokeMailer( address, i18n( "KannaDic TypeInfo" ) );
}

void dlgTypeInfo::readData()
{
	KListViewItem* item;
	int i = 0;
	lvwType->clear();
	CannaDic& cannadic = CannaDic::instance();
	for( CannaDic::iterator it = cannadic.begin(); it != cannadic.end(); ++it )
	{
		item = new KListViewItem( lvwType, "", (*it).code, (*it).category, (*it).name, (*it).example );
		m_typeindex[item] = i;
		m_code2index[(*it).code] = i;
		m_code2item[(*it).code] = item;
		item->setPixmap( 0, (*it).major ? m_pxmOk : m_pxmCancel );
		i++;
	}
}

void dlgTypeInfo::slotOk()
{
	CannaDic::instance().saveData();
	emit okClicked();
	accept();
}

