/***************************************************************************
*   Copyright (C) 2004 by  ͤ                                            *
*   tasuku@linux-life.net                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "dlgedit.h"
#include "cannadic.h"

#include <kmessagebox.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <kconfig.h>
#include <qlayout.h>
#include <qstringlist.h>

dlgEdit::dlgEdit( QWidget *parent, const char *name )
 : KDialogBase(KDialogBase::Plain, i18n("Edit"), Ok|Cancel, Ok, parent, name, true )
{
	enableLinkedHelp( false );
	QFrame* page = plainPage();
	QGridLayout *glay = new QGridLayout( page, 0, 0 );

	QLabel* lblFrom = new QLabel( i18n("From"), page );
	txtFrom = new KLineEdit( page );

	QLabel* lblTo = new QLabel( i18n("To"), page );
	txtTo = new KLineEdit( page );

	wstType = new QWidgetStack( page );
	lblType = new QLabel( i18n("Type"), wstType );
	chkType = new QCheckBox( i18n("Type"), wstType );
	cbxType = new KComboBox( page );

	wstFreq = new QWidgetStack( page );
	lblFreq = new QLabel( i18n("Freq"), wstFreq );
	chkFreq = new QCheckBox( i18n("Freq"), wstFreq );
	iniFreq = new KIntNumInput( page );
	iniFreq->setRange( 1, 100 );

	CannaDic& cannadic = CannaDic::instance();
	for( CannaDic::iterator it = cannadic.begin(); it != cannadic.end(); ++it )
	{
		if( (*it).major ){
			cbxType->insertItem( (*it).toString() );
			m_type.push_back( *it );
		}
	}

	glay->addWidget( lblFrom, 0, 0 );
	glay->addWidget( txtFrom, 0, 1 );
	glay->addWidget( lblTo, 1, 0 );
	glay->addWidget( txtTo, 1, 1 );
	glay->addWidget( wstType, 2, 0 );
	glay->addWidget( cbxType, 2, 1 );
	glay->addWidget( wstFreq, 3, 0 );
	glay->addWidget( iniFreq, 3, 1 );
	glay->activate();

	KConfig *conf = KGlobal::config();
	conf->setGroup("dlgEdit");
	resize( configDialogSize( "dlgEdit" ) );

	connect( chkType, SIGNAL( clicked() ), this, SLOT( slotChangeEnabled() ) );
	connect( chkFreq, SIGNAL( clicked() ), this, SLOT( slotChangeEnabled() ) );
}

dlgEdit::~dlgEdit()
{
	saveDialogSize( "dlgEdit" );
}

void dlgEdit::setEditMode( EditModes mode, bool blFreqEnabled )
{
	switch( mode )
	{
		case APPEND:
			setIcon( BarIcon( "filenew" ) );
			setCaption( i18n("Append") );
			txtFrom->setText( "" );
			txtTo->setText( "" );
			cbxType->setCurrentItem( 0 );
			if( m_isFreq ){
				iniFreq->setValue( 1 );
			}
			break;
		case EDIT:
			wstType->raiseWidget( lblType );
			wstFreq->raiseWidget( lblFreq );
			setIcon( BarIcon( "edit" ) );
			setCaption( i18n("Edit") );
			break;
		case MULTIEDIT:
			wstType->raiseWidget( chkType );
			wstFreq->raiseWidget( chkFreq );
			setIcon( BarIcon( "edit" ) );
			setCaption( i18n("Edit") );
			break;
	}
	txtFrom->setEnabled( mode != MULTIEDIT );
	txtTo->setEnabled( mode != MULTIEDIT );
	txtFrom->setFocus();

	chkType->setChecked( !blFreqEnabled || mode != MULTIEDIT );
	chkFreq->setChecked( blFreqEnabled );
	wstFreq->setEnabled( blFreqEnabled );
	iniFreq->setEnabled( blFreqEnabled );
	slotChangeEnabled();
}

void dlgEdit::addType( Type type )
{
	if( !m_type.contains( type ) ){
		cbxType->insertItem( type.toString() );
		m_type.push_back( type );
	}
}

void dlgEdit::setWordItem( WordItem* worditem )
{
	txtFrom->setText( worditem->word().from );
	txtTo->setText( worditem->word().to );
	if( !m_type.contains( worditem->word().type ) ){
		cbxType->insertItem( worditem->word().type.toString() );
		m_type.push_back( worditem->word().type );
	}
	cbxType->setCurrentText( worditem->word().type.toString() );
	if( m_isFreq ){
		iniFreq->setValue( worditem->word().freq );
	}
}

Word dlgEdit::word()
{
	Word word;
	word.from = txtFrom->text();
	word.to = txtTo->text();
	word.type = m_type[cbxType->currentItem()];
	if( m_isFreq ){
		word.freq = iniFreq->value();
	}else{
		word.freq = 0;
	}
	return word;
}

void dlgEdit::slotOk()
{
	if( isError() ) return;
	emit okClicked();
	accept();
}

bool dlgEdit::isError()
{
	if( txtFrom->text() == "" ){
		KMessageBox::error( this, i18n("From is Empty"), i18n("Error") );
		txtFrom->setFocus();
		return true;
	}
	if( txtTo->text() == "" ){
		KMessageBox::error( this, i18n("To is Empty"), i18n("Error") );
		txtTo->setFocus();
		return true;
	}
	return false;
}

void dlgEdit::slotChangeEnabled()
{
	cbxType->setEnabled( chkType->isChecked() );
	iniFreq->setEnabled( chkFreq->isChecked() );
	enableButtonOK( chkType->isChecked() || chkFreq->isChecked() );
}
