C*********************************************************************** 
C***********************************************************************
C***********************************************************************
C*****                                                            ******
C*****                                                            ******
C*****                       A N S W E R S                        ******
C*****                                                            ******
C*****              (AREAL NONPOINT SOURCE WATERSHED              ******
C*****              ENVIRONMENT RESPONSE SIMULATION)              ******
C*****                                                            ******
C*****                                                            ******
C*****  AUTHORS:  D. B. BEASLEY, L. F. HUGGINS, AND J. R. BURNEY  ******
C*****                                                            ******
C*****   AGRICULTURAL ENGINEERING DEPARTMENT, PURDUE UNIVERSITY   ******
C*****               WEST LAFAYETTE, INDIANA  47907               ******
C*****                                                            ******
C*****                                                            ******
C***********************************************************************
C***********************************************************************
C***********************************************************************
C*****                                                            ******
C*****       CURRENT MODIFICATION DATE:   15 FEBRUARY, 1988       ******
C*****                                                            ******
C*****    THE COMPONENTS CONTAINED IN THIS PROGRAM HAVE BEEN      ******
C*****    THOROUGHLY TESTED USING OBSERVED INFORMATION FROM       ******
C*****    BOTH PLOT AND WATERSHED RESEARCH AREAS.  SINCE THE      ******
C*****    MODEL IS STILL UNDERGOING DEVELOPMENT, THE ADDITION     ******
C*****    OR MODIFICATION OF COMPONENT RELATIONSHIPS SHOULD       ******
C*****    BE EXPECTED FROM ONE RELEASE TO ANOTHER.  BECAUSE OF    ******
C*****    THIS, SLIGHTLY DIFFERENT SIMULATION RESULTS MAY BE      ******
C*****    OBTAINED.  ALWAYS USE THE MOST CURRENT RELEASE!!        ******
C*****                                                            ******
C***********************************************************************
C***********************************************************************
C*****                                                            ******
C*****      THIS VERSION OF ANSWERS CONTAINS:                     ******
C*****                                                            ******
C*****      1)  MEMORY CONSERVATION EQUIVALENCING                 ******
C*****      2)  3-PER-PASS ALGORITHM                              ******
C*****      3)  IMPROVED DATA VERIFICATION DIAGNOSTICS            ******
C*****      4)  STRUCTURAL PRACTICES                              ******
C*****      5)  MODIFIED INPUT FORMATS (SEE USER'S MANUAL)        ******
C*****      6)  MODIFIED DETACHMENT AND TRANSPORT RELATIONSHIPS   ******
C*****      7)  MODIFIED OUTPUT FORMATS                           ******
C*****                                                            ******
C*****      THE FOLLOWING ARE NEW WITH THIS RELEASE:              ******
C*****                                                            ******
C*****      8)  1977 ANSI STANDARD FORTRAN CODING                 ******
C*****          (SHOULD YOUR PARTICULAR COMPILER NOT BE ANSI-     ******
C*****          1977 COMPATIBLE, SIMPLY REMOVE THE CHARACTER      ******
C*****          DEFINITION STATEMENTS AT THE BEGINNING OF THE     ******
C*****          MAIN PROGRAM AND ALL SUBROUTINES)                 ******
C*****      9)  PROBLEM WITH MULTIPLE RAIN GAGES IN THE DATA      ******
C*****          SUBROUTINE INITIALIZATION ROUTINE CORRECTED       ******
C*****     10)  FLOATING UNDERFLOW PROBLEM CORRECTED              ******
C*****                                                            ******
C***********************************************************************
C***********************************************************************
C 
C 
C ****** DISTRIBUTED PARAMETER MATHEMATICAL MODEL OF A RAINFALL 
C ****** EVENT ON A CATCHMENT, WITH EROSION AND DEPOSITION. 
C 
C **** MAXIMUM NUMBER OF SOIL TYPES IS 20.
C 
      COMMON /CSOIL/ A(20),P(20),FC(20),GWC(20),SKDR(20)
C 
C **** MAXIMUM NUMBER OF SURFACE AND CROP TYPES IS 20.
C 
      COMMON /CROUGH/ ROUGH(20),HU(20),DIR(21),PIT(5,20),PER(20),CDR(20)
C 
C **** MAXIMUM NUMBER OF RAINGAGES IS 4 WITH 35 VALUES PER GAGE.
C 
      COMMON /CRGAGE/ RC(4,35),TC(4,35),R(4,20),FRA(4),JTR(4),RATE(4),SR
     1(4),NF(4) 
C 
C **** MAXIMUM NUMBER OF OVERLAND ELEMENTS PLUS CHANNEL ELEMENTS
C **** IS 1700 = NMAX.
C 
C ****** IT IS EXPECTED THAT ARRAY "IEL" (IN SUBROUTINE DATA) WILL
C ****** BE OF SUCH A SIZE THAT IT WILL OVERLAY (BE EQUIVALENCED TO)
C ****** THE SPACE IN ARRAYS SI AND QI TOGETHER.  THEREFORE IT IS 
C ****** NECESSARY THAT THESE TWO ARRAYS BE KEPT ADJACENT IN THEIR
C ****** COMMON BLOCK.  NOTE: THE ACTUAL NUMBER OF ELEMENTS THAT
C ****** CAN BE DIMENSIONED IN IEL WILL DEPEND ON THE WORD LENGTH 
C ****** OF THE MACHINE BEING USED, E.G. ON A MACHINE WHICH USES
C ****** A SINGLE WORD INTEGER AND A DOUBLE WORD REAL, THE NUMBER 
C ****** OF ELEMENTS IN IEL CAN BE FOUR TIMES THE NUMBER OF ELEMENTS
C ****** IN ARRAY SI. 
C 
      COMMON /CFLOW/ Q(1700),RFL(1700),FLINS(1700),SS(1700),PIV(1700),B(
     11700),NR(1700),NC(1700),DR(1700),S(1700),SL(1700),SEL(1700),SI(171
     20),QI(1710),DIN(1700),SST(1700) 
C 
C ****** ARRAYS SI AND QI MUST BE DIMENSIONED TO A SIZE = NMAX+ISTRUC+2 
C ****** TO HOLD, IN ORDER, SEDIMENT AND FLOW FROM THE WATERSHED OUTLET 
C ****** ELEMENT, STRUCTURAL PRACTICES AND ANY "LEAKY" ELEMENTS.
C 
      EQUIVALENCE (FILTS(1),CWID(1))
      DIMENSION CWID(1700), FILTS(1700) 
      EQUIVALENCE (TIAL(1),RANE(1)), (SUR(1),SOIL(1)) 
      COMMON /CSURF/ SUR(1700),RANE(1700) 
      INTEGER SUR,SOIL(1700),TIAL(1700),RANE
C 
C **** NUMBER OF PRINT AND PLOT POINTS IS 101 MAXIMUM.
C 
      DIMENSION T(101), Q1(101), RW(101), SSI(101), SSCON(101)
      DIMENSION PP(14), QA(300), TT(20) 
      CHARACTER*4 PP, TT
      DATA PP(1),PP(2),PP(3),PP(4),PP(5),PP(6),PP(7),PP(8),PP(9),PP(10),
     1PP(11),PP(12),PP(13),PP(14)/' IN.','/HR.',' AC.',' FT.',' LB.', 
     2' PPM','/AC ','  MM','/H  ',' HA ',' M  ','  KG','MG/L','/HA '/ 
C
C **** NEW TRANSPORT AND DETACHMENT CONSTANTS.
C
C
C **** TRANSPORT COEFFICIENTS (CE1 AND CE2) ARE 10 PERCENT LARGER THAN
C **** THOSE USED IN THE ORIGINAL VERSION OF THE MODEL.  THESE CHANGES
C **** WERE PRECIPITATED BY ADDITIONAL INFORMATION FROM SEVERAL RAIN-
C **** FALL SIMULATOR PLOT STUDIES THAT INDICATED THAT YIELDS WERE ON
C **** THE ORDER OF 10 PERCENT HIGHER THAN PREDICTED WHEN THE WATER-
C **** SHED WAS IN A "TRANSPORT LIMITED" SITUATION.
C
C **** DETACHMENT COEFFICIENT CE3 (RAINFALL) WAS INCREASED BY A FACTOR
C **** OF 4 IN THE MARCH 15, 1982 VERSION OF ANSWERS.  THE REASON FOR
C **** THIS LARGE INCREASE WAS THAT A NUMBER OF THE RAINFALL SIMULATOR
C **** PLOTS THAT WERE USED IN COEFFICIENT CALCULATION HAD DEPOSITION
C **** AREAS.  HOWEVER, AFTER CLOSER EXAMINATION OF PHOTOGRAPHS AND
C **** SURVEY INFORMATION, THE DETACHMENT COEFFICIENT WAS DEEMED TO
C **** BE TOO HIGH.  THUS, THE CURRENT ACCEPTED VALUE OF CE3 IS TWICE
C **** THE ORIGINAL VALUE (GASP-IV VERSION OF ANSWERS).
C
C **** DETACHMENT COEFFICIENT CE4 (FLOW) WAS INCREASED BY A FACTOR OF
C **** 50 IN THE MARCH 15, 1982 VERSION OF ANSWERS.  THE REASON FOR
C **** THIS DRAMATIC INCREASE WAS SOME RAINFALL SIMULATOR DATA THAT
C **** SHOWED THE DIFFERENCE BETWEEN RAINFALL-ONLY AND RAINFALL PLUS
C **** UPSLOPE FLOW SEDIMENT YIELDS.  WHILE THE YIELDS INCREASED
C **** SUBSTANTIALLY WITH THE INCREASED FLOW, IT APPEARS THAT THE
C **** MAJOR SOURCE OF SEDIMENT WAS WASHOFF OF UNATTACHED PARTICLES,
C **** NOT DETACHMENT OF COHESIVE PARTICLES.  A RE-EXAMINATION OF THE
C **** FLOW DETACHMENT EQUATION HAS LED TO THE CONCLUSION THAT THE
C **** FLOW DETACHMENT COEFFICIENT SHOULD BE APPROXIMATELY 5 TIMES
C **** GREATER THAN THE ORIGINAL VALUE (NOT 50 TIMES).
C
C **** WHILE THE C AND K FACTORS IN THE USLE ARE USED TO DESCRIBE
C **** THE RELATIVE DEGREE OF ERODIBILITY OF A PARTICULAR SOIL IN
C **** THIS MODEL, THE IMPACTS OF SURFACE COMPACTION, ROUGHNESS,
C **** TEMPERATURE, ETC. ARE NOT TAKEN INTO ACCOUNT.  THUS, WHILE
C **** THE EROSION EQUATIONS WORK FOR THOSE SOIL SERIES FOR WHICH
C **** WE HAVE RAINFALL SIMULATOR AND WATERSHED DATA, THEY MAY NOT
C **** DO AN ADEQUATE JOB ON OTHER TYPES OF TOPOGRAPHY, SOIL TEXTURE,
C **** SURFACE CONDITION, ETC.  FOR THESE REASONS, CE3 AND CE4 SHOULD
C **** BE CONSIDERED AS POTENTIAL VARIABLES.  RESEARCH NOW BEING
C **** CONDUCTED SHOULD YIELD BETTER DESCRIPTIONS OF THE DETACHMENT
C **** PROCESS AND THE COEFFICIENTS ASSOCIATED WITH IT.  WHILE IT
C **** IS NOT POSSIBLE TO GIVE EXACT INSTRUCTIONS ON MODIFICATIONS
C **** THAT SHOULD BE MADE TO COEFFICIENTS WHEN SIMULATED AND OBSERVED
C **** RESULTS DON'T AGREE, WE WILL CERTAINLY BE WILLING TO DISCUSS
C **** THE PROBLEM AND MAKE SUGGESTIONS FOR LOGICAL MODEL MODIFICATIONS.
C
C **** TO EITHER MAKE SUGGESTIONS OR RECEIVE FURTHER INFORMATION, CONTACT:
C
C ****                   DAVID B. BEASLEY, PH.D., P.E.
C ****                   AGRICULTURAL ENGINEERING DEPARTMENT
C ****                   UNIVERSITY OF GEORGIA -- CPES
C ****                   TIFTON, GA  31793-0748
C ****                   PHONE: (912) 386-3377
C
      DATA CE1,CE2,CE3,CE4,CE5,CE6/5603.,4.26,62208.0,0.1,.00833333,62.3
     174/ 
      READ (5,280) (TT(I),I=1,19) 
      WRITE (6,290) (TT(I),I=1,19)
C 
C **** READ, TRANSFORM AND RETURN INPUT INFORMATION.
C 
      CALL DATA (NDT,KPR,N,CONV,CU,SF,IT,NN,ICR,NFI,CU2,ISTRUC,SB,TMIN,T
     1MAX,NRG,DX,GRF,NEXP,DC,PP,FILTS,CWID,AREA,DT,NMAX)
C 
C **** COMPUTE THE PIECE-WISE LINEAR SEGMENTS FOR USE IN MANNING'S
C **** EQUATION.
C 
      SC=((SF*CONV/SB)**.6)/300.
      D=0.
      DO 10 I=1,300 
      QA(I)=D**1.66667
   10 D=D+SC
      SC=1./SC
C 
C **** INITIALIZE VARIABLES.
C **** SET RAINFALL INITIAL VALUES. 
C 
      DO 20 I=1,NRG 
      JTR(I)=1
      IF (TC(I,2).EQ.TMIN) JTR(I)=2 
      SR(I)=0.
   20 NF(I)=NFI 
      N1=N+1
      N2=NN-1 
      CHN=N2-N
C 
C **** EROSION CONSTANTS. 
C 
      IF (IT.LE.0) GO TO 30 
C 
C **** METRIC UNITS.
C 
      CE1=9.66155E+5
      CE2=2.0847E+1 
      CE3=3.26932E+6
      CE4=5.25545
      CE5=7.7419E-4 
      CE6=1.E+3 
C 
C **** INITIALIZE VALUES. 
C 
   30 VOL=0.
      SSI(1)=0. 
      SDR=0.
      CHDR=0. 
      SSCON(1)=0. 
      RW(1)=0.
      Q1(1)=0.
      RMAX=0. 
      QMAX=0. 
      CMAX=0. 
      PREC=0. 
      DTM=DT/60.
      T(1)=TMIN 
C 
C **** WRITE HYDROGRAPH HEADING AND INITIAL VALUE.
C 
      WRITE (6,300) PP(IT+6),PP(IT+1),PP(IT+2),PP(IT+1),PP(IT+2),PP(IT+5
     1) 
      WRITE (6,310) T(1),RW(1),Q1(1),SSI(1),SSCON(1)
C 
C **** START COMPUTATION FOR EACH HYDROGRAPH PRINT LINE AT DT*KPR.
C 
      DO 220 L=2,NDT
      LM1=L-1 
      T(L)=T(LM1) 
C 
C **** CONTINUITY EQUATION FOR TIME INCREMENTS DT.
C 
      DO 170 J=1,KPR
      SPT=SI(NN)
      T(L)=T(L)+DTM 
C 
C **** CALCULATE NET RAINFALL FOR EACH GAGE AND SURFACE CONDITION AND 
C **** UPDATE INFILTRATION CAPACITIES WITHIN GAGE AREA ON TIME OR NET 
C **** RAINFALL CHANGE. 
C 
      DO 90 JJ=1,NRG
      NF(JJ)=NF(JJ)-1 
      ITR=JTR(JJ) 
      ITRM1=ITR-1 
      IF (T(L)-TC(JJ,ITR)) 60,60,40 
   40 IF (T(L)-TMAX) 50,230,230 
C 
C **** NEW RAINFALL RATE, ALLOW FOR DTM BRIDGING TC VALUE.
C 
   50 DI=T(L)-TC(JJ,ITR)
      ITRP1=ITR+1
      RATE(JJ)=CU*(RC(JJ,ITRP1)*DI+RC(JJ,ITR)*(DTM-DI))/DTM 
      JTR(JJ)=JTR(JJ)+1 
      ITR=ITRP1 
C 
C **** ADD WHOLE HISTOGRAM BLOCK TO TOTAL PRECIPITATION IN
C **** PROPORTION TO WATERSHED AREA COVERED.
C 
      PREC=PREC+RC(JJ,ITR)*(TC(JJ,ITR)-TC(JJ,ITR-1))*FRA(JJ)/60.
C 
C **** CALCULATE NET RAINFALL FOR EACH COVER. 
C 
   60 DO 70 I=1,ICR 
      R(JJ,I)=RAIN(RATE(JJ),PIT(JJ,I),PER(I)) 
      IF (R(JJ,I).EQ.SR(JJ).AND.NF(JJ).GT.0) GO TO 70 
      SR(JJ)=R(JJ,I)
      NF(JJ)=-NFI 
   70 CONTINUE
      RATE(JJ)=RC(JJ,ITR)*CU
      IF (NF(JJ).GT.0) GO TO 90 
C 
C **** CALCULATION OF INFILTRATION CAPACITY FOR EACH OVERLAND ELEMENT.
C 
      DO 80 M=1,N 
      IF (MOD(RANE(M),256).NE.JJ) GO TO 80
      K=MOD(SUR(M),256) 
      KK=SOIL(M)/256
      FILTS(M)=FILT(A(KK),PIV(M),P(KK),FC(KK),GWC(KK),DR(M),S(M),R(JJ,K)
     1,CU2,ROUGH(K),HU(K),NEXP) 
   80 CONTINUE
      NF(JJ)=NFI
   90 CONTINUE
C 
C **** CONTINUITY EQUATION EXPLICIT SOLUTION FOR EACH ELEMENT DURING
C **** TIME INCREMENT, DT.
C 
      DO 170 M=1,N2 
      SSTOR=S(M)+SS(M)
      IF (SSTOR.LT.0.) SSTOR=0. 
      IF (M.GT.N) GO TO 100 
C 
C **** OVERLAND ELEMENT.
C 
      I=MOD(RANE(M),256)
      K=MOD(SUR(M),256) 
      KK=SOIL(M)/256
      SUPP=.5*SSTOR+QI(M)+R(I,K)
      FIL=FILTS(M)
      IF (FIL.GT.SUPP) FIL=SUPP 
      PIV(M)=PIV(M)+DR(M)-FIL 
      SDR=SDR+DR(M) 
      FLIN=QI(M)+R(I,K)-FIL 
      GO TO 110 
C 
C **** CHANNEL ELEMENT. 
C 
  100 K=21
      FLIN=QI(M)+CHDR+DIN(M)
C 
C **** COMBINE INITIAL INFLOW, OUTFLOW AND STORAGE WITH ACCUMULATED 
C **** INFLOW.
C 
  110 FHS=FLINS(M)+FLIN 
      IF (SSTOR.GT.DIR(K)) GO TO 130
C 
C **** NO RUNOFF FROM ELEMENT.
C 
  120 S(M)=FHS
      SS(M)=0.
      FLINS(M)=FLIN+FHS 
      IF (Q(M).EQ.0.) GO TO 170 
      D=-Q(M) 
      Q(M)=0. 
      GO TO 150 
C 
C **** DIRECT SOLUTION OF CONTINUITY EQUATION BY LINEARIZATION. 
C 
  130 Y=SC*(SSTOR-DIR(K)) 
      IY=Y+1. 
      IF (IY.LT.300) GO TO 140
      WRITE (6,330) M 
      STOP
  140 Y=IY-1
      QL=B(M)*QA(IY)
      QD=B(M)*(QA(IY+1)-QA(IY)) 
      SSTOR=(FHS-QL+QD*(Y+DIR(K)*SC))/(1.+QD*SC)
      IF (SSTOR.LE.DIR(K)) GO TO 120
      Q2=QL+QD*((SSTOR-DIR(K))*SC-Y)
      IF (Q2.LT.1.E-20) Q2=0.
      D=Q2-Q(M) 
      Q(M)=Q2 
      SS(M)=SSTOR-S(M)
      IF (SSTOR.LT.1.E-20) SSTOR=0.
      S(M)=SSTOR
      FLINS(M)=FLIN+SSTOR-Q2
C 
C **** SEDIMENT CALCULATION.
C 
  150 IF (M.LE.N) GO TO 160 
C 
C **** COMPUTE TRANSPORT/DEPOSITION FOR CHANNEL FLOW. 
C 
      CALL SED (CWID(M),DX,0.,SL(M),Q(M),1.,1.,SI(M),SEL(M),SE,S(M),M,N,
     1SST(M),CE1,CE2,CE3,CE4,CE5) 
C 
C **** REMEMBER ALL CHANNEL FLOW MOVES WITH ITS 'COLUMN' DESIGNATOR.
C 
      K=NC(M) 
      QI(K)=QI(K)+D 
      SI(K)=SI(K)+SE
      GO TO 170 
C 
C **** COMPUTE TRANSPORT/DEPOSITION FOR OVERLAND FLOW.
C 
  160 CALL SED (DX,DX,R(I,K),SL(M),Q(M),CDR(K),SKDR(KK),SI(M),SEL(M),SE,
     1S(M),M,N,SST(M),CE1,CE2,CE3,CE4,CE5)
C 
C **** PROPORTION OUTFLOW AND SEDIMENT TO DOWNSLOPE ADJACENT ROW AND
C **** COLUMN ELEMENTS. 
C 
      DRA=D*RFL(M)
      SRA=SE*RFL(M) 
      I=NR(M) 
      K=NC(M) 
      QI(I)=QI(I)+DRA 
      QI(K)=QI(K)+D-DRA 
      SI(I)=SI(I)+SRA 
      SI(K)=SI(K)+SE-SRA
  170 CONTINUE
      IF (CHN.LT.1..OR.SDR.EQ.0.) GO TO 180 
C 
C **** CALCULATE TILE DRAINAGE AND GROUNDWATER CONTRIBUTION.
C 
      XPR=KPR 
      CALL DRAIN (DR,DC,DIN,N,N1,N2,STD,TIAL,RFL,NR,NC) 
      SDR=SDR-STD*XPR 
      CHDR=SDR*GRF/XPR/CHN
      SDR=SDR*(1.-GRF)
C 
C **** OUTPUT PRINT SECTION.
C 
  180 Q1(L)=QI(NN)/CONV 
      SSI(L)=SI(NN)*DT
      IF (QI(NN).GT.0.) GO TO 190 
      SSCON(L)=0. 
      GO TO 200 
  190 SSCON(L)=(SI(NN)-SPT)/(SI(NN)-SPT+QI(NN)*CE6)*1000000.
  200 IF (Q1(L).GT.QMAX) QMAX=Q1(L) 
      IF (SSCON(L).GT.CMAX) CMAX=SSCON(L) 
      VOL=VOL+Q1(L) 
      RW(L)=0.
      DO 210 I=1,NRG
      J=JTR(I)
  210 RW(L)=RW(L)+RC(I,J)*FRA(I)
      IF (RW(L).GT.RMAX) RMAX=RW(L) 
C 
C **** PRINT ONE HYDROGRAPH LINE..... 
C 
      WRITE (6,310) T(L),RW(L),Q1(L),SSI(L),SSCON(L)
  220 CONTINUE
C 
C **** END OF HYDROGRAPH.  PRINT TOTAL RUNOFF AND RAINFALL. 
C 
      L=NDT+1
  230 VOL=(VOL-.5*Q1(L-1))*DT*FLOAT(KPR)/3600. 
      X=SSI(L-1)/AREA
      WRITE (6,320) PREC,PP(IT+1),VOL,PP(IT+1),X,PP(IT+5),PP(IT+7)
C 
C **** DISPLAY STRUCTURAL PRACTICE EFFECTIVENESS. 
C 
      K=NMAX+2
      M=K+ISTRUC-1
      DO 240 I=K,M
      IF (SI(I).EQ.0.) GO TO 240
      SI(I)=SI(I)*DT
      J=I-K+1 
      WRITE (6,370) J,SI(I),PP(IT+5)
  240 CONTINUE
C 
C **** INDIVIDUAL ELEMENT SEDIMENT LOSS (-) OR GAIN (+).
C 
      X=10000./DX/DX
      IF (IT.EQ.0) X=X*4.356
      WRITE (6,340) (PP(IT+5),PP(IT+7),I=1,4) 
C 
C **** OUTPUT INDIVIDUAL ELEMENT NET SEDIMENTATION AMOUNTS AND GROSS
C **** STATISTICAL VALUES.
C 
      SPAERO=0. 
      SPADEP=0. 
      SPASUM=0. 
      SPASS=0.
C 
C **** COMPUTE STATISTICS ON OVERLAND FLOW ELEMENTAL SEDIMENT YIELDS. 
C 
      DO 250 I=1,N
      SEL(I)=SEL(I)*DT*X
      IF (SEL(I).GT.SPADEP) SPADEP=SEL(I) 
      IF (SEL(I).LT.SPAERO) SPAERO=SEL(I) 
      SPASUM=SPASUM+SEL(I)
  250 SPASS=SPASS+SEL(I)*SEL(I) 
      WRITE (6,360) (I,SEL(I),I=1,N)
      NM1=N-1 
      SPASD=SQRT((SPASS-SPASUM*SPASUM/FLOAT(N))/FLOAT(NM1)) 
      SPAERO=-SPAERO
      WRITE (6,350) SPAERO,PP(IT+5),PP(IT+7),SPADEP,PP(IT+5),PP(IT+7),SP
     1ASD,PP(IT+5),PP(IT+7),PP(IT+5)
C 
C **** NOW, OUTPUT NET DEPOSITION FOR CHANNEL AREAS.
C 
      J=N+1 
      DO 260 I=J,N2 
  260 SEL(I)=SEL(I)*DT
      WRITE (6,360) (NR(I),SEL(I),I=J,N2) 
C 
C **** PLOTTING SECTION.  THIS SECTION OF CODE WILL CREATE THE INPUT
C **** FILE FOR SUBROUTINE HYPLT ON DEVICE 8.  SOME OF THE COMMANDS 
C **** ARE MACHINE DEPENDENT AND ALL ARE PRESENTLY DISABLED.  TO USE, 
C **** SIMPLY REMOVE THE C IN COLUMN 1, ADD SUBROUTINE HYPLT TO THE 
C **** PROGRAM, AND APPEND THE CALCOMP LIBRARY TO THE INPUT FILE. 
C **** THERE ARE TWO FORMAT STATEMENTS (380 AND 390) THAT MUST ALSO 
C **** HAVE THE COMMENT DESIGNATION REMOVED!
C 
C     L=L-1
C     REWIND 8
C     WRITE (8,380) L1,RMAX,QMAX,CMAX,IT,PP 
C 
C **** COPY HYDROGRAPH TO STORAGE TAPE. 
C 
C     DO 270 I=1,L
C 270 WRITE (8,390) T(I),RW(I),Q1(I),SSCON(I) 
C     CALL HYPLT (L1,T,RW,Q1,SSCON,RMAX,QMAX,CMAX,IT,PP)
      STOP
C 
C **** FORMATS. 
C 
  280 FORMAT (19A4) 
  290 FORMAT (1H1,52H DISTRIBUTED HYDROLOGIC AND WATER QUALITY SIMULATIO
     1N/16X,23HBY ANSWERS VER 4.880215/19A4)
  300 FORMAT (/,15X,'OUTLET HYDROGRAPHS--VER 4.880215',/,31X,'YIELD',9X,
     1'CONCENTRATIONS -',A4,/,2X,' TIME',2X,'RAINFALL',2X,'RUNOFF',4X,'S
     2EDIMENT',3X,'SEDIMENT  PHOSPHORUS  NITROGEN',/,1X,'  MIN.',2X,2A4,
     31X,2A4,5X,A4,18X,'(N/A)',6X,'(N/A)')
  310 FORMAT (1X,F7.1,F8.2,F10.4,2F11.0)
  320 FORMAT (4X,28HRUNOFF VOLUME PREDICTED FROM,F7.2,A4,14H OF RAINFALL
     1 =,F7.3,A4/15X,19HAVERAGE SOIL LOSS =,F7.0,1X,2A4)
  330 FORMAT (///5X,48HMEAN FLOW DEPTH GREATER THAN EXPECTED AT ELEMENT,
     1I5/56H CONDITION OCCURRED BECAUSE THIS ELEMENT'S SLOPE IS MUCH,31H
     2 LESS THAN WATERSHED AVERAGE OR,/,28H CIRCULAR FLOW PATTERNS ARE ,
     358H PRESENT IN THIS VICINITY.  RECOMMENDED CORRECTIVE ACTION:,/60H
     4 INCREASE EXPECTED PEAK RUNOFF VALUE (SF) IN SUBROUTINE DATA,10H O
     5R MODIFY,/,24HELEMENT FLOW DIRECTIONS.) 
  340 FORMAT (//19X,36HINDIVIDUAL ELEMENT NET SEDIMENTATION/1X,4(2X,16HE
     1LEMENT SEDIMENT)/1X,4(4X,3HNO.,3X,2A4)) 
  350 FORMAT (1X,'MAX EROSION RATE =',F7.0,2A4,2X,'MAX DEPOSITION RATE =
     1',F7.0,2A4,/,23X,'STD. DEV. =',F7.0,2A4,//,24X,'CHANNEL DEPOSITION
     2 --',A4,/,4(4X,'NO.     AMOUNT'))
  360 FORMAT (4(I7,F11.0))
  370 FORMAT (21H  STRUCTURAL PRACTICE,I3,32H REDUCED TOTAL SEDIMENT YIE
     1LD BY,F9.0,A4)
C 380 FORMAT (I4,2F7.2,F7.0,I3/12A4)
C 390 FORMAT (3F10.2,F10.0) 
C 
      END 
      SUBROUTINE DATA (NDT,KPR,N,CONV,CU,SF,IT,NN,ICR,NFI,CU2,ISTRUC,SB,
     1TMIN,TMAX,NRG,DX,GRF,NEXP,DC,PP,FILTS,CWID,AREA,DT,NMAX)
C 
C ****** SUBROUTINE TO INPUT WATERSHED DATA.
C 
C **** MAXIMUM NUMBER OF SOIL TYPES IS 20.
C 
      COMMON /CSOIL/ A(20),P(20),FC(20),GWC(20),SKDR(20)
      DIMENSION TP(20), DF(20), ASM(20), FCAP(20) 
C 
C **** MAXIMUM NUMBER OF SURFACE AND CROP TYPES IS 20.
C 
      COMMON /CROUGH/ ROUGH(20),HU(20),DIR(21),PIT(5,20),PER(20),CDR(20)
C 
C **** MAXIMUM NUMBER OF OVERLAND ELEMENTS PLUS CHANNEL ELEMENTS
C **** IS 1700. 
C 
C ****** IT IS EXPECTED THAT ARRAY "IEL" (IN SUBROUTINE DATA) WILL
C ****** BE OF SUCH A SIZE THAT IT WILL OVERLAY (BE EQUIVALENCED TO)
C ****** THE SPACE IN ARRAYS SI AND QI TOGETHER.  THEREFORE IT IS 
C ****** NECESSARY THAT THESE TWO ARRAYS BE KEPT ADJACENT IN THEIR
C ****** COMMON BLOCK.  NOTE: THE ACTUAL NUMBER OF ELEMENTS THAT
C ****** CAN BE DIMENSIONED IN IEL WILL DEPEND ON THE WORD LENGTH 
C ****** OF THE MACHINE BEING USED, E.G. ON A MACHINE WHICH USES
C ****** A SINGLE WORD INTEGER AND A DOUBLE WORD REAL, THE NUMBER 
C ****** OF ELEMENTS IN IEL CAN BE FOUR TIMES THE NUMBER OF ELEMENTS
C ****** IN ARRAY SI. 
C 
      COMMON /CFLOW/ Q(1700),RFL(1700),FLINS(1700),SS(1700),PIV(1700),B(
     11700),NR(1700),NC(1700),DR(1700),S(1700),SL(1700),SEL(1700),SI(171
     20),QI(1710),DIN(1700),SST(1700) 
C 
C ****** ARRAYS SI AND QI MUST BE DIMENSIONED TO A SIZE = NMAX+ISTRUC+2 
C ****** TO HOLD, IN ORDER, SEDIMENT AND FLOW FROM THE WATERSHED OUTLET 
C ****** ELEMENT, STRUCTURAL PRACTICES AND ANY "LEAKY" ELEMENTS.
C 
      EQUIVALENCE (TP(1),SST(1)), (DF(1),SST(21)), (ASM(1),SST(41)) 
      EQUIVALENCE (FCAP(1),SST(61)), (ITEMP(1),SST(81)) 
      EQUIVALENCE (IRR(1),SST(101)) 
      EQUIVALENCE (RN(1),SEL(1))
      EQUIVALENCE (WID(1),SEL(41)), (CN(1),SEL(51)) 
      EQUIVALENCE (CBAR(1),SEL(80)), (SPER(1),SEL(101)), (CROP(1,1),SEL 
     1(121)), (NSTRUC(1),SEL(161))
      DIMENSION CROP(20,2), RN(20), DIRM(20), CBAR(20), SPER(20), NSTRUC
     1(4), STRNAM(3,4)
      EQUIVALENCE (DIRM(1),DIR(1))
C 
C **** MAXIMUM NUMBER OF RAINGAGES IS 4 WITH 35 VALUES PER GAGE.
C 
      COMMON /CRGAGE/ RC(4,35),TC(4,35),R(4,20),FRA(4),JTR(4),RATE(4),SR
     1(4),NF(4) 
      DIMENSION IRR(4), IG(4), DATE(2)
      EQUIVALENCE (IEL(1,1,1),SI(1))
      DIMENSION IEL(3,103,11), ITEMP(11)
      DIMENSION IELC(3,103,2), ITEMPC(2)
      DIMENSION FILTS(1700), CWID(1700) 
      EQUIVALENCE (TIAL(1),RANE(1)), (SUR(1),SOIL(1)) 
      EQUIVALENCE (DIN(1),CHAN(1))
      COMMON /CSURF/ SUR(1700),RANE(1700) 
      INTEGER SUR,SOIL(1700),TIAL(1700),RANE,CHAN(1700) 
C 
C **** MAXIMUM NUMBER OF CHANNEL TYPES IS 10. 
C 
      DIMENSION WID(10), CN(10), PP(14), TITLE(11)
      LOGICAL STRUC 
      CHARACTER*4 C1, C3, C4, C5, C6, PRI, UN, UNITS, PR, TEST
      CHARACTER*4 PP, TITLE, STRNAM, DATE 
      CHARACTER*2 IG, IELC, ITEMPC, ISTL
      CHARACTER JBEG
      DATA C1,C3,C4,C5,C6,PRI,UN/' RAI','  SO','  SU','  CH','  EL','PRI
     1N','METR'/
      DATA ISTL/'TI'/ 
C 
C **** NOW, STORE THE NAMES OF THE STRUCTURAL PRACTICES.
C 
      DATA STRNAM/'PTO ','TERR','ACES','POND','S, L','AKES','G. W','ATER
     1','WAYS','FIEL','D BO','RDER'/
      STRUC=.FALSE. 
C 
C ****** NUMBER OF STRUCTURAL PRACTICES PERMITTED.  ARRAYS STRNAM AND 
C ****** NSTRUC MUST BE REDIMENSIONED IF ISTRUC IS MODIFIED.  ALSO, THE 
C ****** ADITIONAL STRUCTURE NAMES MUST BE ADDED TO THE DATA STATEMENT. 
C 
      ISTRUC=4
      IT=0
      OUTSID=0. 
      TMAX=0. 
      TMIN=1.E+10 
C 
C **** INPUT UNITS USED IN SIMULATION AND OUTPUT PRINT CONTROL. 
C 
      READ (5,800) UNITS,PR 
C 
C **** INPUT NUMBER OF RAINGAGES AND DATE OF EVENT. 
C 
      READ (5,810) TEST,NRG,DATE
      IF (NRG.GT.4) GO TO 540 
      IF (TEST.NE.C1) GO TO 580 
C 
C **** INPUT SEPARATE RAINFALL HYETOGRAPHS FOR EACH RAINGAGE. 
C 
      DTMIN=900.
      TINT=DTMIN
      DO 20 I=1,NRG 
      FRA(I)=0. 
      READ (5,830) IG(I)
      K=2 
      KM1=1 
   10 READ (5,740) JBEG,TC(I,K),RC(I,K) 
      IF (K.GT.2) TINT=TC(I,K)-TC(I,KM1)
      IF (TINT.LT.DTMIN) DTMIN=TINT 
      K=K+1 
      KM1=K-1 
      IF (JBEG.EQ.' '.OR.JBEG.EQ.'0') GO TO 10
      IF (JBEG.NE.'1') GO TO 570
      IF (K.GT.35) GO TO 540
      IF (TC(I,2).LT.TMIN) TMIN=TC(I,2) 
      IF (TC(I,KM1).GT.TMAX) TMAX=TC(I,KM1) 
   20 IRR(I)=K
C 
C **** INSERT SAME START AND FINISH TIME FOR EACH RAINGAGE RECORD.
C 
      DO 30 I=1,NRG 
      K=IRR(I)
      KM1=K-1 
      TC(I,1)=TMIN
      RC(I,1)=0.
      IF (TC(I,KM1).EQ.TMAX) IRR(I)=IRR(I)-1
      TC(I,K)=TMAX
   30 RC(I,K)=0.
C 
C ****** DEFINE DEFAULT SIMULATION REQUIREMENTS.  MAXIMUM NUMBER OF 
C ****** HYDROGRAPH PRINT POINTS IS 101 (THIS IS THE NUMBER THAT WILL BE
C ****** OUTPUT).  NORMAL TIME STEP IS 60 SECONDS AND NORMAL TIME STEP
C ****** FOR INFILTRATION IS 180 SECONDS.  MAXIMUM EXPECTED RUNOFF RATE 
C ****** IS 2 INCHES (50.8 MM) PER HOUR.  IF A SEGMENTED CURVE ERROR
C ****** OCCURS DURING SIMULATION, INCREASE SF BY 50 PERCENT UNTIL THAT 
C ****** PROBLEM CEASES (IT MAY NOT BE THE ONLY PROBLEM, THOUGH). 
C ****** FOR WATERSHEDS WITH LARGE ELEMENTS (GREATER THAN 5 ACRES), 
C ****** MILD TOPOGRAPHY (LESS THAN 1 PERCENT AVERAGE SLOPES), OR 
C ****** MANY ELEMENTS (MORE THAN 1000), THE SIMULATION TIME STEP, DT,
C ****** SHOULD BE INCREASED TO NO MORE THAN 300 SECONDS (5 MINUTES). 
C ****** SIMILARLY, FOR SMALL ELEMENTS (LESS THAN 1 ACRE), SEVERE 
C ****** TOPOGRAPHY, OR WATERSHEDS WITH ONLY A FEW ELEMENTS, THE
C ****** SIMULATION TIME STEP SHOULD BE DECREASED TO 15 - 30 SECONDS. 
C 
      NDT=101 
      DT=60.
      NFI=180 
      SF=2. 
      IF (UNITS.EQ.UN) SF=50.8
      IF (UNITS.EQ.UN) IT=7 
      IF (PRI.NE.PR) GO TO 50 
      WRITE (6,660) DATE
      DO 40 I=1,NRG 
      L=IRR(I)
   40 WRITE (6,670) IG(I),PP(IT+1),PP(IT+2),(TC(I,K),RC(I,K),K=2,L) 
   50 IF (DT.GT.DTMIN*60.) WRITE (6,880)
      KPR=(TMAX-TMIN)/DT/FLOAT(NDT)*60.+1.
      IF (PRI.EQ.PR) WRITE (6,630) DT 
      NFI=NFI/IFIX(DT)
C 
C **** INPUT INFILTRATION AND SOIL DATA.
C 
      READ (5,810) TEST 
      IF (TEST.NE.C3) GO TO 580 
      READ (5,780) ISR
      IF (PRI.EQ.PR) WRITE (6,750) PP(IT+1),PP(IT+2),PP(IT+1),PP(IT+2),P
     1P(IT+1) 
      IF (ISR.GT.20) GO TO 530
      ASMBAR=0. 
      FPBAR=0.
      DO 60 I=1,ISR 
      READ (5,790) TP(I),FCAP(I),FC(I),A(I),P(I),DF(I),ASM(I),SKDR(I) 
      SPER(I)=0.
      IF (PRI.EQ.PR) WRITE (6,640) I,TP(I),FCAP(I),FC(I),A(I),P(I),DF(I)
     1,ASM(I),SKDR(I) 
   60 CONTINUE
C 
C **** INPUT DRAINAGE AND GROUNDWATER CONSTANTS.
C 
      READ (5,980) DC,GRF 
      NEXP=3
      IF (PRI.EQ.PR) WRITE (6,990) DC,PP(IT+1),GRF
C 
C **** INPUT CROP AND SURFACE ROUGHNESS DATA. 
C 
      READ (5,810) TEST 
      IF (TEST.NE.C4) GO TO 580 
      READ (5,940) ICR
      IF (PRI.EQ.PR) WRITE (6,950) PP(IT+1),PP(IT+1),PP(IT+1) 
      IF (ICR.GT.20) GO TO 550
      DO 70 I=1,ICR 
      CBAR(I)=0.
      READ (5,620) CROP(I,1),CROP(I,2),PIT(1,I),PER(I),ROUGH(I),HU(I),RN
     1(I),CDR(I)
      IF (ROUGH(I).GT.1.0.OR.ROUGH(I).LE.0.) GO TO 590
      IF (PRI.EQ.PR) WRITE (6,960) I,CROP(I,1),CROP(I,2),PIT(1,I),PER(I)
     1,ROUGH(I),HU(I),RN(I),CDR(I)
   70 CONTINUE
C 
C **** INPUT CHANNEL DATA.
C 
      READ (5,810) TEST 
      IF (TEST.EQ.C6) GO TO 80
      IF (TEST.NE.C5) GO TO 580 
      READ (5,920) M
      IF (M.GT.10) GO TO 510
      READ (5,760) (WID(I),CN(I),I=1,M) 
      IF (PRI.EQ.PR) WRITE (6,650) PP(IT+4),(I,WID(I),CN(I),I=1,M)
C 
C **** INPUT OUTFLOW ELEMENT POSITION.
C 
      READ (5,820) TEST,TITLE 
      IF (TEST.NE.C6) GO TO 580 
   80 READ (5,610) DX,NIOUT,NJOUT 
C 
C **** EVALUATE CONSTANTS FOR USE WITH METRIC OR ENGLISH UNITS. 
C **** METRIC UNITS.
C 
      DX2=DX*DX 
      AREA=DX2/1.E+4
      CU1=DX2/1.E+3 
      CU2=DT/DX2*500. 
      CU=DX2/3.6E+6 
      CONST=DX/(2./DT*DX2)**1.6667
      IF (UNITS.EQ.UN) GO TO 90 
C 
C **** CONVERT TO ENGLISH UNITS.
C 
      CU1=CU1/.012
      CU=CU/.012
      CU2=CU2*.012
      CONST=1.486*CONST 
      AREA=AREA/4.3560
C 
C **** INPUT INDIVIDUAL ELEMENT TOPOGRAPHICAL DATA. 
C 
   90 NPAR=13 
      NPAR2=11
C 
C **** CHANGE DIMENSION STATEMENT BELOW IF JMAX IS CHANGED. 
C 
      JMAX=103
      NMAX=1700 
      N=0 
      II=0
      SCMIN=9.
      SCMAX=0.
      SCBAR=0.
      SMIN=9. 
      SMAX=0. 
      SBAR=0. 
      TBAR=0. 
      DO 100 J=1,JMAX 
  100 IEL(3,J,3)=0
C 
C **** INPUT FIRST ROW OF ELEMENTAL DATA. 
C 
      READ (5,680) (ITEMP(K),K=1,7),(ITEMPC(L),L=1,2),(ITEMP(K),K=8,11) 
      CALL RELEM (IEL,ITEMP,N,MOUT,NIOUT,NJOUT,ISR,ICR,NMAX,JMAX,NPAR,
     1IELC,ITEMPC,NPAR2)
C 
C **** PUT WATERSHED ELEMENTAL DATA INTO SINGLE DIMENSIONED ARRAYS. 
C 
  110 CALL RELEM (IEL,ITEMP,N,MOUT,NIOUT,NJOUT,ISR,ICR,NMAX,JMAX,NPAR,
     1IELC,ITEMPC,NPAR2)
      JS=IEL(2,1,2) 
      DO 270 J=1,JS 
      JM1=J-1 
      I=IEL(2,J,3)
      IF (I.EQ.0) GO TO 270 
      SL(I)=FLOAT(IEL(2,J,4))/1000. 
      IF (SL(I).LT.SMIN) SMIN=SL(I) 
      IF (SL(I).GT.SMAX) SMAX=SL(I) 
      SBAR=SBAR+SL(I) 
      CHAN(I)=IEL(2,J,6)/100
      IF (CHAN(I).GT.10) WRITE (6,1020) CHAN(I),I 
      SS(I)=FLOAT(IEL(2,J,8))/1000. 
C 
C **** IF CHANNEL SLOPE NOT SPECIFIED, ASSUME IT'S HALF OVERLAND SLOPE. 
C 
      IF (SS(I).LE.0.) SS(I)=.5*SL(I) 
      TIAL(I)=0 
      IF (IELC(2,J,2).NE.ISTL) GO TO 120
      TIAL(I)=256 
      TBAR=TBAR+1.
  120 M=FLOAT(IEL(2,J,5))/90.+1.
      MM1=M-1 
C 
C **** EVALUATE OUTFLOW PROPORTIONS TO ADJACENT COLUMN AND ROW ELEMENTS.
C 
      ANG=(FLOAT(IEL(2,J,5))-90.*FLOAT(MM1))*.01745329
      X=SIN(ANG)+COS(ANG) 
      IX=CHAN(I)
      IF (IX.EQ.0) GO TO 130
C 
C **** EVALUATE CONVEYANCE FOR CHANNEL ELEMENTS.
C 
      II=II+1 
      CWID(II)=WID(IX)
      SS(II)=SS(I)
      IF (SS(I).LT.SCMIN) SCMIN=SS(I) 
      IF (SS(I).GT.SCMAX) SCMAX=SS(I) 
      SCBAR=SCBAR+SS(I) 
      PIV(II)=CONST/CN(IX)/X*(DX/WID(IX)/X)**0.6667*SQRT(SS(I)) 
C 
C **** NOW DETERMINE THE ELEMENT(S) THAT RECEIVE OUTFLOW FROM THE 
C **** CURRENT ELEMENT.  NOTE:  IS IS LEGAL FOR AN ELEMENT WITH A 
C **** SHADOW CHANNEL ELEMENT TO SHOW FLOW, AT THIS TEST POINT, THAT
C **** WOULD OTHERWISE BE OUTSIDE THE CATCHMENT.
C 
  130 GO TO (140,150,150,140,140), M
  140 IF ((J.GE.JMAX.OR.IEL(2,J+1,3).EQ.0).AND.CHAN(I).EQ.0.AND.IEL(2,J,
     15).NE.270.AND.I.NE.MOUT) WRITE (6,770) IEL(2,J,1),J 
      NR(I)=IEL(2,J+1,3)
      GO TO (160,160,170,170,160), M
  150 IF ((J.LE.1.OR.IEL(2,JM1,3).EQ.0).AND.IEL(2,J,5).NE.90.AND.I.NE.MO
     1UT.AND.CHAN(I).EQ.0) WRITE (6,770) IEL(2,J,1),J 
      NR(I)=IEL(2,JM1,3)
      GO TO (160,160,170,170,160), M
  160 IF (IEL(1,J,3).EQ.0.AND.IEL(2,J,5).NE.0.AND.CHAN(I).EQ.0.AND.IEL(2
     1,J,5).NE.360.AND.I.NE.MOUT) WRITE (6,770) IEL(2,J,1),J
      NC(I)=IEL(1,J,3)
      GO TO 180 
  170 IF (IEL(3,J,3).EQ.0.AND.IEL(2,J,5).NE.180.AND.I.NE.MOUT.AND.CHAN(I
     1).EQ.0) WRITE (6,770) IEL(2,J,1),J
      NC(I)=IEL(3,J,3)
  180 IF (ANG.GT..78539816) GO TO 190 
      RFL(I)=.5*SIN(ANG)/COS(ANG) 
      GO TO 200 
  190 RFL(I)=1.-.5*SIN(1.5707963-ANG)/COS(1.5707963-ANG)
  200 GO TO (210,220,210,220,210), M
  210 RFL(I)=1.-RFL(I)
C 
C **** ELIMINATE FALSE RECEIVING ELEMENTS WHICH MAY CAUSE OUT-OF-RANGE
C **** SUBSCRIPTS FOR SOME BOUNDARY ELEMENTS. 
C 
  220 IF (RFL(I).LT.0.01) NR(I)=NC(I) 
      IF (RFL(I).GT.0.99) NC(I)=NR(I) 
C 
C **** "LEAKY" ELEMENTS (THOSE WITH PARTIAL FLOW OUTSIDE THE WATERSHED) 
C **** MUST DIVERT THAT PARTIAL FLOW INTO A SPECIAL PSUEDO ELEMENT. 
C 
      IF (NC(I).GT.0.OR.I.EQ.MOUT) GO TO 230
C 
C **** THIS ELEMENT LEAKS, DIVERT IT INTO SPECIAL "BOTTOMLESS PIT". 
C 
      NC(I)=NMAX+ISTRUC+2 
C 
C **** ADD TO TOTAL NON-CONTRIBUTING AREA.
C 
      OUTSID=OUTSID+1.-RFL(I) 
  230 IF (NR(I).GT.0.OR.I.EQ.MOUT) GO TO 240
      NR(I)=NMAX+ISTRUC+2 
      OUTSID=OUTSID+RFL(I)
C 
C **** GET CROP/MGMT NUMBER.
C 
  240 I1=IEL(2,J,7) 
      CBAR(I1)=CBAR(I1)+1.
C 
C **** PUT CROP/MANAGEMENT NUMBER IN LOW BYTE AND SOIL TYPE NUMBER IN 
C **** NEXT BYTE OF (SOIL:SUR). 
C 
      K=MOD(IEL(2,J,6),100) 
      SPER(K)=SPER(K)+1.
      SOIL(I)=(K*256)+I1
      ASMBAR=ASMBAR+ASM(K)
      FPBAR=FPBAR+FCAP(K) 
      B(I)=CONST*SQRT(SL(I))*X/RN(I1) 
C 
C **** MAKE SPECIAL ADJUSTMENTS TO ACCOUNT FOR STRUCTURAL PRACTICES,
C **** BUT FIRST SEE IF ANY ARE PRESENT IN THIS ELEMENT.
C 
      IF (IEL(2,J,9).NE.0) CALL STRUCT (I,J,NC(I),NR(I),RFL(I),IEL,JMAX,
     1NPAR,NMAX,STRUC,NSTRUC,ISTRUC,X,DX,WID,SS(II+1),SS(I),PIV(II+1),CN
     2,CWID(II+1),CHAN(I),CONST,SL(I),II,SCMIN,SCMAX,SCBAR,ANG,IELC,NPAR
     32)
C 
C **** RENUMBER RAINGAGES TO 1,2,..,NRG IN ORDER OF HYETOGRAPH INPUTS.
C 
      DO 250 K=1,NRG
      IF (IELC(2,J,1).EQ.IG(K)) GO TO 260 
  250 CONTINUE
      WRITE (6,600) IELC(2,J,1),IEL(2,J,1),J,IG(1)
      K=1 
C 
C **** PUT RAINGAGE NUMBER IN LOW BYTE AND TILE NUMBER IN NEXT BYTE 
C **** OF (TIAL:RANE).
C 
  260 RANE(I)=TIAL(I)+K 
  270 CONTINUE
      JS=IEL(3,1,2) 
      IF (ITEMP(3).NE.999.AND.IEL(3,JS,1).NE.ITEMP(1)) GO TO 110
      ITEMP(3)=999
      IF (JS.NE.JMAX) GO TO 110 
      IF (N+II.GT.NMAX) GO TO 520 
      X=N 
      ASMBAR=ASMBAR/X 
      FPBAR=FPBAR/X 
      SB=AREA 
      AREA=AREA*(X-OUTSID)
      CONV=CU*(X-OUTSID)
      SBAR=SBAR/X 
      IF (II.GT.0) SCBAR=SCBAR/FLOAT(II)
      NN=N+1
C 
C **** OUTPUT STATISTICAL SUMMARY OF WATERSHED CHARACTERISTICS. 
C 
      TBAR=TBAR/X 
      WRITE (6,690) TITLE,SB,PP(IT+3),N,II,AREA,PP(IT+3),SMIN,SBAR,SMAX,
     1SCMIN,SCBAR,SCMAX,TBAR,DC,PP(IT+1),ASMBAR,FPBAR,GRF,MOUT,NIOUT,NJO
     2UT
      WRITE (6,700) PP(IT+1),PP(IT+2),PP(IT+1),PP(IT+2),PP(IT+1)
      DC=DC*CU/24.
      SB=CONST*SQRT(SBAR)/RN(1) 
      J=0 
      DO 330 I=1,ICR
      IF (CBAR(I).LE.0..AND.I.LT.ICR) GO TO 330 
      CBAR(I)=CBAR(I)/X 
      IF (J.GE.ISR) GO TO 320 
  280 J=J+1 
      DO 300 JJ=J,ISR 
      IF (SPER(JJ).LE.0.) GO TO 300 
      FPBAR=FC(JJ)+A(JJ)*(1.-ASM(JJ))**P(JJ)
      SPER(JJ)=SPER(JJ)/X 
      IF (CBAR(I).LE.0.) GO TO 290
      WRITE (6,710) CROP(I,1),CROP(I,2),CBAR(I),PER(I),RN(I),CDR(I),JJ,S
     1PER(JJ),FC(JJ),FPBAR,DF(JJ),SKDR(JJ)
      CBAR(I)=0.
      GO TO 310 
  290 WRITE (6,720) JJ,SPER(JJ),FC(JJ),FPBAR,DF(JJ),SKDR(JJ)
      GO TO 310 
  300 CONTINUE
      J=ISR 
      GO TO 320 
  310 J=JJ
      IF (I.LT.ICR) GO TO 330 
      IF (J.LT.ISR) GO TO 280 
  320 IF (CBAR(I).GT.0.) WRITE (6,730) CROP(I,1),CROP(I,2),CBAR(I),PER(I
     1),RN(I),CDR(I)
  330 CONTINUE
      NR(MOUT)=NN 
      NC(MOUT)=NN 
      IF (II.NE.0) GO TO 340
      N2=N
      GO TO 410 
C 
C **** DETERMINE SHADOW ELEMENT CONTINUITY. 
C **** FIND CHANNEL SEGMENTS. 
C 
  340 DO 350 J=1,N
      IF (CHAN(J).EQ.0) GO TO 350 
C 
C **** USE THE ROW FLOW POINTER TO REMEMBER ORIGINAL ELEMENT NUMBER 
C **** OF THIS CHANNEL ELEMENT, SINCE THE FLOW COMPONENT IN THE ROW 
C **** DIRECTION IS 0.
C 
      NR(NN)=J
      NN=NN+1 
  350 CONTINUE
C 
C **** MOVE CHANNEL PARAMETERS TO END OF ARRAYS.
C 
      N2=NN-1 
      N1=N+1
      DO 390 I=N1,N2
      I1=I-N
      B(I)=PIV(I1)
      CWID(I)=CWID(I1)
      SL(I)=SS(I1)
      J=NR(I) 
      I1=NC(J)
      I2=NR(J)
C 
C **** IF CERTAIN STRUCTURES ARE PRESENT IN AN ELEMENT WITH A SHADOW
C **** ELEMENT, IT IS LIKELY THAT THE RECEIVING CHANNEL ELEMENT WILL
C **** NOT BE GETTING THE MAJOR OUTFLOW.
C 
      IF (I1.GT.NMAX) GO TO 360 
      IF (I2.GT.NMAX) GO TO 380 
C 
C **** THIS ELEMENT DOES NOT CONTAIN A STRUCTURE; THEREFORE, THE
C **** RECEIVING CHANNEL ELEMENT SHOULD BE IN THE DIRECTION OF THE
C **** PREDOMINANT FLOW COMPONENT.
C 
      IF (RFL(J).LT.0.207107) GO TO 380 
      IF (RFL(J).GT.0.792893) GO TO 360 
C 
C **** FLOW DIRECTION IS PREDOMINANTLY DIAGONAL.
C ****** IF ROW FLOW DESTINATION NUMBER IS LESS THAN CURRENT ELEMENT
C ****** NUMBER, THE DIAGONAL POINTS TO THE LEFT AND THE DIAGONAL 
C ****** DESTINATION ELEMENT CAN BE COMPUTED BY SUBTACTING ONE FROM 
C ****** THE CONVENTIONAL OVERLAND FLOW COLUMN DESTINATION NUMBER.
C 
      IF (I2.LT.J) GO TO 370
      I1=I1+1 
      GO TO 380 
  360 I1=I2 
      GO TO 380 
  370 I1=I1-1 
C 
C **** MAKE CERTAIN THE RECEIVING ELEMENT IS A CHANNEL ELEMENT. 
C 
  380 IF (CHAN(I1).LT.1.AND.J.NE.MOUT) GO TO 560
C 
C **** TEMPORARILY ASSIGN THE ORIGINAL OVERLAND FLOW ELEMENT NUMBER 
C **** AS THE DESTINATION FOR THE SHADOW OUTFLOW.  THIS IS NECESSARY
C **** UNTIL NEW NUMBERS ARE ASSIGNED TO ALL SHADOW ELEMENTS. 
C 
      NC(I)=I1
C 
C **** MAKE ALL OVERLAND FLOW FROM THIS ELEMENT GO INTO ITS SHADOW
C **** ELEMENT, UNLESS IT CONTAINS A STRUCTURAL PRACTICE. 
C 
      IF (NR(J).LE.NMAX) NR(J)=I
      IF (NC(J).LE.NMAX) NC(J)=I
  390 CONTINUE
C 
C **** FIND REAL CHANNEL SEGMENT NUMBER INTO WHICH EACH CHANNEL 
C **** SEGMENT FLOWS. 
C 
      DO 400 J=N1,N2
      I=NC(J) 
      NC(J)=NR(I) 
C 
C **** IF THIS ELEMENT CONTAINS A STRUCTURAL MEASURE, ITS CORRECT 
C **** CHANNEL ELEMENT NUMBER MAY BE PRESENT ONLY IN ARRAY NC.
C 
      IF (NC(J).GT.NMAX) NC(J)=NC(I)
C 
C **** FORCE ALL CHANNEL FLOW TO USE ONLY COLUMN FLOW DIRECTIONS. 
C 
  400 RFL(J)=0. 
      J=NR(MOUT)
      NC(J)=NN
C 
C **** OUTPUT DATA CONCERNING ANY STRUCTURAL PRACTICES. 
C 
  410 IF (.NOT.STRUC) GO TO 430 
      WRITE (6,1000)
      DO 420 I=1,ISTRUC 
      IF (NSTRUC(I).NE.0) WRITE (6,1010) I,(STRNAM(J,I),J=1,3),NSTRUC(I)
  420 CONTINUE
C 
C **** EVALUATE INITIAL CONDITIONS. 
C 
  430 DO 440 I=1,N2 
      S(I)=0. 
  440 FLINS(I)=0. 
C 
C **** CONVERT SOIL CONSTANTS.
C 
      DO 450 I=1,ISR
      FC(I)=CU*FC(I)
      TP(I)=TP(I)*CU1*DF(I) 
      A(I)=CU*A(I)*(DT/TP(I))**P(I) 
  450 GWC(I)=(1.-FCAP(I))*TP(I)/DT
C 
C **** INITIALIZE VALUES SPECIFIC TO INDIVIDUAL ELEMENTS. 
C 
      Y=1./X
      DO 460 I=1,N
      K=2 
      IS=SOIL(I)/256
      IC=MOD(SUR(I),256)
      PIV(I)=(1.-ASM(IS))*TP(IS)/DT 
C 
C **** CONTINUE FOR SURFACE INITIAL CONDITION.
C 
      J=MOD(RANE(I),256)
      IF (TC(J,2).LT.(TMIN+1.1)) K=3
      FRA(J)=FRA(J)+Y 
      SUPP=RC(J,K)*(1.-PER(IC))*CU
      X=FILT(A(IS),PIV(I),P(IS),FC(IS),GWC(IS),DR(I),S(I),SUPP,CU2,ROUGH
     1(IC),HU(IC),NEXP) 
      FILTS(I)=X
      IF (X.GT.SUPP) X=SUPP 
  460 FLINS(I)=SUPP-X 
C 
C **** CONVERT SURFACE VALUES.
C 
      DO 480 I=1,ICR
      pitini=PIT(1,I)
      DIRM(I)=0.10*HU(I)
      DO 470 J=1,NRG
  470 PIT(J,I)=pitini*CU1/DT
      ADIR=HU(I)*ROUGH(I)*(DIRM(I)/HU(I))**(1./ROUGH(I))
  480 DIR(I)=ADIR*2.*CU1/DT 
C 
C **** SET CHANNEL RETENTION TO ZERO. 
C 
      DIR(21)=0.
      J=NMAX+ISTRUC+2 
      DO 500 I=1,J
      IF (I.GT.NMAX) GO TO 490
      Q(I)=0. 
      SS(I)=0.
      SEL(I)=0. 
      SST(I)=0. 
      DIN(I)=0. 
  490 QI(I)=0.
  500 SI(I)=0.
      RETURN
C 
C **** ERROR MESSAGES.
C 
  510 WRITE (6,930) 
      STOP
  520 WRITE (6,840) 
      STOP
  530 WRITE (6,860) 
      STOP
  540 WRITE (6,850) 
      STOP
  550 WRITE (6,870) 
      STOP
  560 WRITE (6,890) J 
      STOP
  570 WRITE (6,900) NRG,J 
      STOP
  580 WRITE (6,910) TEST
      STOP
  590 WRITE (6,970) ROUGH(I),CROP(I,1),CROP(I,2)
      STOP
C 
C **** FORMATS. 
C 
  600 FORMAT (1X,27HRAIN DATA MISSING FOR GAGE ,A2,12H, AT ELEMENT,I4,1H
     1,,I4,7H: GAGE ,A2,10H DATA USED)
  610 FORMAT (16X,F6.1/17X,I4,8X,I4)
  620 FORMAT (11X,2A4,6X,F3.2,6X,F3.2,5X,F3.2,5X,F4.2,4X,F4.3,4X,F3.2)
  630 FORMAT (/1X,27HSIMULATION TIME INCREMENT =,F5.0,8H SECONDS) 
  640 FORMAT (I4,2PF9.1,F11.1,0PF11.2,F8.2,F7.2,F9.1,2PF10.1,0PF9.2)
  650 FORMAT (/1X,18HCHANNEL PROPERTIES/1X,4HTYPE,3X,5HWIDTH,3X,11HMANNI
     1NG'S N/9X,A4/(I4,F8.1,F11.3)) 
  660 FORMAT (//5X,33HRAINFALL HYETOGRAPH FOR EVENT OF ,2A4)
  670 FORMAT (/5X,12HGAGE NUMBER ,A2/5X,11HTIME - MIN.,7X,15HRAINFALL RA
     1TE -,2A4/(F14.1,F24.2)) 
  680 FORMAT (2I3,I2,I3,3I4,3X,A2,1X,A2,2X,I4,I3,2I4) 
  690 FORMAT (/,5X,11A4,/,5X,'WATERSHED CHARACTERISTICS',/,' NUMBER OF',
     1F6.2,A4,' OVERLAND FLOW ELEMENTS =',I5,/,1X,'NUMBER OF CHANNEL SEG
     2MENTS = ',I3,/,1X,'AREA OF CATCHMENT =',F8.1,A4,/,1X,'CATCHMENT SL
     3OPE: MIN =',2PF7.2,'  AVE =',F7.2,'  MAX =',F7.2,' PERCENT',/,1X,'
     4CHANNEL SLOPE:   MIN =',F7.2,'  AVE =',F7.2,'  MAX =',F7.2,' PERCE
     5NT',/,1X,'PERCENT OF AREA TILED =',F6.1,' WITH A D.C. OF',0PF5.2,A
     64,'/24H',/,' MEAN ANTECEDENT SOIL MOISTURE =',2PF4.0,', FIELD CAPA
     7CITY =',F4.0,' PERCENT SATURATION',/,' GROUNDWATER RELEASE FRACTIO
     8N =',0PF7.4,/,1X,'OUTLET IS ELEMENT',I5,' AT ROW',I4,' COL',I4)
  700 FORMAT (/,' SURFACE COVER/MANAGEMENT CONDITIONS',8X,'SOIL ASSOCIAT
     1ION PROPERTIES',/,3X,'CROP  PERCENT PERCENT  N',4X,'C',5X,'NO. PER
     2CENT   FC',4X,'INITIAL  CONTROL  K',/,9X,'PRESENT  COVER',18X,'PRE
     3SENT',4A4,' DEPTH',A4)
  710 FORMAT (1X,2A4,2PF6.1,F7.0,0PF6.3,F6.2,I5,2PF7.1,0PF7.1,1X,2F8.1,F
     17.2)
  720 FORMAT (I39,2PF7.1,0PF7.1,1X,2F8.1,F7.2)
  730 FORMAT (1X,2A4,2PF6.1,F7.0,0PF6.3,F6.2) 
  740 FORMAT (A1,F9.0,F10.0)
  750 FORMAT (//1X,15HSOIL PROPERTIES/1X,4HSOIL,2X,8HPOROSITY,2X,10HFIEL
     1D CAP.,2X,22HINFILTRATION CONSTANTS,2X,7HCONTROL,2X,10HANTECEDENT,
     21X,7HEROSION/7X,8H(PERCENT,3X,8H(PERCENT,6X,2HFC,7X,1HA,6X,1HP,5X,
     34HZONE,5X,8HMOISTURE,3X,6HCONST./9X,5HVOL.),6X,5HSAT.),4X,2A4,2A4,
     49X,A4,3X,13H(PERCENT SAT))
  760 FORMAT (18X,F4.0,27X,F5.0)
  770 FORMAT (8H ELEMENT,I4,1H,,I4,27H FLOWS OUT OF THE WATERSHED)
  780 FORMAT (18X,I4) 
  790 FORMAT (10X,F3.2,6X,F3.2,6X,F5.2,5X,F5.3,5X,F3.2,6X,F5.1,7X,F3.2,5
     1X,F3.2) 
  800 FORMAT (1X,A4,52X,A4) 
  810 FORMAT (A4,15X,I1,25X,2A4)
  820 FORMAT (A4,24X,11A4)
  830 FORMAT (16X,A2) 
  840 FORMAT (37H NUMBER OF SHED+CHAN ELEMENTS EXCEEDS,10H DIMENSION) 
  850 FORMAT (32H RAINFALL DATA EXCEEDS DIMENSION)
  860 FORMAT (31H NO. OF SOILS EXCEEDS DIMENSION) 
  870 FORMAT (36H NO. OF CROPS EXCEEDS DIMENSION SPEC)
  880 FORMAT (47H ANALYSIS IS NOT ACCURATE IF RAINFALL INTENSITY,28H INT
     1ERVALS ARE LESS THAN DT.) 
  890 FORMAT (39HCHANNELS DISCONTINUOUS NEAR ELEMENT NO.,I5)
  900 FORMAT (1X,37HHYETOGRAPH DATA MISSING OR INCORRECT,,24H FIRST COLU
     1MN NOT 0 OR 1/I4,40H GAGES REQUESTED. BAD LINE BEGINS WITH: ,A2)
  910 FORMAT (24HINCORRECT INPUT SEQUENCE,36H OR HEADER CARD.  CARD BEGI
     1NS WITH: ,A4) 
  920 FORMAT (30X,I3) 
  930 FORMAT (39H NO. OF CHANNEL TYPES EXCEEDS DIMENSION) 
  940 FORMAT (31X,I3) 
  950 FORMAT (/7H COVER/,20HMANAGEMENT PRACTICES/3X,4HCROP,6X,9HMAX. POT
     1.,3X,7HPERCENT,2X,6HROUGH.,2X,6HROUGH.,2X,9HMANNING'S,3X,7HEROSION
     2/11X,12HINTERCEPTION,3X,5HCOVER,3X,6HCOEFF.,2X,6HHEIGHT,6X,1HN,8X,
     36HCONST./14X,A4,25X,A4,16X,A4)
  960 FORMAT (1X,I2,1X,2A4,F7.2,2PF12.0,0PF8.2,F8.1,F10.3,F10.2)
  970 FORMAT (20H ROUGHNESS COEFF. OF,F8.2,27H IS OUT OF RANGE FOR CROP:
     1 ,2A4)
  980 FORMAT (39X,F5.2/31X,E10.3) 
  990 FORMAT (/1X,22HTILE DRAINAGE COEFF. =,F5.2,A4,4H/24H/1X,30HGROUNDW
     1ATER RELEASE FRACTION =,E10.3)
 1000 FORMAT (/3X,28HSTRUCTURAL MEASURES INCLUDED,/10X,4HTYPE,9X,6HNUMBE
     1R)
 1010 FORMAT (I7,2X,3A4,I6) 
 1020 FORMAT (1X,11HCHANNEL NO.,I5,15H AT ELEMENT NO.,I5) 
C 
      END 
      SUBROUTINE STRUCT (I,J,NC,NR,RFL,IEL,JMAX,NPAR,NMAX,STRUC,NSTRUC,I
     1STRUC,X,DX,WID,SSII,SSI,PIV,CN,CWID,CHAN,CONST,SL,II,SCMIN,SCMAX,S
     2CBAR,ANG,IELC,NPAR2)
C 
C ****** SUBROUTINE TO ADJUST PARAMETERS TO REFLECT STRUCTURAL PRACTICES
C ****** INSTALLED WITHIN AN ELEMENT. 
C 
      DIMENSION IEL(3,JMAX,NPAR2), NSTRUC(ISTRUC), WID(10), CN(10) 
      DIMENSION IELC(3,JMAX,2)
      INTEGER CHAN,PRACT
      LOGICAL STRUC 
      CHARACTER*2 IELC
C 
C **** SWITCH TO APPROPRIATE HANDLER FOR EACH STRUCTURAL TYPE.
C 
      PRACT=IEL(2,J,9)
      IF (PRACT.GT.ISTRUC.OR.PRACT.LT.0) GO TO 90 
      STRUC=.TRUE.
      NSTRUC(PRACT)=NSTRUC(PRACT)+1 
      GO TO (10,60,70,80), PRACT
C 
C **** HANDLE PONDS AND TILE-OUTLET TERRACES BY USING A TRAP EFFICIENCY 
C **** APPROACH, FOR BOTH SEDIMENT AND WATER. 
C 
C **** CASE 1 IS FOR A PTO. 
C 
   10 TRAP=.90
C 
C **** CHECK FOR A POSSIBLE SHADOW CHANNEL ELEMENT. 
C 
   20 IF (CHAN.EQ.0) GO TO 40 
C 
C **** IT'S A CHANNEL ELEMENT, DOES IT REQUIRE DIAGONAL FLOW? 
C 
      IF (ANG.LT..3926991.OR.ANG.GT.1.178097) GO TO 40
C 
C **** FLOW IS DIAGONAL, CHANGE DESTINATION ELEMENT NUMBERS.
C 
      IF (NR.LT.I) GO TO 30 
      NR=NC+1 
      NC=NC+1 
      GO TO 40
   30 NR=NC-1 
      NC=NC-1 
C 
C **** THE PREDOMINANT OVERLAND DIRECTION IS MAINTAINED AND THAT
C **** ELEMENT WILL RECEIVE THE UNTRAPPED FLOW AND SEDIMENT.
C 
   40 IF (RFL.GT..5) GO TO 50 
      RFL=TRAP
      NR=NMAX+1+PRACT 
      RETURN
   50 RFL=1.-TRAP 
      NC=NMAX+1+PRACT 
      RETURN
C 
C **** PONDS ARE SIMILAR TO PTO'S, BUT HAVE A HIGHER TRAP EFFICIENCY. 
C 
   60 TRAP=.95
      GO TO 20
C 
C **** GRASSED WATERWAYS DIRECTLY AFFECT ONLY THE VEGETAGED AREA OF 
C **** THE ELEMENT IN WHICH THEY ARE LOCATED, BUT THEY MUST ALSO ASSURE 
C **** THAT THIS ELEMENT HAS A SHADOW CHANNEL ELEMENT.
C 
   70 IF (CHAN.NE.0) GO TO 80 
C 
C **** CURRENT ELEMENT DOES NOT HAVE A SHADOW CHANNEL ELEMENT, MAKE ONE.
C 
      CHAN=IEL(2,J,11)
      IF (CHAN.EQ.0) CHAN=1 
      II=II+1 
      CWID=WID(CHAN)
      PIV=CONST/CN(CHAN)/X*(DX/CWID/X)**.6667*SQRT(SSI) 
      SSII=SSI
      IF (SSI.LT.SCMIN) SCMIN=SSI 
      IF (SSI.GT.SCMAX) SCMAX=SSI 
      SCBAR=SCBAR+SSI 
C 
C **** NOW ACCOUNT FOR VEGETATED AREA BY REDUCING THE SEDIMENT
C **** DETACHMENT BY FLOW FOR THIS ELEMENT BY AN AMOUNT PROPORTIONAL
C **** TO THE VEGETATED AREA.  SINCE FLOW DETACHMENT IS DIRECTLY
C **** PROPORTIONAL TO THE OVERLAND SLOPE, ADJUST THAT PARAMETER. 
C 
C **** FIELD BORDERS HAVE A SIMILAR EFFECT TO THE VEGETATED AREA
C **** OF GRASSED WATERWAYS.
C 
   80 TRAP=FLOAT(IEL(2,J,10))/DX
      IF (TRAP.GT..5) TRAP=.5 
      SL=SL*(1.-TRAP) 
      RETURN
C 
C **** CHECK TO SEE IF IT'S A MANAGEMENT PRACTICE BEFORE SPOUTING OFF.
C 
   90 IF (PRACT.GT.10.AND.PRACT.LT.13) RETURN 
      WRITE (6,100) IEL(2,J,9),IEL(2,J,1),J 
      RETURN
C 
  100 FORMAT (14H  PRACTICE NO.,I3,7H IN ROW,I4,5H, COL,I4,20H ILLEGAL A
     1ND IGNORED) 
C 
      END 
      SUBROUTINE DRAIN (DR,DC,DIN,N,N1,N2,STD,TIAL,RFL,NR,NC) 
C 
C ****** SUBROUTINE FOR SUBSURFACE DRAINAGE.
C 
      DIMENSION DR(1700), DIN(1700), RFL(1700)
      INTEGER NR(1700),NC(1700),TIAL(1700)
C 
C **** SET ALL CHANNEL INFLOWS TO ZERO. 
C 
      DO 10 I=N1,N2 
   10 DIN(I)=0. 
      STD=0.
C 
C **** ROUTE DRAINAGE FROM TILES. 
C 
      DO 50 I=1,N 
      DRANE=0.
      IF (TIAL(I).LT.256) GO TO 40
      IF (DR(I).GT.DC) GO TO 20 
      DRANE=DR(I) 
      GO TO 30
   20 DRANE=DC
   30 STD=STD+DRANE 
   40 DRANE=DRANE+DIN(I)
      DD=RFL(I)*DRANE 
      J=NR(I) 
      K=NC(I) 
      DIN(J)=DIN(J)+DD
      DIN(K)=DIN(K)-DD+DRANE
   50 DIN(I)=0. 
      RETURN
C 
      END 
      FUNCTION FILT(A,PIV,P,FC,GWC,DR,S,R,CU2,ROUGH,HU,NEXP)
C 
C ****** CALCULATION OF INFILTRATION CAPACITY.
C 
C **** POTENTIAL INFILTRATION CAPACITY -- WHOLE SURFACE COVERED.
C 
      IF (PIV) 30,40,10 
C 
C **** UNSATURATED INFILTRATION ZONE. 
C 
   10 FMAX=A*PIV**P+FC
      IF (PIV.LT.GWC) GO TO 20
      DR=0. 
      GO TO 50
   20 DR=FC*(1.-PIV/GWC)**NEXP
      GO TO 50
C 
C **** INFILTRATION ZONE SATURATED. 
C 
   30 PIV=0.
   40 DR=FC 
      FMAX=FC 
C 
C **** ADJUST INFILTRATION ACCORDING TO FRACTION OF AREA INUNDATED. 
C **** REMAINING AREA INFILTRATES AT RAINFALL RATE. 
C 
   50 IF (R.GE.FMAX.OR.HU.LE.0.) GO TO 70 
      DEP=S*CU2 
      IF (DEP.GT.1.E-10) GO TO 60 
      FWA=0.
      GO TO 90
   60 FH=DEP/HU/ROUGH 
      IF (FH.LT.1.) GO TO 80
C 
C **** ENTIRE SURFACE INUNDATED OR RAINFALL RATE EXCEEDS SOIL 
C **** INFILTRATION CAPACITY. 
C 
   70 FILT=FMAX 
      RETURN
C 
C **** INFILTRATION CAPACITY REDUCED BELOW ITS POTENTIAL VALUE. 
   80 FWA=FH**(1.-ROUGH)
   90 FILT=FWA*FMAX+(1.-FWA)*R
      RETURN
C 
      END 
      FUNCTION RAIN(RATE,PIT,PER) 
C 
C ****** DETERMINATION OF NET RAINFALL RATE.
C 
      IF (PIT) 40,50,10 
   10 RIT=PER*RATE
      IF (RIT-PIT) 20,30,30 
   20 RAIN=RATE-RIT 
      PIT=PIT-RIT 
      RETURN
   30 RAIN=RATE-PIT 
      PIT=0.
      RETURN
   40 PIT=0.
   50 RAIN=RATE 
      RETURN
C 
      END 
      SUBROUTINE SED (ZW,ZL,R,SL,Q,CDR,SKDR,SI,SEL,SE,S,M,N,SST,CE1,CE2,
     1CE3,CE4,CE5)
C 
C ****** SUBROUTINE FOR SEDIMENT DETACHMENT AND TRANSPORT CALCULATIONS. 
C 
      IF (Q.GT.0.) GO TO 10 
C 
C **** NO OUTFLOW, ALL SEDIMENT ASSUMED DEPOSITED.
C 
      SEL=SEL+(SST+SI)/2. 
      SST=SI
      SE=0. 
      SI=0. 
      RETURN
C 
C **** OUTFLOW. 
C 
   10 QX=Q/ZW 
      IF (QX.LE.CE5) GO TO 20 
      TF=CE1*QX*Q*SL
      GO TO 30
   20 TF=CE2*SL*SQRT(Q*ZW)
   30 C=CDR*SKDR
      DR=C*CE3*R*R/ZL/ZW
      DF=C*CE4*SL*Q*ZL
C 
C **** ONLY ALLOW PICKUP OF DEPOSITED SEDIMENT IN CHANNELS. 
C 
      IF (M.GT.N.AND.DF.GT.SEL) DF=SEL
      DS=SI+DR+DF 
      S2=(SST+DS)/(Q/S+1.)
      SE=S2*Q/S 
      IF (SE.LT.TF) GO TO 40
C 
C **** SEDIMENT SUPPLY EXCEEDS TRANSPORT CAPACITY.
C 
      ZI2=TF*(1.+S/Q)-SST 
      SEL=SEL+SI-ZI2
      SST=ZI2+TF*(S/Q-1.) 
      SE=TF 
      GO TO 50
C 
C **** SEDIMENT SUPPLY LESS THAN TRANSPORT CAPACITY.
C 
   40 IF (SE.LT.0.) SE=0. 
      SST=DS-SE+S2
      SEL=SEL-DF-DR 
   50 SI=0. 
      RETURN
C 
      END 
      SUBROUTINE RELEM (IEL,ITEMP,N,MOUT,NIOUT,NJOUT,ISR,ICR,NMAX,JMAX,N
     1PAR,IELC,ITEMPC,NPAR2)
C 
C ******  SUBROUTINE TO SET UP NEXT ROW OF WATERSHED ELEMENTAL DATA.
C **** INTO THE PROPER POSITION OF THE "3-ROW PER PASS" ARRAY.
C 
      DIMENSION IEL(3,JMAX,NPAR2), ITEMP(NPAR2) 
      DIMENSION IELC(3,JMAX,2), ITEMPC(2) 
      CHARACTER*2 IELC, ITEMPC
C 
C **** "RIPPLE" ROW 2 INTO ROW 1 AND ROW 3 INTO ROW 2, THEN ZERO
C **** THE THIRD ROW. 
C 
      DO 20 J=1,JMAX
      DO 10 I=1,NPAR-2
      IEL(1,J,I)=IEL(2,J,I) 
   10 IEL(2,J,I)=IEL(3,J,I) 
   20 IEL(3,J,3)=0
      DO 25 J=1,JMAX
      DO 23 I=1,2 
      IELC(1,J,I)=IELC(2,J,I) 
   23 IELC(2,J,I)=IELC(3,J,I) 
   25 CONTINUE
C 
C **** SET UP POSSIBLE LAST ROW TEST FLAG.
C 
      IEL(3,1,2)=JMAX 
      IF (ITEMP(3).EQ.999) RETURN 
C 
C **** NOW TRANSFER CURRENT WATERSHED ELEMENTAL DATA INTO THE THIRD 
C **** ROW OF THE "3-ROW PER PASS" ARRAY. 
C 
C ****** IEL(I,J,3) CONTAINS THE POSITION NUMBER FOR THAT ELEMENT IN
C ****** THE SINGLE DIMENSION ARRAYS USED FOR SIMULATION ANALYSIS.
C ****** IEL(I,1,2) CONTAINS THE COLUMN NUMBER OF THE LAST WATERSHED
C ****** ELEMENT IN THE ROW.
C 
   30 J=ITEMP(2)
      K=MOD(ITEMP(6),100) 
      ITEMP(6)=ITEMP(6)/100*100+K 
      IF (K.LE.0.OR.K.GT.ISR) GO TO 80
      IF (ITEMP(7).LE.0.OR.ITEMP(7).GT.ICR) GO TO 90
      IF (J.GT.JMAX) GO TO 50 
C 
C **** TRANSFER PARAMETER DATA FROM A SINGLE ELEMENT. 
C 
      DO 40 I=1,NPAR-2
   40 IEL(3,J,I)=ITEMP(I) 
      DO 45 I=1,2 
   45 IELC(3,J,I)=ITEMPC(I) 
C 
C **** REMEMBER AS POSSIBLE LAST ELEMENT IN CURRENT ROW.
C 
      IEL(3,1,2)=J
C 
C **** REMEMBER ROW NUMBER OF THIS ELEMENT. 
C 
      IC=ITEMP(1) 
C 
C **** SAVE ELEMENT'S SEQUENCE NUMBER.
C 
      N=N+1 
      IF (N.GT.NMAX) GO TO 60 
      IEL(3,J,3)=N
      IF (ITEMP(1).EQ.NIOUT.AND.J.EQ.NJOUT) MOUT=N
      IF (ITEMP(3).NE.0) RETURN 
C 
C **** NOW READ PARAMETERS FOR NEXT ELEMENT.
C 
      READ (5,100) (ITEMP(K),K=1,7),(ITEMPC(L),L=1,2),(ITEMP(K),K=8,11) 
      IF (ITEMP(1).LT.IC.OR.ITEMP(1).GT.IC+1.OR.(ITEMP(2).LE.J.AND.ITEMP
     1(1).EQ.IC)) GO TO 70
      IF (ITEMP(1).EQ.IC) GO TO 30
      RETURN
   50 WRITE (6,110) ITEMP(1),J
      STOP
C 
C **** ERROR MESSAGES.
C 
   60 WRITE (6,120) ITEMP(1),J
      STOP
   70 WRITE (6,130) ITEMP(1),ITEMP(2) 
      STOP
   80 WRITE (6,140) K,ITEMP(1),J
      STOP
   90 WRITE (6,150) ITEMP(7),ITEMP(1),J 
      STOP
C 
  100 FORMAT (2I3,I2,I3,3I4,3X,A2,1X,A2,2X,I4,I3,2I4) 
  110 FORMAT (23H COLUMN NO. FOR ELEMENT,I4,1H,,I4,24H EXCEEDS IEL() DIM
     1ENSION) 
  120 FORMAT (45H NO. OF ELEMENTS EXCEEDS DIMENSION AT ELEMENT,I4,1H,,I4
     1) 
  130 FORMAT (40H ELEMENT DATA OUT OF SEQUENCE AT ELEMENT,I4,1H,,I4)
  140 FORMAT (1X,9HSOIL TYPE,I4,22H SPECIFIED FOR ELEMENT,I4,1H,,I4,15H 
     1IS NOT DEFINED) 
  150 FORMAT (1X,9HCROP TYPE,I4,22H SPECIFIED FOR ELEMENT,I4,1H,,I4,15H 
     1IS NOT DEFINED) 
C 
      END 
