/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/* gdm-info-provider-iface.h
 *
 * Copyright (C) 2007 David Zeuthen
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef GDM_INFO_PROVIDER_IFACE_H
#define GDM_INFO_PROVIDER_IFACE_H

#include <glib-object.h>
#include <gnome-device-manager/gdm-device.h>

/* TODO: could turn this into a real GObject interface */

typedef struct {
        int id;
        char *text;
        char *button_text;
} GdmInfoProviderTip;

GdmInfoProviderTip *gdm_info_provider_tip_new (int id, char *text, char *button_text);
void                gdm_info_provider_tip_unref (GdmInfoProviderTip *notice);

typedef struct {
        gboolean             (*get_provider_matches) (GdmDevice *device);
        char                *(*get_icon_name)        (GdmDevice *device);
        char                *(*get_short_name)       (GdmDevice *device);
        char                *(*get_long_name)        (GdmDevice *device);
        char                *(*get_vendor)           (GdmDevice *device);
        char                *(*get_product)          (GdmDevice *device);
        /* summary: returns a list of char* pointers */
        GSList              *(*get_summary)          (GdmDevice *device);
        /* tips: returns a list of GdmInfoProviderTip pointers */
        GSList              *(*get_errors)           (GdmDevice *device);
        GSList              *(*get_warnings)         (GdmDevice *device);
        GSList              *(*get_notices)          (GdmDevice *device);
} GdmInfoProviderIface;

#endif /* GDM_INFO_PROVIDER_IFACE_H */
