#ifndef superfloppy_h
#define superfloppy_h
/*
** Copyright 2001 Double Precision, Inc.
** See COPYING for distribution information.
**
*/

static const char superfloppy_h_rcsid[]="$Id: superfloppy.h,v 1.1 2001/02/13 00:15:38 mrsam Exp $";

#define _(s) gettext(s)

extern int idefloppy_probe(const char *, int *);
extern int idefloppy_capacity(const char *,
			      int (*)(const char *, int), int);
extern int idefloppy_format(const char *, const char *,
			    int (*)(const char *, int), int);
extern int idefloppy_eject(const char *, int);

extern int floppy_probe(const char *, int *);
extern int floppy_capacity(const char *,
			    int (*)(const char *, int), int);
extern int floppy_format(const char *, const char *,
			    int (*)(const char *, int), int);

extern const char rcfile[];
extern const char *fmtsize(unsigned long, unsigned long);
extern unsigned long kilobytes(unsigned long, unsigned long);

struct driver_info {
	const char *name;
	int (*probe)(const char *, int *);
	int (*capacity)(const char *,
			int (*)(const char *, int), int);
	int (*format)(const char *, const char *, 
			int (*)(const char *, int), int);
	int (*eject)(const char *, int);
} ;

#define FLAGS_BRIEF		1
#define FLAGS_FMTVERIFY		2
#define FLAGS_FMTIDEVERIFY	4
#define FLAGS_FORMAT		8
#define FLAGS_EJECT		16

#endif
