/*
 * Copyright (c) 2003, 2007-8 Matteo Frigo
 * Copyright (c) 2003, 2007-8 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Feb  9 19:54:46 EST 2009 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2cdft -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -n 12 -dit -name hc2cfdft_12 -include hc2cf.h */

/*
 * This function contains 142 FP additions, 92 FP multiplications,
 * (or, 96 additions, 46 multiplications, 46 fused multiply/add),
 * 71 stack variables, 2 constants, and 48 memory accesses
 */
#include "hc2cf.h"

static void hc2cfdft_12(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     INT m;
     for (m = mb, W = W + ((mb - 1) * 22); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 22, MAKE_VOLATILE_STRIDE(rs)) {
	  E T2z, T2M;
	  {
	       E To, T1E, T2H, T1m, T1W, Tl, T1J, T2i, T2K, T1B, T2I, T2e, T19, T2E, T2C;
	       E T27, T1M, Tz, T2B, T1f, T1O, TJ, TT, T1Q;
	       {
		    E T2b, T1s, T1A, T2d;
		    {
			 E T1u, T1z, T1v, T2c, T1i, Te, T1l, Tj, Tf, T1H, T4, T1o, T1, T1r, T9;
			 E T1n, T5;
			 {
			      E T1x, T1y, T1t, Tm, Tn;
			      Tm = Ip[0];
			      Tn = Im[0];
			      T1x = Rp[0];
			      T1y = Rm[0];
			      T1t = W[0];
			      T1u = Tm + Tn;
			      To = Tm - Tn;
			      {
				   E Th, Ti, Tb, Tc, Td;
				   Tc = Ip[WS(rs, 4)];
				   T1z = T1x - T1y;
				   T1E = T1x + T1y;
				   Td = Im[WS(rs, 4)];
				   T1v = T1t * T1u;
				   Th = Rp[WS(rs, 4)];
				   T2c = T1t * T1z;
				   T1i = Tc + Td;
				   Te = Tc - Td;
				   Ti = Rm[WS(rs, 4)];
				   Tb = W[14];
				   {
					E T7, T8, T2, T3;
					T2 = Ip[WS(rs, 2)];
					T1l = Th - Ti;
					Tj = Th + Ti;
					Tf = Tb * Te;
					T3 = Im[WS(rs, 2)];
					T7 = Rp[WS(rs, 2)];
					T1H = Tb * Tj;
					T8 = Rm[WS(rs, 2)];
					T4 = T2 - T3;
					T1o = T2 + T3;
					T1 = W[6];
					T1r = T7 - T8;
					T9 = T7 + T8;
					T1n = W[8];
					T5 = T1 * T4;
				   }
			      }
			 }
			 {
			      E T1F, T2a, T1p, T1h, T1k;
			      T1F = T1 * T9;
			      T2a = T1n * T1r;
			      T1p = T1n * T1o;
			      T1h = W[16];
			      T1k = W[17];
			      {
				   E T1G, Ta, Tk, T1I, T1q, T1w;
				   {
					E T6, Tg, T2G, T1j;
					T6 = W[7];
					Tg = W[15];
					T2G = T1h * T1l;
					T1j = T1h * T1i;
					T1G = FMA(T6, T4, T1F);
					Ta = FNMS(T6, T9, T5);
					T2H = FMA(T1k, T1i, T2G);
					T1m = FNMS(T1k, T1l, T1j);
					Tk = FNMS(Tg, Tj, Tf);
					T1I = FMA(Tg, Te, T1H);
				   }
				   T1q = W[9];
				   T1w = W[1];
				   T1W = Ta - Tk;
				   Tl = Ta + Tk;
				   T1J = T1G + T1I;
				   T2i = T1I - T1G;
				   T2b = FMA(T1q, T1o, T2a);
				   T1s = FNMS(T1q, T1r, T1p);
				   T1A = FNMS(T1w, T1z, T1v);
				   T2d = FMA(T1w, T1u, T2c);
			      }
			 }
		    }
		    {
			 E T11, Tt, T10, TX, Ty, TZ, T23, T1b, TN, TS, T1e, T1P, TO, T17, TD;
			 E T16, T13, T14, TI, TA;
			 {
			      E Tw, Tx, Tr, Ts, TK;
			      Tr = Ip[WS(rs, 3)];
			      Ts = Im[WS(rs, 3)];
			      T2K = T1s - T1A;
			      T1B = T1s + T1A;
			      T2I = T2b + T2d;
			      T2e = T2b - T2d;
			      Tw = Rp[WS(rs, 3)];
			      T11 = Tr + Ts;
			      Tt = Tr - Ts;
			      Tx = Rm[WS(rs, 3)];
			      T10 = W[12];
			      TX = W[13];
			      {
				   E TL, TY, TM, TQ, TR;
				   TL = Ip[WS(rs, 1)];
				   Ty = Tw + Tx;
				   TY = Tx - Tw;
				   TM = Im[WS(rs, 1)];
				   TQ = Rp[WS(rs, 1)];
				   TR = Rm[WS(rs, 1)];
				   TZ = TX * TY;
				   T23 = T10 * TY;
				   T1b = TL + TM;
				   TN = TL - TM;
				   TS = TQ + TR;
				   T1e = TQ - TR;
			      }
			      TK = W[2];
			      {
				   E TG, TH, TB, TC;
				   TB = Ip[WS(rs, 5)];
				   TC = Im[WS(rs, 5)];
				   TG = Rp[WS(rs, 5)];
				   T1P = TK * TS;
				   TO = TK * TN;
				   T17 = TB + TC;
				   TD = TB - TC;
				   TH = Rm[WS(rs, 5)];
				   T16 = W[20];
				   T13 = W[21];
				   T14 = TH - TG;
				   TI = TG + TH;
				   TA = W[18];
			      }
			 }
			 {
			      E T12, T1N, TE, T18, T24, T26, T25, T15;
			      T12 = FMA(T10, T11, TZ);
			      T15 = T13 * T14;
			      T25 = T16 * T14;
			      T1N = TA * TI;
			      TE = TA * TD;
			      T18 = FMA(T16, T17, T15);
			      T24 = FNMS(TX, T11, T23);
			      T26 = FNMS(T13, T17, T25);
			      {
				   E Tv, T1L, Tu, Tq;
				   Tq = W[10];
				   T19 = T12 + T18;
				   T2E = T18 - T12;
				   Tv = W[11];
				   T2C = T24 + T26;
				   T27 = T24 - T26;
				   T1L = Tq * Ty;
				   Tu = Tq * Tt;
				   {
					E T1d, T2A, T1c, T1a, TF, TP;
					T1a = W[4];
					T1d = W[5];
					T1M = FMA(Tv, Tt, T1L);
					Tz = FNMS(Tv, Ty, Tu);
					T2A = T1a * T1e;
					T1c = T1a * T1b;
					TF = W[19];
					TP = W[3];
					T2B = FMA(T1d, T1b, T2A);
					T1f = FNMS(T1d, T1e, T1c);
					T1O = FMA(TF, TD, T1N);
					TJ = FNMS(TF, TI, TE);
					TT = FNMS(TP, TS, TO);
					T1Q = FMA(TP, TN, T1P);
				   }
			      }
			 }
		    }
	       }
	       {
		    E T2h, T2D, T1Z, T2l, T2J, T22, T2k, T29, T30, T1U, T1V, T1Y, T2Z, T1T;
		    {
			 E T2Y, TW, T2V, T1D, T1K, T1S;
			 {
			      E Tp, T2W, TU, T1R, T2X, T1g, TV, T1C;
			      T2h = FNMS(KP500000000, Tl, To);
			      Tp = Tl + To;
			      T2W = T2C - T2B;
			      T2D = FMA(KP500000000, T2C, T2B);
			      T1Z = TJ - TT;
			      TU = TJ + TT;
			      T1R = T1O + T1Q;
			      T2l = T1Q - T1O;
			      T2J = FNMS(KP500000000, T2I, T2H);
			      T2X = T2H + T2I;
			      T1g = T19 + T1f;
			      T22 = FNMS(KP500000000, T19, T1f);
			      T2k = FNMS(KP500000000, TU, Tz);
			      TV = Tz + TU;
			      T1C = T1m + T1B;
			      T29 = FNMS(KP500000000, T1B, T1m);
			      T2Y = T2W - T2X;
			      T30 = T2W + T2X;
			      TW = Tp - TV;
			      T2V = TV + Tp;
			      T1U = T1g + T1C;
			      T1D = T1g - T1C;
			      T1V = FNMS(KP500000000, T1J, T1E);
			      T1K = T1E + T1J;
			      T1S = T1M + T1R;
			      T1Y = FNMS(KP500000000, T1R, T1M);
			 }
			 Ip[WS(rs, 3)] = KP500000000 * (TW + T1D);
			 Im[WS(rs, 2)] = KP500000000 * (T1D - TW);
			 Im[WS(rs, 5)] = KP500000000 * (T2Y - T2V);
			 T2Z = T1K - T1S;
			 T1T = T1K + T1S;
			 Ip[0] = KP500000000 * (T2V + T2Y);
		    }
		    {
			 E T2v, T1X, T2Q, T2F, T2R, T2L, T2w, T20, T2t, T28, T2p, T2j;
			 Rm[WS(rs, 2)] = KP500000000 * (T2Z + T30);
			 Rp[WS(rs, 3)] = KP500000000 * (T2Z - T30);
			 Rp[0] = KP500000000 * (T1T + T1U);
			 Rm[WS(rs, 5)] = KP500000000 * (T1T - T1U);
			 T2v = FMA(KP866025403, T1W, T1V);
			 T1X = FNMS(KP866025403, T1W, T1V);
			 T2Q = FMA(KP866025403, T2E, T2D);
			 T2F = FNMS(KP866025403, T2E, T2D);
			 T2R = FMA(KP866025403, T2K, T2J);
			 T2L = FNMS(KP866025403, T2K, T2J);
			 T2w = FMA(KP866025403, T1Z, T1Y);
			 T20 = FNMS(KP866025403, T1Z, T1Y);
			 T2t = FMA(KP866025403, T27, T22);
			 T28 = FNMS(KP866025403, T27, T22);
			 T2p = FMA(KP866025403, T2i, T2h);
			 T2j = FNMS(KP866025403, T2i, T2h);
			 {
			      E T2T, T2q, T2s, T2U;
			      {
				   E T21, T2f, T2S, T2n, T2P, T2m, T2o, T2g;
				   T2T = T1X - T20;
				   T21 = T1X + T20;
				   T2q = FMA(KP866025403, T2l, T2k);
				   T2m = FNMS(KP866025403, T2l, T2k);
				   T2s = FMA(KP866025403, T2e, T29);
				   T2f = FNMS(KP866025403, T2e, T29);
				   T2S = T2Q + T2R;
				   T2U = T2R - T2Q;
				   T2n = T2j - T2m;
				   T2P = T2m + T2j;
				   T2o = T2f - T28;
				   T2g = T28 + T2f;
				   Im[WS(rs, 3)] = KP500000000 * (T2S - T2P);
				   Ip[WS(rs, 2)] = KP500000000 * (T2P + T2S);
				   Rm[WS(rs, 3)] = KP500000000 * (T21 + T2g);
				   Rp[WS(rs, 2)] = KP500000000 * (T21 - T2g);
				   Ip[WS(rs, 5)] = KP500000000 * (T2n + T2o);
				   Im[0] = KP500000000 * (T2o - T2n);
			      }
			      {
				   E T2y, T2x, T2N, T2O, T2r, T2u;
				   T2z = T2q + T2p;
				   T2r = T2p - T2q;
				   T2u = T2s - T2t;
				   T2y = T2t + T2s;
				   T2x = T2v + T2w;
				   T2N = T2v - T2w;
				   Rp[WS(rs, 5)] = KP500000000 * (T2T + T2U);
				   Rm[0] = KP500000000 * (T2T - T2U);
				   Im[WS(rs, 4)] = KP500000000 * (T2u - T2r);
				   Ip[WS(rs, 1)] = KP500000000 * (T2r + T2u);
				   T2O = T2L - T2F;
				   T2M = T2F + T2L;
				   Rp[WS(rs, 1)] = KP500000000 * (T2N + T2O);
				   Rm[WS(rs, 4)] = KP500000000 * (T2N - T2O);
				   Rp[WS(rs, 4)] = KP500000000 * (T2x + T2y);
				   Rm[WS(rs, 1)] = KP500000000 * (T2x - T2y);
			      }
			 }
		    }
	       }
	  }
	  Im[WS(rs, 1)] = -(KP500000000 * (T2z + T2M));
	  Ip[WS(rs, 4)] = KP500000000 * (T2z - T2M);
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 12},
     {TW_NEXT, 1, 0}
};

static const hc2c_desc desc = { 12, "hc2cfdft_12", twinstr, &GENUS, {96, 46, 46, 0} };

void X(codelet_hc2cfdft_12) (planner *p) {
     X(khc2c_register) (p, hc2cfdft_12, &desc, HC2C_VIA_DFT);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2cdft -compact -variables 4 -pipeline-latency 4 -n 12 -dit -name hc2cfdft_12 -include hc2cf.h */

/*
 * This function contains 142 FP additions, 76 FP multiplications,
 * (or, 112 additions, 46 multiplications, 30 fused multiply/add),
 * 52 stack variables, 3 constants, and 48 memory accesses
 */
#include "hc2cf.h"

static void hc2cfdft_12(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DK(KP433012701, +0.433012701892219323381861585376468091735701313);
     INT m;
     for (m = mb, W = W + ((mb - 1) * 22); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 22, MAKE_VOLATILE_STRIDE(rs)) {
	  E Tm, T1t, T1d, T2j, Tj, T1Y, T1w, T1G, T1q, T2q, T1U, T2k, Tw, T1y, T17;
	  E T2g, TP, T21, T1B, T1J, T12, T2u, T1P, T2h;
	  {
	       E Tk, Tl, T1k, T1m, T1n, T1o, T4, T1f, T8, T1h, Th, T1c, Td, T1a, T19;
	       E T1b;
	       {
		    E T2, T3, T6, T7;
		    Tk = Ip[0];
		    Tl = Im[0];
		    T1k = Tk + Tl;
		    T1m = Rp[0];
		    T1n = Rm[0];
		    T1o = T1m - T1n;
		    T2 = Ip[WS(rs, 2)];
		    T3 = Im[WS(rs, 2)];
		    T4 = T2 - T3;
		    T1f = T2 + T3;
		    T6 = Rp[WS(rs, 2)];
		    T7 = Rm[WS(rs, 2)];
		    T8 = T6 + T7;
		    T1h = T6 - T7;
		    {
			 E Tf, Tg, Tb, Tc;
			 Tf = Rp[WS(rs, 4)];
			 Tg = Rm[WS(rs, 4)];
			 Th = Tf + Tg;
			 T1c = Tf - Tg;
			 Tb = Ip[WS(rs, 4)];
			 Tc = Im[WS(rs, 4)];
			 Td = Tb - Tc;
			 T1a = Tb + Tc;
		    }
	       }
	       Tm = Tk - Tl;
	       T1t = T1m + T1n;
	       T19 = W[16];
	       T1b = W[17];
	       T1d = FNMS(T1b, T1c, T19 * T1a);
	       T2j = FMA(T19, T1c, T1b * T1a);
	       {
		    E T9, T1u, Ti, T1v;
		    {
			 E T1, T5, Ta, Te;
			 T1 = W[6];
			 T5 = W[7];
			 T9 = FNMS(T5, T8, T1 * T4);
			 T1u = FMA(T1, T8, T5 * T4);
			 Ta = W[14];
			 Te = W[15];
			 Ti = FNMS(Te, Th, Ta * Td);
			 T1v = FMA(Ta, Th, Te * Td);
		    }
		    Tj = T9 + Ti;
		    T1Y = KP433012701 * (T1v - T1u);
		    T1w = T1u + T1v;
		    T1G = KP433012701 * (T9 - Ti);
	       }
	       {
		    E T1i, T1S, T1p, T1T;
		    {
			 E T1e, T1g, T1j, T1l;
			 T1e = W[8];
			 T1g = W[9];
			 T1i = FNMS(T1g, T1h, T1e * T1f);
			 T1S = FMA(T1e, T1h, T1g * T1f);
			 T1j = W[0];
			 T1l = W[1];
			 T1p = FNMS(T1l, T1o, T1j * T1k);
			 T1T = FMA(T1j, T1o, T1l * T1k);
		    }
		    T1q = T1i + T1p;
		    T2q = KP433012701 * (T1i - T1p);
		    T1U = KP433012701 * (T1S - T1T);
		    T2k = T1S + T1T;
	       }
	  }
	  {
	       E Tr, TT, Tv, TV, TA, TY, TE, T10, TN, T14, TJ, T16;
	       {
		    E Tp, Tq, TC, TD;
		    Tp = Ip[WS(rs, 3)];
		    Tq = Im[WS(rs, 3)];
		    Tr = Tp - Tq;
		    TT = Tp + Tq;
		    {
			 E Tt, Tu, Ty, Tz;
			 Tt = Rp[WS(rs, 3)];
			 Tu = Rm[WS(rs, 3)];
			 Tv = Tt + Tu;
			 TV = Tt - Tu;
			 Ty = Ip[WS(rs, 5)];
			 Tz = Im[WS(rs, 5)];
			 TA = Ty - Tz;
			 TY = Ty + Tz;
		    }
		    TC = Rp[WS(rs, 5)];
		    TD = Rm[WS(rs, 5)];
		    TE = TC + TD;
		    T10 = TC - TD;
		    {
			 E TL, TM, TH, TI;
			 TL = Rp[WS(rs, 1)];
			 TM = Rm[WS(rs, 1)];
			 TN = TL + TM;
			 T14 = TM - TL;
			 TH = Ip[WS(rs, 1)];
			 TI = Im[WS(rs, 1)];
			 TJ = TH - TI;
			 T16 = TH + TI;
		    }
	       }
	       {
		    E To, Ts, T13, T15;
		    To = W[10];
		    Ts = W[11];
		    Tw = FNMS(Ts, Tv, To * Tr);
		    T1y = FMA(To, Tv, Ts * Tr);
		    T13 = W[5];
		    T15 = W[4];
		    T17 = FMA(T13, T14, T15 * T16);
		    T2g = FNMS(T13, T16, T15 * T14);
	       }
	       {
		    E TF, T1z, TO, T1A;
		    {
			 E Tx, TB, TG, TK;
			 Tx = W[18];
			 TB = W[19];
			 TF = FNMS(TB, TE, Tx * TA);
			 T1z = FMA(Tx, TE, TB * TA);
			 TG = W[2];
			 TK = W[3];
			 TO = FNMS(TK, TN, TG * TJ);
			 T1A = FMA(TG, TN, TK * TJ);
		    }
		    TP = TF + TO;
		    T21 = KP433012701 * (T1A - T1z);
		    T1B = T1z + T1A;
		    T1J = KP433012701 * (TF - TO);
	       }
	       {
		    E TW, T1O, T11, T1N;
		    {
			 E TS, TU, TX, TZ;
			 TS = W[12];
			 TU = W[13];
			 TW = FNMS(TU, TV, TS * TT);
			 T1O = FMA(TS, TV, TU * TT);
			 TX = W[20];
			 TZ = W[21];
			 T11 = FNMS(TZ, T10, TX * TY);
			 T1N = FMA(TX, T10, TZ * TY);
		    }
		    T12 = TW + T11;
		    T2u = KP433012701 * (T11 - TW);
		    T1P = KP433012701 * (T1N - T1O);
		    T2h = T1O + T1N;
	       }
	  }
	  {
	       E TR, T2f, T2m, T2o, T1s, T1E, T1D, T2n;
	       {
		    E Tn, TQ, T2i, T2l;
		    Tn = Tj + Tm;
		    TQ = Tw + TP;
		    TR = Tn - TQ;
		    T2f = TQ + Tn;
		    T2i = T2g - T2h;
		    T2l = T2j + T2k;
		    T2m = T2i - T2l;
		    T2o = T2i + T2l;
	       }
	       {
		    E T18, T1r, T1x, T1C;
		    T18 = T12 + T17;
		    T1r = T1d + T1q;
		    T1s = T18 - T1r;
		    T1E = T18 + T1r;
		    T1x = T1t + T1w;
		    T1C = T1y + T1B;
		    T1D = T1x + T1C;
		    T2n = T1x - T1C;
	       }
	       Ip[WS(rs, 3)] = KP500000000 * (TR + T1s);
	       Rp[WS(rs, 3)] = KP500000000 * (T2n - T2o);
	       Im[WS(rs, 2)] = KP500000000 * (T1s - TR);
	       Rm[WS(rs, 2)] = KP500000000 * (T2n + T2o);
	       Rm[WS(rs, 5)] = KP500000000 * (T1D - T1E);
	       Im[WS(rs, 5)] = KP500000000 * (T2m - T2f);
	       Rp[0] = KP500000000 * (T1D + T1E);
	       Ip[0] = KP500000000 * (T2f + T2m);
	  }
	  {
	       E T1H, T2b, T2s, T2B, T2v, T2A, T1K, T2c, T1Q, T29, T1Z, T25, T22, T26, T1V;
	       E T28;
	       {
		    E T1F, T2r, T2t, T1I;
		    T1F = FNMS(KP250000000, T1w, KP500000000 * T1t);
		    T1H = T1F - T1G;
		    T2b = T1F + T1G;
		    T2r = FNMS(KP500000000, T2j, KP250000000 * T2k);
		    T2s = T2q - T2r;
		    T2B = T2q + T2r;
		    T2t = FMA(KP250000000, T2h, KP500000000 * T2g);
		    T2v = T2t - T2u;
		    T2A = T2u + T2t;
		    T1I = FNMS(KP250000000, T1B, KP500000000 * T1y);
		    T1K = T1I - T1J;
		    T2c = T1I + T1J;
	       }
	       {
		    E T1M, T1X, T20, T1R;
		    T1M = FNMS(KP250000000, T12, KP500000000 * T17);
		    T1Q = T1M - T1P;
		    T29 = T1P + T1M;
		    T1X = FNMS(KP250000000, Tj, KP500000000 * Tm);
		    T1Z = T1X - T1Y;
		    T25 = T1Y + T1X;
		    T20 = FNMS(KP250000000, TP, KP500000000 * Tw);
		    T22 = T20 - T21;
		    T26 = T21 + T20;
		    T1R = FNMS(KP250000000, T1q, KP500000000 * T1d);
		    T1V = T1R - T1U;
		    T28 = T1R + T1U;
	       }
	       {
		    E T1L, T1W, T2p, T2w;
		    T1L = T1H + T1K;
		    T1W = T1Q + T1V;
		    Rp[WS(rs, 2)] = T1L - T1W;
		    Rm[WS(rs, 3)] = T1L + T1W;
		    T2p = T22 + T1Z;
		    T2w = T2s - T2v;
		    Ip[WS(rs, 2)] = T2p + T2w;
		    Im[WS(rs, 3)] = T2w - T2p;
	       }
	       {
		    E T23, T24, T2x, T2y;
		    T23 = T1Z - T22;
		    T24 = T1V - T1Q;
		    Ip[WS(rs, 5)] = T23 + T24;
		    Im[0] = T24 - T23;
		    T2x = T1H - T1K;
		    T2y = T2v + T2s;
		    Rm[0] = T2x - T2y;
		    Rp[WS(rs, 5)] = T2x + T2y;
	       }
	       {
		    E T27, T2a, T2z, T2C;
		    T27 = T25 - T26;
		    T2a = T28 - T29;
		    Ip[WS(rs, 1)] = T27 + T2a;
		    Im[WS(rs, 4)] = T2a - T27;
		    T2z = T2b - T2c;
		    T2C = T2A - T2B;
		    Rm[WS(rs, 4)] = T2z - T2C;
		    Rp[WS(rs, 1)] = T2z + T2C;
	       }
	       {
		    E T2d, T2e, T2D, T2E;
		    T2d = T2b + T2c;
		    T2e = T29 + T28;
		    Rm[WS(rs, 1)] = T2d - T2e;
		    Rp[WS(rs, 4)] = T2d + T2e;
		    T2D = T26 + T25;
		    T2E = T2A + T2B;
		    Ip[WS(rs, 4)] = T2D + T2E;
		    Im[WS(rs, 1)] = T2E - T2D;
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 12},
     {TW_NEXT, 1, 0}
};

static const hc2c_desc desc = { 12, "hc2cfdft_12", twinstr, &GENUS, {112, 46, 30, 0} };

void X(codelet_hc2cfdft_12) (planner *p) {
     X(khc2c_register) (p, hc2cfdft_12, &desc, HC2C_VIA_DFT);
}
#endif				/* HAVE_FMA */
