/*******************************************************************************
 * Copyright (c) 2000, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.update.core;

import org.eclipse.update.core.model.InstallHandlerEntryModel;

/**
 * Convenience implementation of an install handler entry.
 * <p>
 * This class may be instantiated or subclassed by clients.
 * </p> 
 * <p>
 * <b>Note:</b> This class/interface is part of an interim API that is still under development and expected to
 * change significantly before reaching stability. It is being made available at this early stage to solicit feedback
 * from pioneering adopters on the understanding that any code that uses this API will almost certainly be broken
 * (repeatedly) as the API evolves.
 * </p>
 * @see org.eclipse.update.core.IInstallHandlerEntry
 * @see org.eclipse.update.core.model.InstallHandlerEntryModel
 * @see org.eclipse.update.core.IInstallHandler
 * @since 2.0
 */
public class InstallHandlerEntry
	extends InstallHandlerEntryModel
	implements IInstallHandlerEntry {

	/**
	 * Constructor for InstallHandlerEntry.
	 * @since 2.0
	 */
	public InstallHandlerEntry() {
		super();
	}
}
