/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.swt.tools.internal.ClassData;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.MethodData;
import org.eclipse.swt.tools.internal.ParameterData;

public class NativesGenerator
extends JNIGenerator {
    boolean enterExitMacro = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void generateCopyright() {
        this.generateMetaData("swt_copyright");
    }

    public void generateIncludes() {
        String outputName = this.getOutputName();
        this.outputln("#include \"swt.h\"");
        this.output("#include \"");
        this.output(outputName);
        this.outputln("_structs.h\"");
        this.output("#include \"");
        this.output(outputName);
        this.outputln("_stats.h\"");
        this.outputln();
    }

    public void generate(Class clazz, String methodName) {
        Method[] methods = clazz.getDeclaredMethods();
        int count = 0;
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().startsWith(methodName)) {
                ++count;
            }
            ++i;
        }
        Method[] result = new Method[count];
        count = 0;
        int i2 = 0;
        while (i2 < methods.length) {
            if (methods[i2].getName().startsWith(methodName)) {
                result[count++] = methods[i2];
            }
            ++i2;
        }
        this.generate(result);
    }

    public void generate(Class clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if ((method.getModifiers() & 0x100) != 0) break;
            ++i;
        }
        if (i == methods.length) {
            return;
        }
        NativesGenerator.sort(methods);
        this.generateNativeMacro(clazz);
        this.generateExcludes(methods);
        this.generate(methods);
    }

    public void generate(Method[] methods) {
        NativesGenerator.sort(methods);
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if ((method.getModifiers() & 0x100) != 0) {
                this.generate(method);
                if (this.progress != null) {
                    this.progress.step();
                }
            }
            ++i;
        }
    }

    public void generate(Method method) {
        MethodData methodData = this.getMetaData().getMetaData(method);
        if (methodData.getFlag("no_gen")) {
            return;
        }
        Class<?> returnType = method.getReturnType();
        Class[] paramTypes = method.getParameterTypes();
        String function = NativesGenerator.getFunctionName(method);
        if (returnType != Void.TYPE && !returnType.isPrimitive() && !this.isSystemClass(returnType)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (returnType != clazz) {
                this.output("Warning: bad return type. :");
                this.outputln(method.toString());
                return;
            }
        }
        this.generateSourceStart(function);
        if (this.isCPP) {
            this.output("extern \"C\" ");
            this.generateFunctionPrototype(method, function, paramTypes, returnType, true);
            this.outputln(";");
        }
        this.generateFunctionPrototype(method, function, paramTypes, returnType, false);
        this.generateFunctionBody(method, methodData, function, paramTypes, returnType);
        this.generateSourceEnd(function);
        this.outputln();
    }

    public void setEnterExitMacro(boolean enterExitMacro) {
        this.enterExitMacro = enterExitMacro;
    }

    void generateExcludes(Method[] methods) {
        HashSet<String> excludes = new HashSet<String>();
        int i = 0;
        while (i < methods.length) {
            MethodData methodData;
            String exclude;
            Method method = methods[i];
            if ((method.getModifiers() & 0x100) != 0 && (exclude = (methodData = this.getMetaData().getMetaData(method)).getExclude()).length() != 0) {
                excludes.add(exclude);
            }
            ++i;
        }
        Iterator iter = excludes.iterator();
        while (iter.hasNext()) {
            String exclude = (String)iter.next();
            this.outputln(exclude);
            int i2 = 0;
            while (i2 < methods.length) {
                MethodData methodData;
                String methodExclude;
                Method method = methods[i2];
                if ((method.getModifiers() & 0x100) != 0 && exclude.equals(methodExclude = (methodData = this.getMetaData().getMetaData(method)).getExclude())) {
                    this.output("#define NO_");
                    this.outputln(NativesGenerator.getFunctionName(method));
                }
                ++i2;
            }
            this.outputln("#endif");
            this.outputln();
        }
    }

    void generateNativeMacro(Class clazz) {
        this.output("#define ");
        this.output(NativesGenerator.getClassName(clazz));
        this.output("_NATIVE(func) Java_");
        this.output(NativesGenerator.toC(clazz.getName()));
        this.outputln("_##func");
        this.outputln();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean generateGetParameter(Method method, int i, Class paramType, ParameterData paramData, boolean critical, int indent) {
        if (paramType.isPrimitive() || this.isSystemClass(paramType)) {
            return false;
        }
        String iStr = String.valueOf(i);
        int j = 0;
        while (j < indent) {
            this.output("\t");
            ++j;
        }
        this.output("if (arg");
        this.output(iStr);
        this.output(") if ((lparg");
        this.output(iStr);
        this.output(" = ");
        if (paramType.isArray()) {
            Class<?> componentType = paramType.getComponentType();
            if (!componentType.isPrimitive()) throw new Error("not done");
            if (critical) {
                if (this.isCPP) {
                    this.output("(");
                    this.output(NativesGenerator.getTypeSignature2(componentType));
                    this.output("*)");
                    this.output("env->GetPrimitiveArrayCritical(arg");
                } else {
                    this.output("(*env)->GetPrimitiveArrayCritical(env, arg");
                }
                this.output(iStr);
                this.output(", NULL)");
            } else {
                if (this.isCPP) {
                    this.output("env->Get");
                } else {
                    this.output("(*env)->Get");
                }
                this.output(NativesGenerator.getTypeSignature1(componentType));
                if (this.isCPP) {
                    this.output("ArrayElements(arg");
                } else {
                    this.output("ArrayElements(env, arg");
                }
                this.output(iStr);
                this.output(", NULL)");
            }
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (paramType == clazz) {
                if (paramData.getFlag("unicode")) {
                    if (this.isCPP) {
                        this.output("env->GetStringChars(arg");
                    } else {
                        this.output("(*env)->GetStringChars(env, arg");
                    }
                    this.output(iStr);
                    this.output(", NULL)");
                } else {
                    if (this.isCPP) {
                        this.output("env->GetStringUTFChars(arg");
                    } else {
                        this.output("(*env)->GetStringUTFChars(env, arg");
                    }
                    this.output(iStr);
                    this.output(", NULL)");
                }
            } else if (paramData.getFlag("no_in")) {
                this.output("&_arg");
                this.output(iStr);
            } else {
                this.output("get");
                this.output(NativesGenerator.getClassName(paramType));
                this.output("Fields(env, arg");
                this.output(iStr);
                this.output(", &_arg");
                this.output(iStr);
                this.output(")");
            }
        }
        this.outputln(") == NULL) goto fail;");
        return true;
    }

    void generateSetParameter(int i, Class paramType, ParameterData paramData, boolean critical) {
        if (paramType.isPrimitive() || this.isSystemClass(paramType)) {
            return;
        }
        String iStr = String.valueOf(i);
        if (paramType.isArray()) {
            this.output("\tif (arg");
            this.output(iStr);
            this.output(" && lparg");
            this.output(iStr);
            this.output(") ");
            Class<?> componentType = paramType.getComponentType();
            if (componentType.isPrimitive()) {
                if (critical) {
                    if (this.isCPP) {
                        this.output("env->ReleasePrimitiveArrayCritical(arg");
                    } else {
                        this.output("(*env)->ReleasePrimitiveArrayCritical(env, arg");
                    }
                    this.output(iStr);
                } else {
                    if (this.isCPP) {
                        this.output("env->Release");
                    } else {
                        this.output("(*env)->Release");
                    }
                    this.output(NativesGenerator.getTypeSignature1(componentType));
                    if (this.isCPP) {
                        this.output("ArrayElements(arg");
                    } else {
                        this.output("ArrayElements(env, arg");
                    }
                    this.output(iStr);
                }
                this.output(", lparg");
                this.output(iStr);
                this.output(", ");
                if (paramData.getFlag("no_out")) {
                    this.output("JNI_ABORT");
                } else {
                    this.output("0");
                }
            } else {
                throw new Error("not done");
            }
            this.output(");");
            this.outputln();
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (paramType == clazz) {
                this.output("\tif (arg");
                this.output(iStr);
                this.output(" && lparg");
                this.output(iStr);
                this.output(") ");
                if (paramData.getFlag("unicode")) {
                    if (this.isCPP) {
                        this.output("env->ReleaseStringChars(arg");
                    } else {
                        this.output("(*env)->ReleaseStringChars(env, arg");
                    }
                } else if (this.isCPP) {
                    this.output("env->ReleaseStringUTFChars(arg");
                } else {
                    this.output("(*env)->ReleaseStringUTFChars(env, arg");
                }
                this.output(iStr);
                this.output(", lparg");
                this.output(iStr);
                this.outputln(");");
            } else if (!paramData.getFlag("no_out")) {
                this.output("\tif (arg");
                this.output(iStr);
                this.output(" && lparg");
                this.output(iStr);
                this.output(") ");
                this.output("set");
                this.output(NativesGenerator.getClassName(paramType));
                this.output("Fields(env, arg");
                this.output(iStr);
                this.output(", lparg");
                this.output(iStr);
                this.outputln(");");
            }
        }
    }

    void generateExitMacro(Method method, String function) {
        if (!this.enterExitMacro) {
            return;
        }
        this.output("\t");
        this.output(NativesGenerator.getClassName(method.getDeclaringClass()));
        this.output("_NATIVE_EXIT(env, that, ");
        this.output(function);
        this.outputln("_FUNC);");
    }

    void generateEnterMacro(Method method, String function) {
        if (!this.enterExitMacro) {
            return;
        }
        this.output("\t");
        this.output(NativesGenerator.getClassName(method.getDeclaringClass()));
        this.output("_NATIVE_ENTER(env, that, ");
        this.output(function);
        this.outputln("_FUNC);");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean generateLocalVars(Method method, Class[] paramTypes, Class returnType) {
        boolean needsReturn = this.enterExitMacro;
        int i = 0;
        while (i < paramTypes.length) {
            Class paramType = paramTypes[i];
            if (!paramType.isPrimitive() && !this.isSystemClass(paramType)) {
                ParameterData paramData = this.getMetaData().getMetaData(method, i);
                this.output("\t");
                if (paramType.isArray()) {
                    Class<?> componentType = paramType.getComponentType();
                    if (!componentType.isPrimitive()) throw new Error("not done");
                    this.output(NativesGenerator.getTypeSignature2(componentType));
                    this.output(" *lparg" + i);
                    this.output("=NULL;");
                } else {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (paramType == clazz) {
                        if (paramData.getFlag("unicode")) {
                            this.output("const jchar *lparg" + i);
                        } else {
                            this.output("const char *lparg" + i);
                        }
                        this.output("= NULL;");
                    } else {
                        ClassData classData = this.metaData.getMetaData(paramType);
                        if (classData.getFlag("struct")) {
                            this.output("struct ");
                        }
                        this.output(NativesGenerator.getClassName(paramType));
                        this.output(" _arg" + i);
                        if (paramData.getFlag("init")) {
                            this.output("={0}");
                        }
                        this.output(", *lparg" + i);
                        this.output("=NULL;");
                    }
                }
                this.outputln();
                needsReturn = true;
            }
            ++i;
        }
        if (!needsReturn || returnType == Void.TYPE) return needsReturn;
        this.output("\t");
        this.output(NativesGenerator.getTypeSignature2(returnType));
        this.outputln(" rc = 0;");
        return needsReturn;
    }

    boolean generateGetters(Method method, Class[] paramTypes) {
        ParameterData paramData;
        Class paramType;
        boolean genFailTag = false;
        int criticalCount = 0;
        int i = 0;
        while (i < paramTypes.length) {
            paramType = paramTypes[i];
            paramData = this.getMetaData().getMetaData(method, i);
            if (!this.isCritical(paramType, paramData)) {
                genFailTag |= this.generateGetParameter(method, i, paramType, paramData, false, 1);
            } else {
                ++criticalCount;
            }
            ++i;
        }
        if (criticalCount != 0) {
            this.outputln("#ifdef JNI_VERSION_1_2");
            this.outputln("\tif (IS_JNI_1_2) {");
            i = 0;
            while (i < paramTypes.length) {
                paramType = paramTypes[i];
                paramData = this.getMetaData().getMetaData(method, i);
                if (this.isCritical(paramType, paramData)) {
                    genFailTag |= this.generateGetParameter(method, i, paramType, paramData, true, 2);
                }
                ++i;
            }
            this.outputln("\t} else");
            this.outputln("#endif");
            this.outputln("\t{");
            i = 0;
            while (i < paramTypes.length) {
                paramType = paramTypes[i];
                paramData = this.getMetaData().getMetaData(method, i);
                if (this.isCritical(paramType, paramData)) {
                    genFailTag |= this.generateGetParameter(method, i, paramType, paramData, false, 2);
                }
                ++i;
            }
            this.outputln("\t}");
        }
        return genFailTag;
    }

    void generateSetters(Method method, Class[] paramTypes) {
        ParameterData paramData;
        Class paramType;
        int criticalCount = 0;
        int i = paramTypes.length - 1;
        while (i >= 0) {
            paramType = paramTypes[i];
            paramData = this.getMetaData().getMetaData(method, i);
            if (this.isCritical(paramType, paramData)) {
                ++criticalCount;
            }
            --i;
        }
        if (criticalCount != 0) {
            this.outputln("#ifdef JNI_VERSION_1_2");
            this.outputln("\tif (IS_JNI_1_2) {");
            i = paramTypes.length - 1;
            while (i >= 0) {
                paramType = paramTypes[i];
                paramData = this.getMetaData().getMetaData(method, i);
                if (this.isCritical(paramType, paramData)) {
                    this.output("\t");
                    this.generateSetParameter(i, paramType, paramData, true);
                }
                --i;
            }
            this.outputln("\t} else");
            this.outputln("#endif");
            this.outputln("\t{");
            i = paramTypes.length - 1;
            while (i >= 0) {
                paramType = paramTypes[i];
                paramData = this.getMetaData().getMetaData(method, i);
                if (this.isCritical(paramType, paramData)) {
                    this.output("\t");
                    this.generateSetParameter(i, paramType, paramData, false);
                }
                --i;
            }
            this.outputln("\t}");
        }
        i = paramTypes.length - 1;
        while (i >= 0) {
            paramType = paramTypes[i];
            paramData = this.getMetaData().getMetaData(method, i);
            if (!this.isCritical(paramType, paramData)) {
                this.generateSetParameter(i, paramType, paramData, false);
            }
            --i;
        }
    }

    void generateDynamicFunctionCall(Method method, MethodData methodData, Class[] paramTypes, Class returnType, boolean needsReturn) {
        this.outputln("/*");
        this.generateFunctionCall(method, methodData, paramTypes, returnType, needsReturn);
        this.outputln("*/");
        this.outputln("\t{");
        String name = method.getName();
        if (name.startsWith("_")) {
            name = name.substring(1);
        }
        if (this.getPlatform().equals("win32")) {
            this.outputln("\t\tstatic int initialized = 0;");
            this.outputln("\t\tstatic HMODULE hm = NULL;");
            this.outputln("\t\tstatic FARPROC fp = NULL;");
            if (returnType != Void.TYPE && needsReturn) {
                this.outputln("\t\trc = 0;");
            }
            this.outputln("\t\tif (!initialized) {");
            this.output("\t\t\tif (!hm) hm = LoadLibrary(");
            this.output(name);
            this.outputln("_LIB);");
            this.output("\t\t\tif (hm) fp = GetProcAddress(hm, \"");
            this.output(name);
            this.outputln("\");");
            this.outputln("\t\t\tinitialized = 1;");
            this.outputln("\t\t}");
            this.outputln("\t\tif (fp) {");
            this.output("\t\t");
            this.generateFunctionCallLeftSide(method, methodData, returnType, needsReturn);
            this.output("fp");
            this.generateFunctionCallRightSide(method, methodData, paramTypes, 0);
            this.output(";");
            this.outputln();
            this.outputln("\t\t}");
        } else if (this.getPlatform().equals("carbon") || this.getPlatform().equals("cocoa")) {
            this.outputln("\t\tstatic int initialized = 0;");
            this.outputln("\t\tstatic CFBundleRef bundle = NULL;");
            this.output("\t\ttypedef ");
            this.output(NativesGenerator.getTypeSignature2(returnType));
            this.output(" (*FPTR)(");
            int i = 0;
            while (i < paramTypes.length) {
                if (i != 0) {
                    this.output(", ");
                }
                Class paramType = paramTypes[i];
                ParameterData paramData = this.getMetaData().getMetaData(method, i);
                String cast = paramData.getCast();
                if (cast.length() > 2) {
                    this.output(cast.substring(1, cast.length() - 1));
                } else {
                    this.output(NativesGenerator.getTypeSignature4(paramType, paramData.getFlag("struct")));
                }
                ++i;
            }
            this.outputln(");");
            this.outputln("\t\tstatic FPTR fptr;");
            if (returnType != Void.TYPE && needsReturn) {
                this.outputln("\t\trc = 0;");
            }
            this.outputln("\t\tif (!initialized) {");
            this.output("\t\t\tif (!bundle) bundle = CFBundleGetBundleWithIdentifier(CFSTR(");
            this.output(name);
            this.outputln("_LIB));");
            this.output("\t\t\tif (bundle) fptr = (FPTR)CFBundleGetFunctionPointerForName(bundle, CFSTR(\"");
            this.output(name);
            this.outputln("\"));");
            this.outputln("\t\t\tinitialized = 1;");
            this.outputln("\t\t}");
            this.outputln("\t\tif (fptr) {");
            this.output("\t\t");
            this.generateFunctionCallLeftSide(method, methodData, returnType, needsReturn);
            this.output("(*fptr)");
            this.generateFunctionCallRightSide(method, methodData, paramTypes, 0);
            this.output(";");
            this.outputln();
            this.outputln("\t\t}");
        } else {
            this.outputln("\t\tstatic int initialized = 0;");
            this.outputln("\t\tstatic void *handle = NULL;");
            this.output("\t\ttypedef ");
            this.output(NativesGenerator.getTypeSignature2(returnType));
            this.output(" (*FPTR)(");
            int i = 0;
            while (i < paramTypes.length) {
                if (i != 0) {
                    this.output(", ");
                }
                Class paramType = paramTypes[i];
                ParameterData paramData = this.getMetaData().getMetaData(method, i);
                String cast = paramData.getCast();
                if (cast.length() > 2) {
                    this.output(cast.substring(1, cast.length() - 1));
                } else {
                    this.output(NativesGenerator.getTypeSignature4(paramType, paramData.getFlag("struct")));
                }
                ++i;
            }
            this.outputln(");");
            this.outputln("\t\tstatic FPTR fptr;");
            if (returnType != Void.TYPE && needsReturn) {
                this.outputln("\t\trc = 0;");
            }
            this.outputln("\t\tif (!initialized) {");
            this.output("\t\t\tif (!handle) handle = dlopen(");
            this.output(name);
            this.outputln("_LIB, RTLD_LAZY);");
            this.output("\t\t\tif (handle) fptr = (FPTR)dlsym(handle, \"");
            this.output(name);
            this.outputln("\");");
            this.outputln("\t\t\tinitialized = 1;");
            this.outputln("\t\t}");
            this.outputln("\t\tif (fptr) {");
            this.output("\t\t");
            this.generateFunctionCallLeftSide(method, methodData, returnType, needsReturn);
            this.output("(*fptr)");
            this.generateFunctionCallRightSide(method, methodData, paramTypes, 0);
            this.output(";");
            this.outputln();
            this.outputln("\t\t}");
        }
        this.outputln("\t}");
    }

    void generateFunctionCallLeftSide(Method method, MethodData methodData, Class returnType, boolean needsReturn) {
        this.output("\t");
        if (returnType != Void.TYPE) {
            if (needsReturn) {
                this.output("rc = ");
            } else {
                this.output("return ");
            }
            this.output("(");
            this.output(NativesGenerator.getTypeSignature2(returnType));
            this.output(")");
        }
        if (methodData.getFlag("address")) {
            this.output("&");
        }
        if (methodData.getFlag("jni")) {
            this.output(this.isCPP ? "env->" : "(*env)->");
        }
    }

    void generateFunctionCallRightSide(Method method, MethodData methodData, Class[] paramTypes, int paramStart) {
        if (!methodData.getFlag("const")) {
            this.output("(");
            if (methodData.getFlag("jni") && !this.isCPP) {
                this.output("env, ");
            }
            int i = paramStart;
            while (i < paramTypes.length) {
                Class paramType = paramTypes[i];
                ParameterData paramData = this.getMetaData().getMetaData(method, i);
                if (i != paramStart) {
                    this.output(", ");
                }
                if (paramData.getFlag("struct")) {
                    this.output("*");
                }
                this.output(paramData.getCast());
                if (paramData.getFlag("gcobject")) {
                    this.output("TO_OBJECT(");
                }
                if (i == paramTypes.length - 1 && paramData.getFlag("sentinel")) {
                    this.output("NULL");
                } else {
                    if (!paramType.isPrimitive() && !this.isSystemClass(paramType)) {
                        this.output("lp");
                    }
                    this.output("arg" + i);
                }
                if (paramData.getFlag("gcobject")) {
                    this.output(")");
                }
                ++i;
            }
            this.output(")");
        }
    }

    void generateFunctionCall(Method method, MethodData methodData, Class[] paramTypes, Class returnType, boolean needsReturn) {
        boolean makeCopy;
        String copy = (String)methodData.getParam("copy");
        boolean bl = makeCopy = copy.length() != 0 && this.isCPP && returnType != Void.TYPE;
        if (makeCopy) {
            this.output("\t");
            this.output(copy);
            this.output(" temp = ");
        } else {
            this.generateFunctionCallLeftSide(method, methodData, returnType, needsReturn);
        }
        int paramStart = 0;
        String name = method.getName();
        if (name.startsWith("_")) {
            name = name.substring(1);
        }
        if (name.equalsIgnoreCase("call")) {
            this.output("(");
            ParameterData paramData = this.getMetaData().getMetaData(method, 0);
            String cast = paramData.getCast();
            if (cast.length() != 0 && !cast.equals("()")) {
                this.output(cast);
            } else {
                this.output("(");
                this.output(NativesGenerator.getTypeSignature2(returnType));
                this.output(" (*)())");
            }
            this.output("arg0)");
            paramStart = 1;
        } else if (name.startsWith("VtblCall")) {
            this.output("((");
            this.output(NativesGenerator.getTypeSignature2(returnType));
            this.output(" (STDMETHODCALLTYPE *)(");
            int i = 1;
            while (i < paramTypes.length) {
                if (i != 1) {
                    this.output(", ");
                }
                Class paramType = paramTypes[i];
                this.output(NativesGenerator.getTypeSignature4(paramType));
                ++i;
            }
            this.output("))(*(");
            this.output(NativesGenerator.getTypeSignature4(paramTypes[1]));
            this.output(" **)arg1)[arg0])");
            paramStart = 1;
        } else if (methodData.getFlag("cpp") || methodData.getFlag("setter") || methodData.getFlag("getter") || methodData.getFlag("adder")) {
            String cast;
            if (methodData.getFlag("gcobject")) {
                this.output("TO_HANDLE(");
            }
            this.output("(");
            ParameterData paramData = this.getMetaData().getMetaData(method, 0);
            if (paramData.getFlag("struct")) {
                this.output("*");
            }
            if ((cast = paramData.getCast()).length() != 0 && !cast.equals("()")) {
                this.output(cast);
            }
            if (paramData.getFlag("gcobject")) {
                this.output("TO_OBJECT(");
            }
            this.output("arg0");
            if (paramData.getFlag("gcobject")) {
                this.output(")");
            }
            this.output(")->");
            String accessor = methodData.getAccessor();
            if (accessor.length() != 0) {
                this.output(accessor);
            } else {
                int index = -1;
                index = name.indexOf(95);
                if (index != -1) {
                    this.output(name.substring(index + 1, name.length()));
                } else {
                    this.output(name);
                }
            }
            paramStart = 1;
        } else if (methodData.getFlag("gcnew")) {
            this.output("TO_HANDLE(gcnew ");
            String accessor = methodData.getAccessor();
            if (accessor.length() != 0) {
                this.output(accessor);
            } else {
                int index = -1;
                index = name.indexOf(95);
                if (index != -1) {
                    this.output(name.substring(index + 1));
                } else {
                    this.output(name);
                }
            }
        } else if (methodData.getFlag("new")) {
            this.output("new ");
            String accessor = methodData.getAccessor();
            if (accessor.length() != 0) {
                this.output(accessor);
            } else {
                int index = -1;
                index = name.indexOf(95);
                if (index != -1) {
                    this.output(name.substring(0, index));
                } else {
                    this.output(name);
                }
            }
        } else {
            String accessor;
            if (methodData.getFlag("delete")) {
                this.output("delete ");
                ParameterData paramData = this.getMetaData().getMetaData(method, 0);
                String cast = paramData.getCast();
                if (cast.length() != 0 && !cast.equals("()")) {
                    this.output(cast);
                } else {
                    this.output("(");
                    this.output(name.substring(0, name.indexOf("_")));
                    this.output(" *)");
                }
                this.outputln("arg0;");
                return;
            }
            if (methodData.getFlag("gcobject")) {
                this.output("TO_HANDLE(");
            }
            if (methodData.getFlag("cast")) {
                this.output("((");
                this.output(NativesGenerator.getTypeSignature2(returnType));
                this.output(" (*)(");
                int i = 0;
                while (i < paramTypes.length) {
                    if (i != 0) {
                        this.output(", ");
                    }
                    Class paramType = paramTypes[i];
                    ParameterData paramData = this.getMetaData().getMetaData(method, i);
                    String cast = paramData.getCast();
                    if (cast != null && cast.length() != 0) {
                        if (cast.startsWith("(")) {
                            cast = cast.substring(1);
                        }
                        if (cast.endsWith(")")) {
                            cast = cast.substring(0, cast.length() - 1);
                        }
                        this.output(cast);
                    } else {
                        this.output(NativesGenerator.getTypeSignature4(paramType, paramData.getFlag("struct")));
                    }
                    ++i;
                }
                this.output("))");
            }
            if ((accessor = methodData.getAccessor()).length() != 0) {
                this.output(accessor);
            } else {
                this.output(name);
            }
            if (methodData.getFlag("cast")) {
                this.output(")");
            }
        }
        if (methodData.getFlag("setter") && paramTypes.length == 3 || methodData.getFlag("getter") && paramTypes.length == 2) {
            this.output("[arg1]");
            ++paramStart;
        }
        if (methodData.getFlag("setter")) {
            this.output(" = ");
        }
        if (methodData.getFlag("adder")) {
            this.output(" += ");
        }
        if (!methodData.getFlag("getter")) {
            this.generateFunctionCallRightSide(method, methodData, paramTypes, paramStart);
        }
        if (methodData.getFlag("gcnew") || methodData.getFlag("gcobject")) {
            this.output(")");
        }
        this.output(";");
        this.outputln();
        if (makeCopy) {
            this.outputln("\t{");
            this.output("\t\t");
            this.output(copy);
            this.output("* copy = new ");
            this.output(copy);
            this.outputln("();");
            this.outputln("\t\t*copy = temp;");
            this.output("\t\trc = ");
            this.output("(");
            this.output(NativesGenerator.getTypeSignature2(returnType));
            this.output(")");
            this.outputln("copy;");
            this.outputln("\t}");
        }
    }

    void generateReturn(Method method, Class returnType, boolean needsReturn) {
        if (needsReturn && returnType != Void.TYPE) {
            this.outputln("\treturn rc;");
        }
    }

    void generateMemmove(Method method, String function, Class[] paramTypes) {
        this.generateEnterMacro(method, function);
        this.output("\t");
        boolean get = paramTypes[0].isPrimitive();
        String className = NativesGenerator.getClassName(paramTypes[get ? 1 : 0]);
        this.output(get ? "if (arg1) get" : "if (arg0) set");
        this.output(className);
        this.output(get ? "Fields(env, arg1, (" : "Fields(env, arg0, (");
        this.output(className);
        this.output(get ? " *)arg0)" : " *)arg1)");
        this.outputln(";");
        this.generateExitMacro(method, function);
    }

    void generateFunctionBody(Method method, MethodData methodData, String function, Class[] paramTypes, Class returnType) {
        boolean isMemove;
        this.outputln("{");
        String name = method.getName();
        if (name.startsWith("_")) {
            name = name.substring(1);
        }
        boolean bl = isMemove = (name.equals("memmove") || name.equals("MoveMemory")) && paramTypes.length == 2 && returnType == Void.TYPE;
        if (isMemove) {
            this.generateMemmove(method, function, paramTypes);
        } else {
            boolean needsReturn = this.generateLocalVars(method, paramTypes, returnType);
            this.generateEnterMacro(method, function);
            boolean genFailTag = this.generateGetters(method, paramTypes);
            if (methodData.getFlag("dynamic")) {
                this.generateDynamicFunctionCall(method, methodData, paramTypes, returnType, needsReturn);
            } else {
                this.generateFunctionCall(method, methodData, paramTypes, returnType, needsReturn);
            }
            if (genFailTag) {
                this.outputln("fail:");
            }
            this.generateSetters(method, paramTypes);
            this.generateExitMacro(method, function);
            this.generateReturn(method, returnType, needsReturn);
        }
        this.outputln("}");
    }

    void generateFunctionPrototype(Method method, String function, Class[] paramTypes, Class returnType, boolean singleLine) {
        this.output("JNIEXPORT ");
        this.output(NativesGenerator.getTypeSignature2(returnType));
        this.output(" JNICALL ");
        this.output(NativesGenerator.getClassName(method.getDeclaringClass()));
        this.output("_NATIVE(");
        this.output(function);
        if (singleLine) {
            this.output(")");
            this.output("(JNIEnv *env, ");
        } else {
            this.outputln(")");
            this.output("\t(JNIEnv *env, ");
        }
        if ((method.getModifiers() & 8) != 0) {
            this.output("jclass");
        } else {
            this.output("jobject");
        }
        this.output(" that");
        int i = 0;
        while (i < paramTypes.length) {
            Class paramType = paramTypes[i];
            this.output(", ");
            this.output(NativesGenerator.getTypeSignature2(paramType));
            this.output(" arg" + i);
            ++i;
        }
        this.output(")");
        if (!singleLine) {
            this.outputln();
        }
    }

    void generateSourceStart(String function) {
        this.output("#ifndef NO_");
        this.outputln(function);
    }

    void generateSourceEnd(String function) {
        this.outputln("#endif");
    }

    boolean isCritical(Class paramType, ParameterData paramData) {
        return paramType.isArray() && paramType.getComponentType().isPrimitive() && paramData.getFlag("critical");
    }

    boolean isSystemClass(Class type) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type != clazz) {
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.lang.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (type != clazz2) {
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java NativesGenerator <className1> <className2>");
            return;
        }
        try {
            NativesGenerator gen = new NativesGenerator();
            int i = 0;
            while (i < args.length) {
                String clazzName = args[i];
                Class<?> clazz = Class.forName(clazzName);
                gen.generate(clazz);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }
}

