/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.functions;

import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.NumberResult;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.FunctionCall;

public class SumFunctionCall
extends FunctionCall {
    private static final String SUM = "sum";

    public SumFunctionCall() {
        super(SUM);
    }

    public double computeSum(NodeSet nodeSet) {
        double d = 0.0;
        int n = 0;
        while (n < nodeSet.size()) {
            d += this.getNodeValue(nodeSet.item(n));
            ++n;
        }
        return d;
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        if (this.getParameterCount() != 1) {
            throw new XPathException("invalid number of parameters for function: " + this);
        }
        XPathResult xPathResult = this.getParameter(0).evaluate(xPathContext);
        if (xPathResult.getResultType() != 3) {
            throw new XPathException("unexpected result for function: " + this + " a node-set was expected");
        }
        NodeSet nodeSet = (NodeSet)xPathResult;
        return new NumberResult(this.computeSum(nodeSet));
    }

    private double getNodeValue(XPathNode xPathNode) {
        String string = xPathNode.getStringValue();
        double d = 0.0;
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }
}

