/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.NumberResult;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathResult;

class MultiplicativeExpr
extends XPathExpression {
    public static final short MULTIPLY = 0;
    public static final short DIVIDE = 1;
    public static final short MODULUS = 2;
    public static final short QUOTIENT = 3;
    private XPathExpression leftExpr = null;
    private XPathExpression rightExpr = null;
    private short op = 0;
    private static final String[] ops = new String[]{"*", "div", "mod", "quo"};

    public MultiplicativeExpr(XPathExpression xPathExpression, XPathExpression xPathExpression2) {
        if (xPathExpression == null) {
            throw new IllegalArgumentException("Argument leftExpr is null");
        }
        if (xPathExpression2 == null) {
            throw new IllegalArgumentException("Argument rightExpr is null");
        }
        this.leftExpr = xPathExpression;
        this.rightExpr = xPathExpression2;
    }

    public MultiplicativeExpr(XPathExpression xPathExpression, XPathExpression xPathExpression2, String string) throws XPathException {
        this(xPathExpression, xPathExpression2);
        this.op = (short)-1;
        if (string != null) {
            this.op = 0;
            while (this.op < ops.length) {
                if (ops[this.op].equals(string)) break;
                this.op = (short)(this.op + 1);
            }
        }
        if (this.op < 0 || this.op >= ops.length) {
            throw new XPathException("invalid operator for multiplicative expression");
        }
    }

    public MultiplicativeExpr(XPathExpression xPathExpression, XPathExpression xPathExpression2, short s) throws XPathException {
        this(xPathExpression, xPathExpression2);
        if (s < 0 || s >= ops.length) {
            throw new XPathException("invalid operator for multiplicative expression");
        }
        this.op = s;
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        double d = 0.0;
        if (this.leftExpr == null || this.rightExpr == null) {
            return NumberResult.NaN;
        }
        double d2 = this.leftExpr.evaluate(xPathContext).numberValue();
        double d3 = this.rightExpr.evaluate(xPathContext).numberValue();
        switch (this.op) {
            case 0: {
                d = d2 * d3;
                break;
            }
            case 1: {
                d = d2 / d3;
                break;
            }
            case 2: {
                d = d2 % d3;
                break;
            }
            case 3: {
                d = Math.floor(d2 / d3);
                break;
            }
        }
        return new NumberResult(d);
    }

    public short getExprType() {
        return 4;
    }

    public static boolean isMultiplicativeOperator(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < ops.length) {
            if (ops[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.leftExpr != null) {
            stringBuffer.append(this.leftExpr.toString());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(" ");
        stringBuffer.append(ops[this.op]);
        stringBuffer.append(" ");
        if (this.rightExpr != null) {
            stringBuffer.append(this.rightExpr.toString());
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }
}

